/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.work.batch;

import oadd.io.netty.buffer.ByteBuf;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.proto.ExecProtos;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.helper.QueryIdHelper;
import oadd.org.apache.drill.exec.rpc.Acks;
import oadd.org.apache.drill.exec.rpc.Response;
import oadd.org.apache.drill.exec.rpc.RpcBus;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.UserRpcException;
import oadd.org.apache.drill.exec.rpc.control.ControlConnection;
import oadd.org.apache.drill.exec.rpc.control.ControlRpcConfig;
import oadd.org.apache.drill.exec.rpc.control.ControlTunnel;
import oadd.org.apache.drill.exec.server.DrillbitContext;
import oadd.org.apache.drill.exec.work.WorkManager;
import oadd.org.apache.drill.exec.work.foreman.Foreman;
import oadd.org.apache.drill.exec.work.fragment.FragmentExecutor;
import oadd.org.apache.drill.exec.work.fragment.FragmentManager;
import oadd.org.apache.drill.exec.work.fragment.FragmentStatusReporter;
import oadd.org.apache.drill.exec.work.fragment.NonRootFragmentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlMessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(ControlMessageHandler.class);
    private final WorkManager.WorkerBee bee;

    public ControlMessageHandler(WorkManager.WorkerBee bee) {
        this.bee = bee;
    }

    public Response handle(ControlConnection connection, int rpcType, ByteBuf pBody, ByteBuf dBody) throws RpcException {
        switch (rpcType) {
            case 6: {
                ExecProtos.FragmentHandle handle = RpcBus.get(pBody, ExecProtos.FragmentHandle.PARSER);
                this.cancelFragment(handle);
                return ControlRpcConfig.OK;
            }
            case 7: {
                BitControl.FinishedReceiver finishedReceiver = RpcBus.get(pBody, BitControl.FinishedReceiver.PARSER);
                this.receivingFragmentFinished(finishedReceiver);
                return ControlRpcConfig.OK;
            }
            case 8: {
                this.bee.getContext().getWorkBus().statusUpdate(RpcBus.get(pBody, BitControl.FragmentStatus.PARSER));
                return ControlRpcConfig.OK;
            }
            case 15: {
                UserBitShared.QueryId queryId = RpcBus.get(pBody, UserBitShared.QueryId.PARSER);
                Foreman foreman = this.bee.getForemanForQueryId(queryId);
                if (foreman != null) {
                    foreman.cancel();
                    return ControlRpcConfig.OK;
                }
                return ControlRpcConfig.FAIL;
            }
            case 3: {
                BitControl.InitializeFragments fragments = RpcBus.get(pBody, BitControl.InitializeFragments.PARSER);
                for (int i = 0; i < fragments.getFragmentCount(); ++i) {
                    this.startNewRemoteFragment(fragments.getFragment(i));
                }
                return ControlRpcConfig.OK;
            }
            case 10: {
                UserBitShared.QueryId queryId = RpcBus.get(pBody, UserBitShared.QueryId.PARSER);
                Foreman foreman = this.bee.getForemanForQueryId(queryId);
                if (foreman == null) {
                    throw new RpcException("Query not running on node.");
                }
                UserBitShared.QueryProfile profile = foreman.getQueryManager().getQueryProfile();
                return new Response(BitControl.RpcType.RESP_QUERY_STATUS, profile, new ByteBuf[0]);
            }
            case 16: {
                ExecProtos.FragmentHandle handle = RpcBus.get(pBody, ExecProtos.FragmentHandle.PARSER);
                this.resumeFragment(handle);
                return ControlRpcConfig.OK;
            }
        }
        throw new RpcException("Not yet supported.");
    }

    private void startNewRemoteFragment(BitControl.PlanFragment fragment) throws UserRpcException {
        logger.debug("Received remote fragment start instruction", (Object)fragment);
        DrillbitContext drillbitContext = this.bee.getContext();
        try {
            if (fragment.getLeafFragment()) {
                FragmentContext context = new FragmentContext(drillbitContext, fragment, drillbitContext.getFunctionImplementationRegistry());
                ControlTunnel tunnel = drillbitContext.getController().getTunnel(fragment.getForeman());
                FragmentStatusReporter statusReporter = new FragmentStatusReporter(context, tunnel);
                FragmentExecutor fr = new FragmentExecutor(context, fragment, statusReporter);
                this.bee.addFragmentRunner(fr);
            } else {
                NonRootFragmentManager manager = new NonRootFragmentManager(fragment, drillbitContext);
                drillbitContext.getWorkBus().addFragmentManager((FragmentManager)manager);
            }
        }
        catch (Exception e) {
            throw new UserRpcException(drillbitContext.getEndpoint(), "Failure while trying to start remote fragment", e);
        }
        catch (OutOfMemoryError t) {
            if (t.getMessage().startsWith("Direct buffer")) {
                throw new UserRpcException(drillbitContext.getEndpoint(), "Out of direct memory while trying to start remote fragment", t);
            }
            throw t;
        }
    }

    private GeneralRPCProtos.Ack cancelFragment(ExecProtos.FragmentHandle handle) {
        boolean removed = this.bee.getContext().getWorkBus().cancelAndRemoveFragmentManagerIfExists(handle);
        if (removed) {
            return Acks.OK;
        }
        FragmentExecutor runner = this.bee.getFragmentRunner(handle);
        if (runner != null) {
            runner.cancel();
            return Acks.OK;
        }
        logger.warn("Dropping request to cancel fragment. {} does not exist.", (Object)QueryIdHelper.getQueryIdentifier(handle));
        return Acks.OK;
    }

    private GeneralRPCProtos.Ack resumeFragment(ExecProtos.FragmentHandle handle) {
        FragmentManager manager = this.bee.getContext().getWorkBus().getFragmentManagerIfExists(handle);
        if (manager != null) {
            manager.unpause();
            return Acks.OK;
        }
        FragmentExecutor runner = this.bee.getFragmentRunner(handle);
        if (runner != null) {
            runner.unpause();
            return Acks.OK;
        }
        logger.warn("Dropping request to resume fragment. {} does not exist.", (Object)QueryIdHelper.getQueryIdentifier(handle));
        return Acks.OK;
    }

    private GeneralRPCProtos.Ack receivingFragmentFinished(BitControl.FinishedReceiver finishedReceiver) {
        FragmentManager manager = this.bee.getContext().getWorkBus().getFragmentManagerIfExists(finishedReceiver.getSender());
        if (manager != null) {
            manager.receivingFragmentFinished(finishedReceiver.getReceiver());
        } else {
            FragmentExecutor executor = this.bee.getFragmentRunner(finishedReceiver.getSender());
            if (executor != null) {
                executor.receivingFragmentFinished(finishedReceiver.getReceiver());
            } else {
                logger.warn("Dropping request for early fragment termination for path {} -> {} as path to executor unavailable.", (Object)QueryIdHelper.getQueryIdentifier(finishedReceiver.getSender()), (Object)QueryIdHelper.getQueryIdentifier(finishedReceiver.getReceiver()));
            }
        }
        return Acks.OK;
    }
}

