/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.work.batch;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.drill.common.AutoCloseables;
import oadd.org.apache.drill.exec.memory.OutOfMemoryException;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.record.RawFragmentBatch;
import oadd.org.apache.drill.exec.util.ArrayWrappedIntIntMap;
import oadd.org.apache.drill.exec.work.batch.DataCollector;
import oadd.org.apache.drill.exec.work.batch.RawBatchBuffer;
import oadd.org.apache.drill.exec.work.batch.SpoolingRawBatchBuffer;
import oadd.org.apache.drill.exec.work.batch.UnlimitedRawBatchBuffer;

public abstract class AbstractDataCollector
implements DataCollector {
    private final int oppositeMajorFragmentId;
    private final AtomicIntegerArray remainders;
    private final AtomicInteger remainingRequired;
    private final AtomicInteger parentAccounter;
    private final int incomingStreams;
    protected final RawBatchBuffer[] buffers;
    protected final ArrayWrappedIntIntMap fragmentMap;

    public AbstractDataCollector(AtomicInteger parentAccounter, int numBuffers, BitControl.Collector collector, int bufferCapacity, FragmentContext context) {
        Preconditions.checkNotNull(collector);
        Preconditions.checkNotNull(parentAccounter);
        this.incomingStreams = collector.getIncomingMinorFragmentCount();
        this.parentAccounter = parentAccounter;
        this.remainders = new AtomicIntegerArray(this.incomingStreams);
        this.oppositeMajorFragmentId = collector.getOppositeMajorFragmentId();
        this.fragmentMap = new ArrayWrappedIntIntMap();
        int index = 0;
        for (Integer endpoint : collector.getIncomingMinorFragmentList()) {
            this.fragmentMap.put(endpoint, index);
            ++index;
        }
        this.buffers = new RawBatchBuffer[numBuffers];
        this.remainingRequired = new AtomicInteger(numBuffers);
        boolean spooling = collector.getIsSpooling();
        try {
            for (int i = 0; i < numBuffers; ++i) {
                this.buffers[i] = spooling ? new SpoolingRawBatchBuffer(context, bufferCapacity, collector.getOppositeMajorFragmentId(), i) : new UnlimitedRawBatchBuffer(context, bufferCapacity, collector.getOppositeMajorFragmentId());
            }
        }
        catch (IOException | OutOfMemoryException e) {
            logger.error("Exception", e);
            context.fail(e);
        }
    }

    @Override
    public int getOppositeMajorFragmentId() {
        return this.oppositeMajorFragmentId;
    }

    @Override
    public RawBatchBuffer[] getBuffers() {
        return this.buffers;
    }

    @Override
    public boolean batchArrived(int minorFragmentId, RawFragmentBatch batch) throws IOException {
        int rem;
        if (batch.getHeader().getIsOutOfMemory()) {
            for (RawBatchBuffer buffer : this.buffers) {
                buffer.enqueue(batch);
            }
        }
        boolean decremented = false;
        if (this.remainders.compareAndSet(this.fragmentMap.get(minorFragmentId), 0, 1) && (rem = this.remainingRequired.decrementAndGet()) == 0) {
            this.parentAccounter.decrementAndGet();
            decremented = true;
        }
        this.getBuffer(minorFragmentId).enqueue(batch);
        return decremented;
    }

    @Override
    public int getTotalIncomingFragments() {
        return this.incomingStreams;
    }

    protected abstract RawBatchBuffer getBuffer(int var1);

    @Override
    public void close() throws Exception {
        AutoCloseables.close(this.buffers);
    }
}

