/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.VectorContainer;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.MapVector;
import oadd.org.apache.drill.exec.vector.complex.StateTool;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;
import oadd.org.apache.drill.exec.vector.complex.impl.SingleListWriter;
import oadd.org.apache.drill.exec.vector.complex.impl.SingleMapWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;

public class ComplexWriterImpl
extends AbstractFieldWriter
implements BaseWriter.ComplexWriter {
    private SingleMapWriter mapRoot;
    private SingleListWriter listRoot;
    private final MapVector container;
    Mode mode = Mode.INIT;
    private final String name;
    private final boolean unionEnabled;

    public ComplexWriterImpl(String name, MapVector container, boolean unionEnabled) {
        super(null);
        this.name = name;
        this.container = container;
        this.unionEnabled = unionEnabled;
    }

    public ComplexWriterImpl(String name, MapVector container) {
        this(name, container, false);
    }

    @Override
    public MaterializedField getField() {
        return this.container.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.container.getValueCapacity();
    }

    private void check(Mode ... modes) {
        StateTool.check((Enum)this.mode, (Enum[])modes);
    }

    @Override
    public void reset() {
        this.setPosition(0);
    }

    @Override
    public void close() throws Exception {
        this.clear();
        this.mapRoot.close();
        if (this.listRoot != null) {
            this.listRoot.close();
        }
    }

    @Override
    public void clear() {
        switch (this.mode) {
            case MAP: {
                this.mapRoot.clear();
                break;
            }
            case LIST: {
                this.listRoot.clear();
            }
        }
    }

    @Override
    public void setValueCount(int count) {
        switch (this.mode) {
            case MAP: {
                this.mapRoot.setValueCount(count);
                break;
            }
            case LIST: {
                this.listRoot.setValueCount(count);
            }
        }
    }

    @Override
    public void setPosition(int index) {
        super.setPosition(index);
        switch (this.mode) {
            case MAP: {
                this.mapRoot.setPosition(index);
                break;
            }
            case LIST: {
                this.listRoot.setPosition(index);
            }
        }
    }

    public BaseWriter.MapWriter directMap() {
        Preconditions.checkArgument(this.name == null);
        switch (this.mode) {
            case INIT: {
                MapVector map = this.container;
                this.mapRoot = new SingleMapWriter(map, this, this.unionEnabled);
                this.mapRoot.setPosition(this.idx());
                this.mode = Mode.MAP;
                break;
            }
            case MAP: {
                break;
            }
            default: {
                this.check(Mode.INIT, Mode.MAP);
            }
        }
        return this.mapRoot;
    }

    @Override
    public BaseWriter.MapWriter rootAsMap() {
        switch (this.mode) {
            case INIT: {
                MapVector map = this.container.addOrGet(this.name, Types.required(TypeProtos.MinorType.MAP), MapVector.class);
                this.mapRoot = new SingleMapWriter(map, this, this.unionEnabled);
                this.mapRoot.setPosition(this.idx());
                this.mode = Mode.MAP;
                break;
            }
            case MAP: {
                break;
            }
            default: {
                this.check(Mode.INIT, Mode.MAP);
            }
        }
        return this.mapRoot;
    }

    @Override
    public void allocate() {
        if (this.mapRoot != null) {
            this.mapRoot.allocate();
        } else if (this.listRoot != null) {
            this.listRoot.allocate();
        }
    }

    @Override
    public BaseWriter.ListWriter rootAsList() {
        switch (this.mode) {
            case INIT: {
                this.listRoot = new SingleListWriter(this.name, this.container, this);
                this.listRoot.setPosition(this.idx());
                this.mode = Mode.LIST;
                break;
            }
            case LIST: {
                break;
            }
            default: {
                this.check(Mode.INIT, Mode.MAP);
            }
        }
        return this.listRoot;
    }

    public static BaseWriter.ComplexWriter getWriter(String name, VectorContainer container) {
        VectorAccessibleFacade vc = new VectorAccessibleFacade(container);
        return new ComplexWriterImpl(name, vc);
    }

    private static class VectorAccessibleFacade
    extends MapVector {
        private final VectorContainer vc;

        public VectorAccessibleFacade(VectorContainer vc) {
            super("", null, null);
            this.vc = vc;
        }

        @Override
        public <T extends ValueVector> T addOrGet(String name, TypeProtos.MajorType type, Class<T> clazz) {
            T v = this.vc.addOrGet(name, type, clazz);
            this.putChild(name, (ValueVector)v);
            return this.typeify((ValueVector)v, clazz);
        }
    }

    private static enum Mode {
        INIT,
        MAP,
        LIST;

    }
}

