/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex;

import java.util.ArrayList;
import java.util.Iterator;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Lists;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.expression.FieldReference;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.holders.ComplexHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedListHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.CallBack;
import oadd.org.apache.drill.exec.util.JsonStringArrayList;
import oadd.org.apache.drill.exec.vector.AddOrGetResult;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorDescriptor;
import oadd.org.apache.drill.exec.vector.complex.AbstractContainerVector;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.EmptyValuePopulator;
import oadd.org.apache.drill.exec.vector.complex.RepeatedFixedWidthVectorLike;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.VectorWithOrdinal;
import oadd.org.apache.drill.exec.vector.complex.impl.NullReader;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedListReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;

public class RepeatedListVector
extends AbstractContainerVector
implements RepeatedValueVector,
RepeatedFixedWidthVectorLike {
    public static final TypeProtos.MajorType TYPE = Types.repeated(TypeProtos.MinorType.LIST);
    private final RepeatedListReaderImpl reader = new RepeatedListReaderImpl(null, this);
    private final DelegateRepeatedVector delegate;

    public RepeatedListVector(SchemaPath path, BufferAllocator allocator, CallBack callBack) {
        this(MaterializedField.create(path, TYPE), allocator, callBack);
    }

    public RepeatedListVector(MaterializedField field, BufferAllocator allocator, CallBack callBack) {
        this(field, allocator, callBack, new DelegateRepeatedVector(field, allocator));
    }

    protected RepeatedListVector(MaterializedField field, BufferAllocator allocator, CallBack callBack, DelegateRepeatedVector delegate) {
        super(field, allocator, callBack);
        boolean hasChild;
        this.delegate = Preconditions.checkNotNull(delegate);
        ArrayList<MaterializedField> children = Lists.newArrayList(field.getChildren());
        int childSize = children.size();
        assert (childSize < 3);
        boolean bl = hasChild = childSize > 0;
        if (hasChild) {
            MaterializedField child = (MaterializedField)children.get(childSize - 1);
            this.addOrGetVector(VectorDescriptor.create(child));
        }
    }

    @Override
    public RepeatedListReaderImpl getReader() {
        return this.reader;
    }

    @Override
    public DelegateRepeatedVector.RepeatedListAccessor getAccessor() {
        return this.delegate.getAccessor();
    }

    @Override
    public DelegateRepeatedVector.RepeatedListMutator getMutator() {
        return this.delegate.getMutator();
    }

    @Override
    public UInt4Vector getOffsetVector() {
        return this.delegate.getOffsetVector();
    }

    @Override
    public ValueVector getDataVector() {
        return this.delegate.getDataVector();
    }

    @Override
    public void allocateNew() throws OutOfMemoryRuntimeException {
        this.delegate.allocateNew();
    }

    @Override
    public boolean allocateNewSafe() {
        return this.delegate.allocateNewSafe();
    }

    @Override
    public <T extends ValueVector> AddOrGetResult<T> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult result = this.delegate.addOrGetVector(descriptor);
        if (result.isCreated() && this.callBack != null) {
            this.callBack.doWork();
        }
        return result;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public int getBufferSize() {
        return this.delegate.getBufferSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        return this.delegate.getBufferSizeFor(valueCount);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public TransferPair getTransferPair() {
        return new RepeatedListTransferPair(this.delegate.getTransferPair());
    }

    @Override
    public TransferPair getTransferPair(FieldReference ref) {
        return new RepeatedListTransferPair(this.delegate.getTransferPair(ref));
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        RepeatedListVector target = (RepeatedListVector)RepeatedListVector.class.cast(to);
        return new RepeatedListTransferPair(this.delegate.makeTransferPair(target.delegate));
    }

    @Override
    public int getValueCapacity() {
        return this.delegate.getValueCapacity();
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        return this.delegate.getBuffers(clear);
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buf) {
        this.delegate.load(metadata, buf);
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.delegate.getMetadata();
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.delegate.setInitialCapacity(numRecords);
    }

    @Override
    public <T extends ValueVector> T addOrGet(String name, TypeProtos.MajorType type, Class<T> clazz) {
        AddOrGetResult<T> result = this.addOrGetVector(VectorDescriptor.create(type));
        return result.getVector();
    }

    @Override
    public <T extends ValueVector> T getChild(String name, Class<T> clazz) {
        if (name != null) {
            return null;
        }
        return this.typeify(this.delegate.getDataVector(), clazz);
    }

    @Override
    public void allocateNew(int valueCount, int innerValueCount) {
        this.clear();
        this.getOffsetVector().allocateNew(valueCount + 1);
        this.getMutator().reset();
    }

    @Override
    public VectorWithOrdinal getChildVectorWithOrdinal(String name) {
        if (name != null) {
            return null;
        }
        return new VectorWithOrdinal(this.delegate.getDataVector(), 0);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, RepeatedListVector from) {
        this.delegate.copyFromSafe(fromIndex, thisIndex, from.delegate);
    }

    protected class RepeatedListTransferPair
    implements TransferPair {
        private final TransferPair delegate;

        public RepeatedListTransferPair(TransferPair delegate) {
            this.delegate = delegate;
        }

        @Override
        public void transfer() {
            this.delegate.transfer();
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            this.delegate.splitAndTransfer(startIndex, length);
        }

        @Override
        public ValueVector getTo() {
            DelegateRepeatedVector delegateVector = (DelegateRepeatedVector)DelegateRepeatedVector.class.cast(this.delegate.getTo());
            return new RepeatedListVector(RepeatedListVector.this.getField(), RepeatedListVector.this.allocator, RepeatedListVector.this.callBack, delegateVector);
        }

        @Override
        public void copyValueSafe(int from, int to) {
            this.delegate.copyValueSafe(from, to);
        }
    }

    protected static class DelegateRepeatedVector
    extends BaseRepeatedValueVector {
        private final RepeatedListAccessor accessor = new RepeatedListAccessor();
        private final RepeatedListMutator mutator = new RepeatedListMutator();
        private final EmptyValuePopulator emptyPopulator = new EmptyValuePopulator(this.getOffsetVector());
        private transient DelegateTransferPair ephPair;

        public DelegateRepeatedVector(SchemaPath path, BufferAllocator allocator) {
            this(MaterializedField.create(path, TYPE), allocator);
        }

        public DelegateRepeatedVector(MaterializedField field, BufferAllocator allocator) {
            super(field, allocator);
        }

        @Override
        public void allocateNew() throws OutOfMemoryRuntimeException {
            if (!this.allocateNewSafe()) {
                throw new OutOfMemoryRuntimeException();
            }
        }

        @Override
        public TransferPair getTransferPair(FieldReference ref) {
            return this.makeTransferPair(new DelegateRepeatedVector(ref, this.allocator));
        }

        @Override
        public TransferPair makeTransferPair(ValueVector target) {
            return new DelegateTransferPair((DelegateRepeatedVector)DelegateRepeatedVector.class.cast(target));
        }

        @Override
        public RepeatedListAccessor getAccessor() {
            return this.accessor;
        }

        @Override
        public RepeatedListMutator getMutator() {
            return this.mutator;
        }

        @Override
        public FieldReader getReader() {
            throw new UnsupportedOperationException();
        }

        public void copyFromSafe(int fromIndex, int thisIndex, DelegateRepeatedVector from) {
            if (this.ephPair == null || this.ephPair.target != from) {
                this.ephPair = (DelegateTransferPair)DelegateTransferPair.class.cast(from.makeTransferPair(this));
            }
            this.ephPair.copyValueSafe(fromIndex, thisIndex);
        }

        public class DelegateTransferPair
        implements TransferPair {
            private final DelegateRepeatedVector target;
            private final TransferPair[] children;

            public DelegateTransferPair(DelegateRepeatedVector target) {
                this.target = Preconditions.checkNotNull(target);
                if (target.getDataVector() == BaseRepeatedValueVector.DEFAULT_DATA_VECTOR) {
                    target.addOrGetVector(VectorDescriptor.create(DelegateRepeatedVector.this.getDataVector().getField()));
                    target.getDataVector().allocateNew();
                }
                this.children = new TransferPair[]{DelegateRepeatedVector.this.getOffsetVector().makeTransferPair(target.getOffsetVector()), DelegateRepeatedVector.this.getDataVector().makeTransferPair(target.getDataVector())};
            }

            @Override
            public void transfer() {
                for (TransferPair child : this.children) {
                    child.transfer();
                }
            }

            @Override
            public ValueVector getTo() {
                return this.target;
            }

            @Override
            public void splitAndTransfer(int startIndex, int length) {
                this.target.allocateNew();
                for (int i = 0; i < length; ++i) {
                    this.copyValueSafe(startIndex + i, i);
                }
            }

            @Override
            public void copyValueSafe(int srcIndex, int destIndex) {
                RepeatedListHolder holder = new RepeatedListHolder();
                DelegateRepeatedVector.this.getAccessor().get(srcIndex, holder);
                this.target.emptyPopulator.populate(destIndex + 1);
                TransferPair vectorTransfer = this.children[1];
                int newIndex = this.target.getOffsetVector().getAccessor().get(destIndex);
                int i = holder.start;
                while (i < holder.end) {
                    vectorTransfer.copyValueSafe(i, newIndex);
                    ++i;
                    ++newIndex;
                }
                this.target.getOffsetVector().getMutator().setSafe(destIndex + 1, newIndex);
            }
        }

        public class RepeatedListMutator
        extends BaseRepeatedValueVector.BaseRepeatedMutator {
            public int add(int index) {
                int curEnd = DelegateRepeatedVector.this.getOffsetVector().getAccessor().get(index + 1);
                DelegateRepeatedVector.this.getOffsetVector().getMutator().setSafe(index + 1, curEnd + 1);
                return curEnd;
            }

            @Override
            public void startNewValue(int index) {
                DelegateRepeatedVector.this.emptyPopulator.populate(index + 1);
                super.startNewValue(index);
            }

            @Override
            public void setValueCount(int valueCount) {
                DelegateRepeatedVector.this.emptyPopulator.populate(valueCount);
                super.setValueCount(valueCount);
            }
        }

        public class RepeatedListAccessor
        extends BaseRepeatedValueVector.BaseRepeatedAccessor {
            @Override
            public Object getObject(int index) {
                JsonStringArrayList<Object> list = new JsonStringArrayList<Object>();
                int start = DelegateRepeatedVector.this.offsets.getAccessor().get(index);
                int until = DelegateRepeatedVector.this.offsets.getAccessor().get(index + 1);
                for (int i = start; i < until; ++i) {
                    list.add(DelegateRepeatedVector.this.vector.getAccessor().getObject(i));
                }
                return list;
            }

            public void get(int index, RepeatedListHolder holder) {
                assert (index <= DelegateRepeatedVector.this.getValueCapacity());
                holder.start = DelegateRepeatedVector.this.getOffsetVector().getAccessor().get(index);
                holder.end = DelegateRepeatedVector.this.getOffsetVector().getAccessor().get(index + 1);
            }

            public void get(int index, ComplexHolder holder) {
                FieldReader reader = DelegateRepeatedVector.this.getReader();
                reader.setPosition(index);
                holder.reader = reader;
            }

            public void get(int index, int arrayIndex, ComplexHolder holder) {
                RepeatedListHolder listHolder = new RepeatedListHolder();
                this.get(index, listHolder);
                int offset = listHolder.start + arrayIndex;
                if (offset >= listHolder.end) {
                    holder.reader = NullReader.INSTANCE;
                } else {
                    FieldReader r = DelegateRepeatedVector.this.getDataVector().getReader();
                    r.setPosition(offset);
                    holder.reader = r;
                }
            }
        }
    }
}

