/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex;

import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;

public class MapUtility {
    private static final String TYPE_MISMATCH_ERROR = "Mappify/kvgen does not support heterogeneous value types. All values in the input map must be of the same type. The field [%s] has a differing type [%s].";

    public static void writeToMapFromReader(FieldReader fieldReader, BaseWriter.MapWriter mapWriter) {
        try {
            TypeProtos.MajorType valueMajorType = fieldReader.getType();
            TypeProtos.MinorType valueMinorType = valueMajorType.getMinorType();
            boolean repeated = false;
            if (valueMajorType.getMode() == TypeProtos.DataMode.REPEATED) {
                repeated = true;
            }
            switch (valueMinorType) {
                case TINYINT: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").tinyInt());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.tinyInt("value"));
                    break;
                }
                case SMALLINT: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").smallInt());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.smallInt("value"));
                    break;
                }
                case BIGINT: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").bigInt());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.bigInt("value"));
                    break;
                }
                case INT: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").integer());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.integer("value"));
                    break;
                }
                case UINT1: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").uInt1());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.uInt1("value"));
                    break;
                }
                case UINT2: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").uInt2());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.uInt2("value"));
                    break;
                }
                case UINT4: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").uInt4());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.uInt4("value"));
                    break;
                }
                case UINT8: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").uInt8());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.uInt8("value"));
                    break;
                }
                case DECIMAL9: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").decimal9());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.decimal9("value"));
                    break;
                }
                case DECIMAL18: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").decimal18());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.decimal18("value"));
                    break;
                }
                case DECIMAL28SPARSE: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").decimal28Sparse());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.decimal28Sparse("value"));
                    break;
                }
                case DECIMAL38SPARSE: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").decimal38Sparse());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.decimal38Sparse("value"));
                    break;
                }
                case DATE: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").date());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.date("value"));
                    break;
                }
                case TIME: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").time());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.time("value"));
                    break;
                }
                case TIMESTAMP: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").timeStamp());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.timeStamp("value"));
                    break;
                }
                case INTERVAL: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").interval());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.interval("value"));
                    break;
                }
                case INTERVALDAY: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").intervalDay());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.intervalDay("value"));
                    break;
                }
                case INTERVALYEAR: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").intervalYear());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.intervalYear("value"));
                    break;
                }
                case FLOAT4: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").float4());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.float4("value"));
                    break;
                }
                case FLOAT8: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").float8());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.float8("value"));
                    break;
                }
                case BIT: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").bit());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.bit("value"));
                    break;
                }
                case VARCHAR: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").varChar());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.varChar("value"));
                    break;
                }
                case VARBINARY: {
                    if (repeated) {
                        fieldReader.copyAsValue(mapWriter.list("value").varBinary());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.varBinary("value"));
                    break;
                }
                case MAP: {
                    if (valueMajorType.getMode() == TypeProtos.DataMode.REPEATED) {
                        fieldReader.copyAsValue(mapWriter.list("value").map());
                        break;
                    }
                    fieldReader.copyAsValue(mapWriter.map("value"));
                    break;
                }
                case LIST: {
                    fieldReader.copyAsValue(mapWriter.list("value").list());
                    break;
                }
                default: {
                    throw new DrillRuntimeException(String.format("kvgen does not support input of type: %s", valueMinorType));
                }
            }
        }
        catch (ClassCastException e) {
            MaterializedField field = fieldReader.getField();
            throw new DrillRuntimeException(String.format(TYPE_MISMATCH_ERROR, field.getPath(), field.getType()));
        }
    }
}

