/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex;

import java.util.Collection;
import javax.annotation.Nullable;
import oadd.com.google.common.base.Function;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Iterables;
import oadd.com.google.common.collect.Sets;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TypedFieldId;
import oadd.org.apache.drill.exec.util.CallBack;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.FieldIdUtil;
import oadd.org.apache.drill.exec.vector.complex.VectorWithOrdinal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContainerVector
implements ValueVector {
    static final Logger logger = LoggerFactory.getLogger(AbstractContainerVector.class);
    protected final MaterializedField field;
    protected final BufferAllocator allocator;
    protected final CallBack callBack;

    protected AbstractContainerVector(MaterializedField field, BufferAllocator allocator, CallBack callBack) {
        this.field = Preconditions.checkNotNull(field);
        this.allocator = allocator;
        this.callBack = callBack;
    }

    @Override
    public void allocateNew() throws OutOfMemoryRuntimeException {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException();
        }
    }

    @Override
    public MaterializedField getField() {
        return this.field;
    }

    public ValueVector getChild(String name) {
        return this.getChild(name, ValueVector.class);
    }

    protected Collection<String> getChildFieldNames() {
        return Sets.newLinkedHashSet(Iterables.transform(this.field.getChildren(), new Function<MaterializedField, String>(){

            @Override
            @Nullable
            public String apply(MaterializedField field) {
                return Preconditions.checkNotNull(field).getLastName();
            }
        }));
    }

    @Override
    public void close() {
        for (ValueVector vector : this) {
            vector.close();
        }
    }

    protected <T extends ValueVector> T typeify(ValueVector v, Class<T> clazz) {
        if (clazz.isAssignableFrom(v.getClass())) {
            return (T)v;
        }
        throw new IllegalStateException(String.format("Vector requested [%s] was different than type stored [%s].  Drill doesn't yet support hetergenous types.", clazz.getSimpleName(), v.getClass().getSimpleName()));
    }

    public TypedFieldId getFieldIdIfMatches(TypedFieldId.Builder builder, boolean addToBreadCrumb, PathSegment seg) {
        return FieldIdUtil.getFieldIdIfMatches(this, builder, addToBreadCrumb, seg);
    }

    TypeProtos.MajorType getLastPathType() {
        if (this.getField().getType().getMinorType() == TypeProtos.MinorType.LIST && this.getField().getType().getMode() == TypeProtos.DataMode.REPEATED) {
            VectorWithOrdinal vord = this.getChildVectorWithOrdinal(null);
            ValueVector v = vord.vector;
            if (!(v instanceof AbstractContainerVector)) {
                return v.getField().getType();
            }
        } else if (this.getField().getType().getMinorType() == TypeProtos.MinorType.MAP && this.getField().getType().getMode() == TypeProtos.DataMode.REPEATED) {
            return this.getField().getType().toBuilder().setMode(TypeProtos.DataMode.REQUIRED).build();
        }
        return this.getField().getType();
    }

    protected boolean supportsDirectRead() {
        return false;
    }

    public abstract int size();

    public abstract <T extends ValueVector> T addOrGet(String var1, TypeProtos.MajorType var2, Class<T> var3);

    public abstract <T extends ValueVector> T getChild(String var1, Class<T> var2);

    public abstract VectorWithOrdinal getChildVectorWithOrdinal(String var1);
}

