/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.util.List;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.expression.FieldReference;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedVarBinaryHolder;
import oadd.org.apache.drill.exec.expr.holders.VarBinaryHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.JsonStringArrayList;
import oadd.org.apache.drill.exec.vector.AddOrGetResult;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VarBinaryVector;
import oadd.org.apache.drill.exec.vector.VectorDescriptor;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedVariableWidthVectorLike;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedVarBinaryReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedVarBinaryVector
extends BaseRepeatedValueVector
implements RepeatedVariableWidthVectorLike {
    private VarBinaryVector values;
    private final FieldReader reader = new RepeatedVarBinaryReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedVarBinaryVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.addOrGetVector(VectorDescriptor.create(Types.required(field.getType().getMinorType())));
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public VarBinaryVector getDataVector() {
        return this.values;
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().withPath(ref));
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedVarBinaryVector)to);
    }

    public AddOrGetResult<VarBinaryVector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult<VarBinaryVector> result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedVarBinaryVector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedVarBinaryVector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m.set(i, normalizedPos);
        }
        m.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedVarBinaryVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedVarBinaryVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryRuntimeException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    protected UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return super.getMetadataBuilder().setVarByteLength(this.values.getVarByteLength());
    }

    @Override
    public void allocateNew(int totalBytes, int valueCount, int innerValueCount) {
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(totalBytes, innerValueCount);
        }
        catch (OutOfMemoryRuntimeException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    public int getByteCapacity() {
        return this.values.getByteCapacity();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
        }

        public void add(int index, byte[] value) {
            int nextOffset = RepeatedVarBinaryVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVarBinaryVector.this.values.getMutator().set(nextOffset, value);
            RepeatedVarBinaryVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, byte[] bytes) {
            this.addSafe(index, bytes, 0, bytes.length);
        }

        public void addSafe(int index, byte[] bytes, int start, int length) {
            int nextOffset = RepeatedVarBinaryVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVarBinaryVector.this.values.getMutator().setSafe(nextOffset, bytes, start, length);
            RepeatedVarBinaryVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedVarBinaryHolder h) {
            VarBinaryHolder ih = new VarBinaryHolder();
            VarBinaryVector.Accessor hVectorAccessor = h.vector.getAccessor();
            RepeatedVarBinaryVector.this.mutator.startNewValue(index);
            for (int i = h.start; i < h.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedVarBinaryVector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, VarBinaryHolder holder) {
            int nextOffset = RepeatedVarBinaryVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVarBinaryVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedVarBinaryVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableVarBinaryHolder holder) {
            int nextOffset = RepeatedVarBinaryVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVarBinaryVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedVarBinaryVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int arrayIndex, int start, int end, DrillBuf buffer) {
            int nextOffset = RepeatedVarBinaryVector.this.offsets.getAccessor().get(arrayIndex + 1);
            RepeatedVarBinaryVector.this.values.getMutator().setSafe(nextOffset, start, end, buffer);
            RepeatedVarBinaryVector.this.offsets.getMutator().setSafe(arrayIndex + 1, nextOffset + 1);
        }

        protected void add(int index, VarBinaryHolder holder) {
            int nextOffset = RepeatedVarBinaryVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVarBinaryVector.this.values.getMutator().set(nextOffset, holder);
            RepeatedVarBinaryVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedVarBinaryHolder holder) {
            VarBinaryVector.Accessor accessor = holder.vector.getAccessor();
            VarBinaryHolder innerHolder = new VarBinaryHolder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        @Override
        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedVarBinaryVector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedVarBinaryVector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        @Override
        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        @Override
        public List<byte[]> getObject(int index) {
            JsonStringArrayList<byte[]> vals = new JsonStringArrayList<byte[]>();
            UInt4Vector.Accessor offsetsAccessor = RepeatedVarBinaryVector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            VarBinaryVector.Accessor valuesAccessor = RepeatedVarBinaryVector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public byte[] getSingleObject(int index, int arrayIndex) {
            int start = RepeatedVarBinaryVector.this.offsets.getAccessor().get(index);
            return RepeatedVarBinaryVector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public byte[] get(int index, int positionIndex) {
            return RepeatedVarBinaryVector.this.values.getAccessor().get(RepeatedVarBinaryVector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedVarBinaryHolder holder) {
            holder.start = RepeatedVarBinaryVector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedVarBinaryVector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedVarBinaryVector.this.values;
        }

        public void get(int index, int positionIndex, VarBinaryHolder holder) {
            int offset = RepeatedVarBinaryVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedVarBinaryVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableVarBinaryHolder holder) {
            int offset = RepeatedVarBinaryVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedVarBinaryVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedVarBinaryVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new RepeatedVarBinaryVector(field, RepeatedVarBinaryVector.this.allocator);
        }

        public TransferImpl(RepeatedVarBinaryVector to) {
            this.to = to;
        }

        @Override
        public RepeatedVarBinaryVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedVarBinaryVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            RepeatedVarBinaryVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedVarBinaryVector.this);
        }
    }
}

