/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.math.BigDecimal;
import java.math.BigInteger;
import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.expression.FieldReference;
import oadd.org.apache.drill.exec.exception.OversizedAllocationException;
import oadd.org.apache.drill.exec.expr.holders.Decimal9Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableDecimal9Holder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorTrimmer;
import oadd.org.apache.drill.exec.vector.complex.impl.Decimal9ReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Decimal9Vector
extends BaseDataValueVector
implements FixedWidthVector {
    private static final Logger logger = LoggerFactory.getLogger(Decimal9Vector.class);
    private final FieldReader reader = new Decimal9ReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationSizeInBytes = 16384;
    private int allocationMonitor = 0;

    public Decimal9Vector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return valueCount * 4;
    }

    @Override
    public int getValueCapacity() {
        return (int)((double)this.data.capacity() * 1.0 / 4.0);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        long size = 1L * (long)valueCount * 4L;
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        this.allocationSizeInBytes = (int)size;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(8L, curAllocationSize / 2L);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize = (long)this.allocationSizeInBytes * 2L;
            this.allocationMonitor = 0;
        }
        try {
            this.allocateBytes(curAllocationSize);
        }
        catch (DrillRuntimeException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.allocateBytes(valueCount * 4);
    }

    @Override
    public void reset() {
        this.allocationSizeInBytes = 4096;
        this.allocationMonitor = 0;
        this.zeroVector();
        super.reset();
    }

    private void allocateBytes(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)size;
        this.clear();
        this.data = this.allocator.buffer(curSize);
        this.data.readerIndex(0);
        this.allocationSizeInBytes = curSize;
    }

    public void reAlloc() {
        long newAllocationSize = (long)this.allocationSizeInBytes * 2L;
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Unable to expand the buffer. Max allowed buffer size is reached.");
        }
        logger.debug("Reallocating vector [{}]. # of bytes: [{}] -> [{}]", this.field, this.allocationSizeInBytes, newAllocationSize);
        DrillBuf newBuf = this.allocator.buffer((int)newAllocationSize);
        newBuf.setBytes(0, this.data, 0, this.data.capacity());
        int halfNewCapacity = newBuf.capacity() / 2;
        newBuf.setZero(halfNewCapacity, halfNewCapacity);
        newBuf.writerIndex(this.data.writerIndex());
        this.data.release(1);
        this.data = newBuf;
        this.allocationSizeInBytes = (int)newAllocationSize;
    }

    @Override
    public void zeroVector() {
        this.data.setZero(0, this.data.capacity());
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument(this.field.matches(metadata), "The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int actualLength = metadata.getBufferLength();
        int valueCount = metadata.getValueCount();
        int expectedLength = valueCount * 4;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes", expectedLength, actualLength);
        this.clear();
        if (this.data != null) {
            this.data.release(1);
        }
        this.data = buffer.slice(0, actualLength);
        this.data.retain(1);
        this.data.writerIndex(actualLength);
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().withPath(ref));
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((Decimal9Vector)to);
    }

    public void transferTo(Decimal9Vector target) {
        target.clear();
        target.data = this.data;
        target.data.retain(1);
        target.data.writerIndex(this.data.writerIndex());
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, Decimal9Vector target) {
        int startPoint = startIndex * 4;
        int sliceLength = length * 4;
        target.clear();
        target.data = this.data.slice(startPoint, sliceLength);
        target.data.retain(1);
        target.data.writerIndex(sliceLength);
    }

    public void copyFrom(int fromIndex, int thisIndex, Decimal9Vector from) {
        this.data.setInt(thisIndex * 4, from.data.getInt(fromIndex * 4));
    }

    public void copyFromSafe(int fromIndex, int thisIndex, Decimal9Vector from) {
        while (thisIndex >= this.getValueCapacity()) {
            this.reAlloc();
        }
        this.copyFrom(fromIndex, thisIndex, from);
    }

    public void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public void set(int index, int value) {
            Decimal9Vector.this.data.setInt(index * 4, value);
        }

        public void setSafe(int index, int value) {
            while (index >= Decimal9Vector.this.getValueCapacity()) {
                Decimal9Vector.this.reAlloc();
            }
            this.set(index, value);
        }

        protected void set(int index, Decimal9Holder holder) {
            Decimal9Vector.this.data.setInt(index * 4, holder.value);
        }

        public void setSafe(int index, Decimal9Holder holder) {
            while (index >= Decimal9Vector.this.getValueCapacity()) {
                Decimal9Vector.this.reAlloc();
            }
            this.set(index, holder);
        }

        protected void set(int index, NullableDecimal9Holder holder) {
            Decimal9Vector.this.data.setInt(index * 4, holder.value);
        }

        public void setSafe(int index, NullableDecimal9Holder holder) {
            while (index >= Decimal9Vector.this.getValueCapacity()) {
                Decimal9Vector.this.reAlloc();
            }
            this.set(index, holder);
        }

        @Override
        public void generateTestData(int size) {
            this.setValueCount(size);
            boolean even = true;
            int valueCount = Decimal9Vector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                if (even) {
                    this.set(i, Integer.MIN_VALUE);
                } else {
                    this.set(i, Integer.MAX_VALUE);
                }
                even = !even;
            }
        }

        public void generateTestDataAlt(int size) {
            this.setValueCount(size);
            boolean even = true;
            int valueCount = Decimal9Vector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                if (even) {
                    this.set(i, 1);
                } else {
                    this.set(i, 0);
                }
                even = !even;
            }
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentValueCapacity = Decimal9Vector.this.getValueCapacity();
            int idx = 4 * valueCount;
            while (valueCount > Decimal9Vector.this.getValueCapacity()) {
                Decimal9Vector.this.reAlloc();
            }
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                Decimal9Vector.this.incrementAllocationMonitor();
            } else if (Decimal9Vector.this.allocationMonitor > 0) {
                Decimal9Vector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(Decimal9Vector.this.data, idx);
            Decimal9Vector.this.data.writerIndex(valueCount * 4);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        @Override
        public int getValueCount() {
            return Decimal9Vector.this.data.writerIndex() / 4;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public int get(int index) {
            return Decimal9Vector.this.data.getInt(index * 4);
        }

        public long getTwoAsLong(int index) {
            return Decimal9Vector.this.data.getLong(index * 4);
        }

        @Override
        public BigDecimal getObject(int index) {
            BigInteger value = BigInteger.valueOf(Integer.valueOf(this.get(index)).intValue());
            return new BigDecimal(value, Decimal9Vector.this.getField().getScale());
        }

        public void get(int index, Decimal9Holder holder) {
            holder.scale = Decimal9Vector.this.getField().getScale();
            holder.precision = Decimal9Vector.this.getField().getPrecision();
            holder.value = Decimal9Vector.this.data.getInt(index * 4);
        }

        public void get(int index, NullableDecimal9Holder holder) {
            holder.isSet = 1;
            holder.value = Decimal9Vector.this.data.getInt(index * 4);
        }
    }

    private class TransferImpl
    implements TransferPair {
        private Decimal9Vector to;

        public TransferImpl(MaterializedField field) {
            this.to = new Decimal9Vector(field, Decimal9Vector.this.allocator);
        }

        public TransferImpl(Decimal9Vector to) {
            this.to = to;
        }

        @Override
        public Decimal9Vector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            Decimal9Vector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            Decimal9Vector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, Decimal9Vector.this);
        }
    }
}

