/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.BaseValueVector;

public abstract class BaseDataValueVector
extends BaseValueVector {
    protected static final byte[] emptyByteArray = new byte[0];
    protected DrillBuf data;

    public BaseDataValueVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.data = allocator.getEmpty();
    }

    @Override
    public void clear() {
        if (this.data != null) {
            this.data.release();
        }
        this.data = this.allocator.getEmpty();
        super.clear();
    }

    @Override
    public void close() {
        this.clear();
        if (this.data != null) {
            this.data.release();
            this.data = null;
        }
        super.close();
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] out;
        if (this.getBufferSize() == 0) {
            out = new DrillBuf[]{};
        } else {
            out = new DrillBuf[]{this.data};
            if (clear) {
                this.data.readerIndex(0);
                this.data.retain(1);
            }
        }
        if (clear) {
            this.clear();
        }
        return out;
    }

    @Override
    public int getBufferSize() {
        if (this.getAccessor().getValueCount() == 0) {
            return 0;
        }
        return this.data.writerIndex();
    }

    public DrillBuf getBuffer() {
        return this.data;
    }

    public void reset() {
    }
}

