/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.util.ArrayList;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.commons.lang3.StringUtils;
import oadd.org.apache.drill.exec.record.VectorAccessible;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.record.selection.SelectionVector4;
import oadd.org.apache.drill.exec.vector.ValueVector;

public class BatchPrinter {
    public static void printHyperBatch(VectorAccessible batch, SelectionVector4 sv4) {
        ArrayList<String> columns = Lists.newArrayList();
        ArrayList vectors = Lists.newArrayList();
        int numBatches = 0;
        for (VectorWrapper vw : batch) {
            columns.add(vw.getValueVectors()[0].getField().getAsSchemaPath().toExpr());
            numBatches = vw.getValueVectors().length;
        }
        int width = columns.size();
        for (int j = 0; j < sv4.getCount(); ++j) {
            for (VectorWrapper vw : batch) {
                String value;
                Object o = vw.getValueVectors()[sv4.get(j) >>> 16].getAccessor().getObject(sv4.get(j) & 0xFFFF);
                if (o instanceof byte[]) {
                    value = new String((byte[])o);
                    System.out.printf("| %-15s", value.length() <= 15 ? value : value.substring(0, 14));
                    continue;
                }
                value = o.toString();
                System.out.printf("| %-15s", value.length() <= 15 ? value : value.substring(0, 14));
            }
            System.out.printf("|\n", new Object[0]);
        }
        System.out.printf("|\n", new Object[0]);
    }

    public static void printBatch(VectorAccessible batch) {
        ArrayList<String> columns = Lists.newArrayList();
        ArrayList<ValueVector> vectors = Lists.newArrayList();
        for (VectorWrapper vw : batch) {
            columns.add(vw.getValueVector().getField().getAsSchemaPath().toExpr());
            vectors.add((ValueVector)vw.getValueVector());
        }
        int width = columns.size();
        int rows = ((ValueVector)vectors.get(0)).getMetadata().getValueCount();
        for (int row = 0; row < rows; ++row) {
            if (row % 50 == 0) {
                System.out.println(StringUtils.repeat("-", width * 17 + 1));
                for (String column : columns) {
                    System.out.printf("| %-15s", width <= 15 ? column : column.substring(0, 14));
                }
                System.out.printf("|\n", new Object[0]);
                System.out.println(StringUtils.repeat("-", width * 17 + 1));
            }
            for (ValueVector vv : vectors) {
                Object o = vv.getAccessor().getObject(row);
                String value = o == null ? "null" : (o instanceof byte[] ? new String((byte[])o) : o.toString());
                System.out.printf("| %-15s", value.length() <= 15 ? value : value.substring(0, 14));
            }
            System.out.printf("|\n", new Object[0]);
        }
    }
}

