/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.service;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import oadd.com.google.common.base.Stopwatch;
import oadd.com.google.common.io.Closeables;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.exec.exception.DrillbitStartupException;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.rpc.TransportCheck;
import oadd.org.apache.drill.exec.rpc.control.Controller;
import oadd.org.apache.drill.exec.rpc.control.ControllerImpl;
import oadd.org.apache.drill.exec.rpc.control.WorkEventBus;
import oadd.org.apache.drill.exec.rpc.data.DataConnectionCreator;
import oadd.org.apache.drill.exec.rpc.data.DataResponseHandler;
import oadd.org.apache.drill.exec.rpc.user.UserServer;
import oadd.org.apache.drill.exec.server.BootStrapContext;
import oadd.org.apache.drill.exec.work.batch.ControlMessageHandler;
import oadd.org.apache.drill.exec.work.user.UserWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceEngine
implements Closeable {
    static final Logger logger = LoggerFactory.getLogger(ServiceEngine.class);
    private final UserServer userServer;
    private final Controller controller;
    private final DataConnectionCreator dataPool;
    private final DrillConfig config;
    boolean useIP = false;
    private final boolean allowPortHunting;

    public ServiceEngine(ControlMessageHandler controlMessageHandler, UserWorker userWorker, BootStrapContext context, WorkEventBus workBus, DataResponseHandler dataHandler, boolean allowPortHunting) throws DrillbitStartupException {
        EventLoopGroup eventLoopGroup = TransportCheck.createEventLoopGroup(context.getConfig().getInt("drill.exec.rpc.user.server.threads"), "UserServer-");
        this.userServer = new UserServer(context.getConfig(), context.getClasspathScan(), context.getAllocator(), eventLoopGroup, userWorker, context.getExecutor());
        this.controller = new ControllerImpl(context, controlMessageHandler, allowPortHunting);
        this.dataPool = new DataConnectionCreator(context, workBus, dataHandler, allowPortHunting);
        this.config = context.getConfig();
        this.allowPortHunting = allowPortHunting;
    }

    public CoordinationProtos.DrillbitEndpoint start() throws DrillbitStartupException, UnknownHostException {
        int userPort = this.userServer.bind(this.config.getInt("drill.exec.rpc.user.server.port"), this.allowPortHunting);
        String address = this.useIP ? InetAddress.getLocalHost().getHostAddress() : InetAddress.getLocalHost().getCanonicalHostName();
        CoordinationProtos.DrillbitEndpoint partialEndpoint = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(address).setUserPort(userPort).build();
        partialEndpoint = this.controller.start(partialEndpoint);
        return this.dataPool.start(partialEndpoint);
    }

    public DataConnectionCreator getDataConnectionCreator() {
        return this.dataPool;
    }

    public Controller getController() {
        return this.controller;
    }

    private void submit(Executor p, final String name, final Closeable c) {
        p.execute(new Runnable(){

            @Override
            public void run() {
                Stopwatch watch = new Stopwatch().start();
                Closeables.closeQuietly(c);
                long elapsed = watch.elapsed(TimeUnit.MILLISECONDS);
                if (elapsed > 500L) {
                    logger.info("closed " + name + " in " + elapsed + " ms");
                }
            }
        });
    }

    @Override
    public void close() throws IOException {
        ExecutorService p = Executors.newFixedThreadPool(2);
        this.submit(p, "userServer", this.userServer);
        this.submit(p, "dataPool", (Closeable)this.dataPool);
        this.submit(p, "controller", (Closeable)this.controller);
        p.shutdown();
        try {
            p.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

