/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server.options;

import java.util.Map;
import oadd.org.apache.drill.exec.server.options.FallbackOptionManager;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.server.options.OptionValue;

public abstract class InMemoryOptionManager
extends FallbackOptionManager {
    protected final Map<String, OptionValue> options;

    InMemoryOptionManager(OptionManager fallback, Map<String, OptionValue> options) {
        super(fallback);
        this.options = options;
    }

    @Override
    OptionValue getLocalOption(String name) {
        return this.options.get(name);
    }

    @Override
    boolean setLocalOption(OptionValue value) {
        if (this.supportsOptionType(value.type)) {
            this.options.put(value.name, value);
            return true;
        }
        return false;
    }

    @Override
    Iterable<OptionValue> getLocalOptions() {
        return this.options.values();
    }

    @Override
    boolean deleteAllLocalOptions(OptionValue.OptionType type) {
        if (this.supportsOptionType(type)) {
            this.options.clear();
            return true;
        }
        return false;
    }

    @Override
    boolean deleteLocalOption(String name, OptionValue.OptionType type) {
        if (this.supportsOptionType(type)) {
            this.options.remove(name);
            return true;
        }
        return false;
    }

    abstract boolean supportsOptionType(OptionValue.OptionType var1);
}

