/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.user;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.rpc.user.ConnectionThrottle;
import oadd.org.apache.drill.exec.rpc.user.QueryDataBatch;
import oadd.org.apache.drill.exec.rpc.user.UserResultsListener;

public class AwaitableUserResultsListener
implements UserResultsListener {
    private final AtomicInteger count = new AtomicInteger();
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile UserException exception;
    private final UserResultsListener child;

    public AwaitableUserResultsListener(UserResultsListener child) {
        if (child == null) {
            throw new NullPointerException("child should not be null");
        }
        this.child = child;
    }

    @Override
    public void queryIdArrived(UserBitShared.QueryId queryId) {
        this.child.queryIdArrived(queryId);
    }

    @Override
    public void dataArrived(QueryDataBatch result, ConnectionThrottle throttle) {
        this.count.addAndGet(result.getHeader().getRowCount());
        this.child.dataArrived(result, throttle);
    }

    @Override
    public void submissionFailed(UserException ex) {
        this.exception = ex;
        this.latch.countDown();
        this.child.submissionFailed(ex);
    }

    @Override
    public void queryCompleted(UserBitShared.QueryResult.QueryState state) {
        this.latch.countDown();
        this.child.queryCompleted(state);
    }

    public int await() throws Exception {
        this.latch.await();
        if (this.exception != null) {
            this.exception.addSuppressed(new DrillRuntimeException("Exception in executor threadpool"));
            throw this.exception;
        }
        return this.count.get();
    }
}

