/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.ByteBufInputStream;
import oadd.io.netty.channel.ChannelHandlerContext;
import oadd.io.netty.handler.codec.CorruptedFrameException;
import oadd.io.netty.handler.codec.MessageToMessageDecoder;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.rpc.InboundRpcMessage;
import oadd.org.apache.drill.exec.rpc.RpcEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RpcDecoder
extends MessageToMessageDecoder<ByteBuf> {
    final Logger logger;
    private final AtomicLong messageCounter = new AtomicLong();

    public RpcDecoder(String name) {
        this.logger = LoggerFactory.getLogger(RpcDecoder.class.getCanonicalName() + "-" + name);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        if (!ctx.channel().isOpen()) {
            return;
        }
        ByteBufInputStream is = new ByteBufInputStream(buffer, buffer.readableBytes());
        this.checkTag(is, RpcEncoder.HEADER_TAG);
        GeneralRPCProtos.RpcHeader header = GeneralRPCProtos.RpcHeader.parseDelimitedFrom(is);
        this.checkTag(is, RpcEncoder.PROTOBUF_BODY_TAG);
        int pBodyLength = RpcDecoder.readRawVarint32(is);
        ByteBuf pBody = buffer.slice(buffer.readerIndex(), pBodyLength);
        buffer.skipBytes(pBodyLength);
        pBody.retain(1);
        ByteBuf dBody = null;
        int dBodyLength = 0;
        if (buffer.readableBytes() > 0) {
            this.checkTag(is, RpcEncoder.RAW_BODY_TAG);
            dBodyLength = RpcDecoder.readRawVarint32(is);
            if (buffer.readableBytes() != dBodyLength) {
                throw new CorruptedFrameException(String.format("Expected to receive a raw body of %d bytes but received a buffer with %d bytes.", dBodyLength, buffer.readableBytes()));
            }
            dBody = buffer.slice();
            dBody.retain(1);
        }
        InboundRpcMessage m = new InboundRpcMessage(header.getMode(), header.getRpcType(), header.getCoordinationId(), pBody, dBody);
        buffer.skipBytes(dBodyLength);
        this.messageCounter.incrementAndGet();
        out.add(m);
    }

    private void checkTag(ByteBufInputStream is, int expectedTag) throws IOException {
        int actualTag = RpcDecoder.readRawVarint32(is);
        if (actualTag != expectedTag) {
            throw new CorruptedFrameException(String.format("Expected to read a tag of %d but actually received a value of %d.  Happened after reading %d message.", expectedTag, actualTag, this.messageCounter.get()));
        }
    }

    public static int readRawVarint32(ByteBufInputStream is) throws IOException {
        byte tmp = is.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = is.readByte();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = is.readByte();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = is.readByte();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = is.readByte();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (is.readByte() < 0) continue;
                            return result;
                        }
                        throw new CorruptedFrameException("Encountered a malformed varint.");
                    }
                }
            }
        }
        return result;
    }
}

