/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.io.Closeable;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.base.Stopwatch;
import oadd.com.google.protobuf.Internal;
import oadd.com.google.protobuf.InvalidProtocolBufferException;
import oadd.com.google.protobuf.MessageLite;
import oadd.com.google.protobuf.Parser;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.ByteBufInputStream;
import oadd.io.netty.channel.Channel;
import oadd.io.netty.channel.ChannelFuture;
import oadd.io.netty.channel.ChannelFutureListener;
import oadd.io.netty.channel.ChannelHandlerContext;
import oadd.io.netty.channel.socket.SocketChannel;
import oadd.io.netty.handler.codec.MessageToMessageDecoder;
import oadd.io.netty.util.Recycler;
import oadd.io.netty.util.ReferenceCounted;
import oadd.io.netty.util.concurrent.GenericFutureListener;
import oadd.org.apache.drill.common.SerializedExecutor;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.rpc.Acks;
import oadd.org.apache.drill.exec.rpc.ChannelClosedException;
import oadd.org.apache.drill.exec.rpc.ChannelListenerWithCoordinationId;
import oadd.org.apache.drill.exec.rpc.CoordinationQueue;
import oadd.org.apache.drill.exec.rpc.DrillRpcFuture;
import oadd.org.apache.drill.exec.rpc.DrillRpcFutureImpl;
import oadd.org.apache.drill.exec.rpc.InboundRpcMessage;
import oadd.org.apache.drill.exec.rpc.OutboundRpcMessage;
import oadd.org.apache.drill.exec.rpc.RemoteConnection;
import oadd.org.apache.drill.exec.rpc.Response;
import oadd.org.apache.drill.exec.rpc.ResponseSender;
import oadd.org.apache.drill.exec.rpc.RpcConfig;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.RpcOutcome;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import oadd.org.apache.drill.exec.rpc.UserRpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcBus<T extends Internal.EnumLite, C extends RemoteConnection>
implements Closeable {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final OutboundRpcMessage PONG = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.PONG, 0, 0, (MessageLite)Acks.OK, new ByteBuf[0]);
    private static final boolean ENABLE_SEPARATE_THREADS = "true".equals(System.getProperty("drill.enable_rpc_offload"));
    protected final CoordinationQueue queue = new CoordinationQueue(16, 16);
    protected final RpcConfig rpcConfig;
    protected volatile SocketAddress local;
    protected volatile SocketAddress remote;
    private final Recycler<RequestEvent> requestRecycler = new Recycler<RequestEvent>(){

        @Override
        protected RequestEvent newObject(Recycler.Handle handle) {
            return new RequestEvent(handle);
        }
    };
    private final Recycler<ResponseEvent> responseRecycler = new Recycler<ResponseEvent>(){

        @Override
        protected ResponseEvent newObject(Recycler.Handle handle) {
            return new ResponseEvent(handle);
        }
    };

    protected abstract MessageLite getResponseDefaultInstance(int var1) throws RpcException;

    protected void handle(C connection, int rpcType, ByteBuf pBody, ByteBuf dBody, ResponseSender sender) throws RpcException {
        sender.send(this.handle(connection, rpcType, pBody, dBody));
    }

    protected abstract Response handle(C var1, int var2, ByteBuf var3, ByteBuf var4) throws RpcException;

    public abstract boolean isClient();

    public RpcBus(RpcConfig rpcConfig) {
        this.rpcConfig = rpcConfig;
    }

    protected void setAddresses(SocketAddress remote, SocketAddress local) {
        this.remote = remote;
        this.local = local;
    }

    <SEND extends MessageLite, RECEIVE extends MessageLite> DrillRpcFuture<RECEIVE> send(C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        DrillRpcFutureImpl rpcFuture = new DrillRpcFutureImpl();
        this.send(rpcFuture, connection, rpcType, protobufBody, clazz, dataBodies);
        return rpcFuture;
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        this.send(listener, connection, rpcType, protobufBody, clazz, false, dataBodies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, boolean allowInEventLoop, ByteBuf ... dataBodies) {
        block11: {
            Preconditions.checkArgument(allowInEventLoop || !((RemoteConnection)connection).inEventLoop(), "You attempted to send while inside the rpc event thread.  This isn't allowed because sending will block if the channel is backed up.");
            ReferenceCounted pBuffer = null;
            boolean completed = false;
            try {
                if (!allowInEventLoop && !((RemoteConnection)connection).blockOnNotWritable(listener)) {
                    return;
                }
                assert (!Arrays.asList(dataBodies).contains(null));
                assert (this.rpcConfig.checkSend((Internal.EnumLite)rpcType, protobufBody.getClass(), clazz));
                Preconditions.checkNotNull(protobufBody);
                ChannelListenerWithCoordinationId futureListener = this.queue.get(listener, clazz, (RemoteConnection)connection);
                OutboundRpcMessage m = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.REQUEST, (Internal.EnumLite)rpcType, futureListener.getCoordinationId(), (MessageLite)protobufBody, dataBodies);
                ChannelFuture channelFuture = ((RemoteConnection)connection).getChannel().writeAndFlush(m);
                channelFuture.addListener(futureListener);
                channelFuture.addListener(ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                completed = true;
            }
            catch (AssertionError | Exception e) {
                listener.failed(new RpcException("Failure sending message.", (Throwable)e));
            }
            finally {
                if (completed) break block11;
                if (pBuffer != null) {
                    pBuffer.release();
                }
                if (dataBodies == null) break block11;
                for (ByteBuf b : dataBodies) {
                    b.release();
                }
            }
        }
    }

    public abstract C initRemoteConnection(SocketChannel var1);

    protected GenericFutureListener<ChannelFuture> getCloseHandler(SocketChannel channel, C clientConnection) {
        return new ChannelClosedHandler(this, clientConnection, (Channel)channel);
    }

    public static <T> T get(ByteBuf pBody, Parser<T> parser) throws RpcException {
        try {
            ByteBufInputStream is = new ByteBufInputStream(pBody);
            return parser.parseFrom(is);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RpcException(String.format("Failure while decoding message with parser of type. %s", parser.getClass().getCanonicalName()), e);
        }
    }

    private class ResponseEvent
    implements Runnable {
        private final Recycler.Handle handle;
        private int rpcType;
        private int coordinationId;
        private ByteBuf pBody;
        private ByteBuf dBody;

        public ResponseEvent(Recycler.Handle handle) {
            this.handle = handle;
        }

        public void set(int rpcType, int coordinationId, ByteBuf pBody, ByteBuf dBody) {
            this.rpcType = rpcType;
            this.coordinationId = coordinationId;
            this.pBody = pBody;
            this.dBody = dBody;
            if (pBody != null) {
                pBody.retain();
            }
            if (dBody != null) {
                dBody.retain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MessageLite m = RpcBus.this.getResponseDefaultInstance(this.rpcType);
                assert (RpcBus.this.rpcConfig.checkReceive(this.rpcType, m.getClass()));
                RpcOutcome<?> rpcFuture = RpcBus.this.queue.getFuture(this.rpcType, this.coordinationId, m.getClass());
                Parser<? extends MessageLite> parser = m.getParserForType();
                MessageLite value = parser.parseFrom(new ByteBufInputStream(this.pBody, this.pBody.readableBytes()));
                rpcFuture.set(value, this.dBody);
            }
            catch (Exception ex) {
                RpcBus.this.logger.error("Failure while handling response.", ex);
            }
            finally {
                if (this.pBody != null) {
                    this.pBody.release();
                }
                if (this.dBody != null) {
                    this.dBody.release();
                }
                RpcBus.this.responseRecycler.recycle(this, this.handle);
            }
        }
    }

    private class RequestEvent
    implements Runnable,
    Recyclable {
        private final ResponseSenderImpl sender;
        private final Recycler.Handle handle;
        private C connection;
        private int rpcType;
        private ByteBuf pBody;
        private ByteBuf dBody;

        RequestEvent(Recycler.Handle handle) {
            this.handle = handle;
            this.sender = new ResponseSenderImpl(this);
        }

        public void set(int coordinationId, C connection, int rpcType, ByteBuf pBody, ByteBuf dBody) {
            this.connection = connection;
            this.rpcType = rpcType;
            this.pBody = pBody;
            this.dBody = dBody;
            this.sender.set((RemoteConnection)connection, coordinationId);
            if (pBody != null) {
                pBody.retain();
            }
            if (dBody != null) {
                dBody.retain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                RpcBus.this.handle(this.connection, this.rpcType, this.pBody, this.dBody, this.sender);
            }
            catch (UserRpcException e) {
                this.sender.sendFailure(e);
            }
            catch (Exception e) {
                RpcBus.this.logger.error("Failure while handling message.", e);
            }
            finally {
                if (this.pBody != null) {
                    this.pBody.release();
                }
                if (this.dBody != null) {
                    this.dBody.release();
                }
            }
        }

        @Override
        public void recycle() {
            RpcBus.this.requestRecycler.recycle(this, this.handle);
        }
    }

    class RpcEventHandler
    extends SerializedExecutor {
        public RpcEventHandler(Executor underlyingExecutor) {
            super(RpcBus.this.rpcConfig.getName() + "-rpc-event-queue", underlyingExecutor);
        }

        @Override
        protected void runException(Runnable command, Throwable t) {
            RpcBus.this.logger.error("Failure while running rpc command.", t);
        }
    }

    protected static class InboundHandler
    extends MessageToMessageDecoder<InboundRpcMessage> {
        private final Executor exec;
        private final C connection;
        final /* synthetic */ RpcBus this$0;

        public InboundHandler(C connection) {
            this.this$0 = var1_1;
            this.connection = connection;
            Executor underlyingExecutor = ENABLE_SEPARATE_THREADS ? var1_1.rpcConfig.getExecutor() : var1_1.new SameExecutor();
            this.exec = var1_1.new RpcEventHandler(underlyingExecutor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void decode(ChannelHandlerContext ctx, InboundRpcMessage msg, List<Object> output) throws Exception {
            long time;
            if (!ctx.channel().isOpen()) {
                return;
            }
            Channel channel = ((RemoteConnection)this.connection).getChannel();
            Stopwatch watch = new Stopwatch().start();
            try {
                switch (msg.mode) {
                    case REQUEST: {
                        RequestEvent reqEvent = (RequestEvent)this.this$0.requestRecycler.get();
                        reqEvent.set(msg.coordinationId, this.connection, msg.rpcType, msg.pBody, msg.dBody);
                        this.exec.execute(reqEvent);
                        break;
                    }
                    case RESPONSE: {
                        ResponseEvent respEvent = (ResponseEvent)this.this$0.responseRecycler.get();
                        respEvent.set(msg.rpcType, msg.coordinationId, msg.pBody, msg.dBody);
                        this.exec.execute(respEvent);
                        break;
                    }
                    case RESPONSE_FAILURE: {
                        UserBitShared.DrillPBError failure = UserBitShared.DrillPBError.parseFrom(new ByteBufInputStream(msg.pBody, msg.pBody.readableBytes()));
                        this.this$0.queue.updateFailedFuture(msg.coordinationId, failure);
                        break;
                    }
                    case PING: {
                        channel.writeAndFlush(PONG);
                        break;
                    }
                    case PONG: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                time = watch.elapsed(TimeUnit.MILLISECONDS);
            }
            catch (Throwable throwable) {
                long time2 = watch.elapsed(TimeUnit.MILLISECONDS);
                long delayThreshold = Integer.parseInt(System.getProperty("drill.exec.rpcDelayWarning", "500"));
                if (time2 > delayThreshold) {
                    this.this$0.logger.warn(String.format("Message of mode %s of rpc type %d took longer than %dms.  Actual duration was %dms.", msg.mode, msg.rpcType, delayThreshold, time2));
                }
                msg.release();
                throw throwable;
            }
            long delayThreshold = Integer.parseInt(System.getProperty("drill.exec.rpcDelayWarning", "500"));
            if (time > delayThreshold) {
                this.this$0.logger.warn(String.format("Message of mode %s of rpc type %d took longer than %dms.  Actual duration was %dms.", msg.mode, msg.rpcType, delayThreshold, time));
            }
            msg.release();
        }
    }

    private class SameExecutor
    implements Executor {
        private SameExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    private class ResponseSenderImpl
    implements ResponseSender {
        private RemoteConnection connection;
        private int coordinationId;
        private final AtomicBoolean sent = new AtomicBoolean(false);
        private final Recyclable recyclable;

        public ResponseSenderImpl(Recyclable recyclable) {
            this.recyclable = recyclable;
        }

        void set(RemoteConnection connection, int coordinationId) {
            this.connection = connection;
            this.coordinationId = coordinationId;
            this.sent.set(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(Response r) {
            try {
                assert (RpcBus.this.rpcConfig.checkResponseSend(r.rpcType, r.pBody.getClass()));
                this.sendOnce();
                OutboundRpcMessage outMessage = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.RESPONSE, r.rpcType, this.coordinationId, r.pBody, r.dBodies);
                RpcBus.this.logger.debug("Sending response with Sender {}", (Object)System.identityHashCode(this));
                this.connection.getChannel().writeAndFlush(outMessage);
            }
            finally {
                this.recyclable.recycle();
            }
        }

        private void sendOnce() {
            if (!this.sent.compareAndSet(false, true)) {
                throw new IllegalStateException("Attempted to utilize a sender multiple times.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendFailure(UserRpcException e) {
            try {
                this.sendOnce();
                UserException uex = UserException.systemError(e).addIdentity(e.getEndpoint()).build(RpcBus.this.logger);
                RpcBus.this.logger.error("Unexpected Error while handling request message", e);
                OutboundRpcMessage outMessage = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.RESPONSE_FAILURE, 0, this.coordinationId, (MessageLite)uex.getOrCreatePBError(false), new ByteBuf[0]);
                this.connection.getChannel().writeAndFlush(outMessage);
            }
            finally {
                this.recyclable.recycle();
            }
        }
    }

    private static interface Recyclable {
        public void recycle();
    }

    public static class ChannelClosedHandler
    implements GenericFutureListener<ChannelFuture> {
        final C clientConnection;
        private final Channel channel;
        final /* synthetic */ RpcBus this$0;

        public ChannelClosedHandler(C clientConnection, Channel channel) {
            this.this$0 = var1_1;
            this.channel = channel;
            this.clientConnection = clientConnection;
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            String msg = this.this$0.local != null ? String.format("Channel closed %s <--> %s.", this.this$0.local, this.this$0.remote) : String.format("Channel closed %s <--> %s.", future.channel().localAddress(), future.channel().remoteAddress());
            if (this.this$0.isClient()) {
                if (this.this$0.local != null) {
                    this.this$0.logger.info(String.format(msg, new Object[0]));
                }
            } else {
                this.this$0.queue.channelClosed(new ChannelClosedException(msg));
            }
            ((RemoteConnection)this.clientConnection).close();
        }
    }
}

