/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.net.SocketAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import oadd.com.google.protobuf.Internal;
import oadd.com.google.protobuf.MessageLite;
import oadd.com.google.protobuf.Parser;
import oadd.io.netty.bootstrap.Bootstrap;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.ByteBufAllocator;
import oadd.io.netty.channel.ChannelFuture;
import oadd.io.netty.channel.ChannelHandler;
import oadd.io.netty.channel.ChannelHandlerContext;
import oadd.io.netty.channel.ChannelInitializer;
import oadd.io.netty.channel.ChannelOption;
import oadd.io.netty.channel.ChannelPipeline;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.io.netty.channel.socket.SocketChannel;
import oadd.io.netty.handler.timeout.IdleState;
import oadd.io.netty.handler.timeout.IdleStateEvent;
import oadd.io.netty.handler.timeout.IdleStateHandler;
import oadd.io.netty.util.concurrent.Future;
import oadd.io.netty.util.concurrent.GenericFutureListener;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.rpc.AbstractHandshakeHandler;
import oadd.org.apache.drill.exec.rpc.Acks;
import oadd.org.apache.drill.exec.rpc.BasicClient;
import oadd.org.apache.drill.exec.rpc.DrillRpcFuture;
import oadd.org.apache.drill.exec.rpc.OutboundRpcMessage;
import oadd.org.apache.drill.exec.rpc.ProtobufLengthDecoder;
import oadd.org.apache.drill.exec.rpc.RemoteConnection;
import oadd.org.apache.drill.exec.rpc.RpcBus;
import oadd.org.apache.drill.exec.rpc.RpcConfig;
import oadd.org.apache.drill.exec.rpc.RpcConnectionHandler;
import oadd.org.apache.drill.exec.rpc.RpcDecoder;
import oadd.org.apache.drill.exec.rpc.RpcEncoder;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.RpcExceptionHandler;
import oadd.org.apache.drill.exec.rpc.RpcOutcome;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import oadd.org.apache.drill.exec.rpc.TransportCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicClient<T extends Internal.EnumLite, R extends RemoteConnection, HANDSHAKE_SEND extends MessageLite, HANDSHAKE_RESPONSE extends MessageLite>
extends RpcBus<T, R> {
    private static final Logger logger = LoggerFactory.getLogger(BasicClient.class);
    private static final double PERCENT_TIMEOUT_BEFORE_SENDING_PING = 0.5;
    private final Bootstrap b;
    protected R connection;
    private final T handshakeType;
    private final Class<HANDSHAKE_RESPONSE> responseClass;
    private final Parser<HANDSHAKE_RESPONSE> handshakeParser;
    private final IdlePingHandler pingHandler;
    private static final OutboundRpcMessage PING_MESSAGE = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.PING, 0, 0, (MessageLite)Acks.OK, new ByteBuf[0]);

    public BasicClient(RpcConfig rpcMapping, ByteBufAllocator alloc, EventLoopGroup eventLoopGroup, T handshakeType, Class<HANDSHAKE_RESPONSE> responseClass, Parser<HANDSHAKE_RESPONSE> handshakeParser) {
        super(rpcMapping);
        this.responseClass = responseClass;
        this.handshakeType = handshakeType;
        this.handshakeParser = handshakeParser;
        long timeoutInMillis = rpcMapping.hasTimeout() ? (long)((double)rpcMapping.getTimeout() * 1000.0 * 0.5) : -1L;
        this.pingHandler = rpcMapping.hasTimeout() ? new IdlePingHandler(timeoutInMillis) : null;
        this.b = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(TransportCheck.getClientSocketChannel())).option(ChannelOption.ALLOCATOR, alloc)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 30000)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.SO_RCVBUF, 131072)).option(ChannelOption.SO_SNDBUF, 131072)).option(ChannelOption.TCP_NODELAY, true)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                BasicClient.this.connection = BasicClient.this.initRemoteConnection(ch);
                ch.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)BasicClient.this.getCloseHandler(ch, BasicClient.this.connection));
                ChannelPipeline pipe = ch.pipeline();
                pipe.addLast("protocol-decoder", (ChannelHandler)BasicClient.this.getDecoder(((RemoteConnection)BasicClient.this.connection).getAllocator()));
                pipe.addLast("message-decoder", (ChannelHandler)new RpcDecoder("c-" + BasicClient.this.rpcConfig.getName()));
                pipe.addLast("protocol-encoder", (ChannelHandler)new RpcEncoder("c-" + BasicClient.this.rpcConfig.getName()));
                pipe.addLast("handshake-handler", (ChannelHandler)new ClientHandshakeHandler());
                if (BasicClient.this.pingHandler != null) {
                    pipe.addLast("idle-state-handler", (ChannelHandler)BasicClient.this.pingHandler);
                }
                pipe.addLast("message-handler", (ChannelHandler)new RpcBus.InboundHandler((RpcBus)BasicClient.this, BasicClient.this.connection));
                pipe.addLast("exception-handler", new RpcExceptionHandler(BasicClient.this.connection));
            }
        });
    }

    @Override
    public R initRemoteConnection(SocketChannel channel) {
        this.local = channel.localAddress();
        this.remote = channel.remoteAddress();
        return null;
    }

    public abstract ProtobufLengthDecoder getDecoder(BufferAllocator var1);

    public boolean isActive() {
        return this.connection != null && ((RemoteConnection)this.connection).getChannel() != null && ((RemoteConnection)this.connection).getChannel().isActive();
    }

    protected abstract void validateHandshake(HANDSHAKE_RESPONSE var1) throws RpcException;

    protected abstract void finalizeConnection(HANDSHAKE_RESPONSE var1, R var2);

    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        super.send(listener, this.connection, rpcType, protobufBody, clazz, dataBodies);
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> DrillRpcFuture<RECEIVE> send(T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        return super.send(this.connection, rpcType, protobufBody, clazz, dataBodies);
    }

    @Override
    public boolean isClient() {
        return true;
    }

    protected void connectAsClient(RpcConnectionHandler<R> connectionListener, HANDSHAKE_SEND handshakeValue, String host, int port) {
        ConnectionMultiListener cml = new ConnectionMultiListener(this, connectionListener, handshakeValue);
        this.b.connect(host, port).addListener((GenericFutureListener<? extends Future<? super Void>>)cml.connectionHandler);
    }

    public void setAutoRead(boolean enableAutoRead) {
        ((RemoteConnection)this.connection).setAutoRead(enableAutoRead);
    }

    @Override
    public void close() {
        logger.debug("Closing client");
        try {
            ((RemoteConnection)this.connection).getChannel().close().get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn("Failure while shutting {}", (Object)this.getClass().getName(), (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    private class ClientHandshakeHandler
    extends AbstractHandshakeHandler<HANDSHAKE_RESPONSE> {
        public ClientHandshakeHandler() {
            super(BasicClient.this.handshakeType, BasicClient.this.handshakeParser);
        }

        @Override
        protected final void consumeHandshake(ChannelHandlerContext ctx, HANDSHAKE_RESPONSE msg) throws Exception {
            RpcOutcome response = BasicClient.this.queue.getFuture(this.handshakeType.getNumber(), this.coordinationId, BasicClient.this.responseClass);
            response.set(msg, null);
        }
    }

    private static class ConnectionMultiListener {
        private final RpcConnectionHandler<R> l;
        private final HANDSHAKE_SEND handshakeValue;
        public final oadd.org.apache.drill.exec.rpc.BasicClient$ConnectionMultiListener.ConnectionHandler connectionHandler = new ConnectionHandler();
        public final oadd.org.apache.drill.exec.rpc.BasicClient$ConnectionMultiListener.HandshakeSendHandler handshakeSendHandler = new HandshakeSendHandler();
        final /* synthetic */ BasicClient this$0;

        public ConnectionMultiListener(RpcConnectionHandler<R> l, HANDSHAKE_SEND handshakeValue) {
            this.this$0 = var1_1;
            assert (l != null);
            assert (handshakeValue != null);
            this.l = l;
            this.handshakeValue = handshakeValue;
        }

        private class HandshakeSendHandler
        implements RpcOutcomeListener<HANDSHAKE_RESPONSE> {
            private HandshakeSendHandler() {
            }

            @Override
            public void failed(RpcException ex) {
                logger.debug("Failure while initiating handshake", ex);
                ConnectionMultiListener.this.l.connectionFailed(RpcConnectionHandler.FailureType.HANDSHAKE_COMMUNICATION, ex);
            }

            @Override
            public void success(HANDSHAKE_RESPONSE value, ByteBuf buffer) {
                try {
                    ConnectionMultiListener.this.this$0.validateHandshake(value);
                    ConnectionMultiListener.this.this$0.finalizeConnection(value, ConnectionMultiListener.this.this$0.connection);
                    ConnectionMultiListener.this.l.connectionSucceeded(ConnectionMultiListener.this.this$0.connection);
                }
                catch (RpcException ex) {
                    ConnectionMultiListener.this.l.connectionFailed(RpcConnectionHandler.FailureType.HANDSHAKE_VALIDATION, ex);
                }
            }

            @Override
            public void interrupted(InterruptedException ex) {
                logger.warn("Interrupted while waiting for handshake response", ex);
                ConnectionMultiListener.this.l.connectionFailed(RpcConnectionHandler.FailureType.HANDSHAKE_COMMUNICATION, ex);
            }
        }

        private class ConnectionHandler
        implements GenericFutureListener<ChannelFuture> {
            private ConnectionHandler() {
            }

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                boolean isInterrupted = false;
                long remainingWaitTimeMills = 120000L;
                long startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        future.get(remainingWaitTimeMills, TimeUnit.MILLISECONDS);
                        if (future.isSuccess()) {
                            SocketAddress remote = future.channel().remoteAddress();
                            SocketAddress local = future.channel().localAddress();
                            ConnectionMultiListener.this.this$0.setAddresses(remote, local);
                            ConnectionMultiListener.this.this$0.send(ConnectionMultiListener.this.handshakeSendHandler, ConnectionMultiListener.this.this$0.connection, ConnectionMultiListener.this.this$0.handshakeType, ConnectionMultiListener.this.handshakeValue, ConnectionMultiListener.this.this$0.responseClass, true, new ByteBuf[0]);
                            break;
                        }
                        ConnectionMultiListener.this.l.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, new RpcException("General connection failure."));
                    }
                    catch (InterruptedException interruptEx) {
                        startTime = System.currentTimeMillis();
                        isInterrupted = true;
                        if ((remainingWaitTimeMills -= System.currentTimeMillis() - startTime) >= 1L) continue;
                        ConnectionMultiListener.this.l.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, interruptEx);
                    }
                    catch (Exception ex) {
                        logger.error("Failed to establish connection", ex);
                        ConnectionMultiListener.this.l.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, ex);
                    }
                    break;
                }
                if (isInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private class IdlePingHandler
    extends IdleStateHandler {
        private GenericFutureListener<Future<? super Void>> pingFailedHandler;

        public IdlePingHandler(long idleWaitInMillis) {
            super(0L, idleWaitInMillis, 0L, TimeUnit.MILLISECONDS);
            this.pingFailedHandler = new GenericFutureListener<Future<? super Void>>(){

                @Override
                public void operationComplete(Future<? super Void> future) throws Exception {
                    if (!future.isSuccess()) {
                        logger.error("Unable to maintain connection {}.  Closing connection.", (Object)((RemoteConnection)BasicClient.this.connection).getName());
                        ((RemoteConnection)BasicClient.this.connection).close();
                    }
                }
            };
        }

        @Override
        protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
            if (evt.state() == IdleState.WRITER_IDLE) {
                ctx.writeAndFlush(PING_MESSAGE).addListener((GenericFutureListener<? extends Future<? super Void>>)this.pingFailedHandler);
            }
        }
    }
}

