/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.List;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.record.TypedFieldId;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.AbstractContainerVector;
import oadd.org.apache.drill.exec.vector.complex.AbstractMapVector;
import oadd.org.apache.drill.exec.vector.complex.ListVector;
import oadd.org.apache.drill.exec.vector.complex.UnionVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleVectorWrapper<T extends ValueVector>
implements VectorWrapper<T> {
    static final Logger logger = LoggerFactory.getLogger(SimpleVectorWrapper.class);
    private T vector;

    public SimpleVectorWrapper(T v) {
        this.vector = v;
    }

    @Override
    public Class<T> getVectorClass() {
        return this.vector.getClass();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public T getValueVector() {
        return this.vector;
    }

    @Override
    public T[] getValueVectors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHyper() {
        return false;
    }

    @Override
    public VectorWrapper<T> cloneAndTransfer() {
        TransferPair tp = this.vector.getTransferPair();
        tp.transfer();
        return new SimpleVectorWrapper<ValueVector>(tp.getTo());
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    public static <T extends ValueVector> SimpleVectorWrapper<T> create(T v) {
        return new SimpleVectorWrapper<T>(v);
    }

    @Override
    public VectorWrapper<?> getChildWrapper(int[] ids) {
        if (ids.length == 1) {
            return this;
        }
        Object vector = this.vector;
        for (int i = 1; i < ids.length; ++i) {
            AbstractMapVector mapLike = (AbstractMapVector)AbstractMapVector.class.cast(vector);
            if (mapLike == null) {
                return null;
            }
            vector = mapLike.getChildByOrdinal(ids[i]);
        }
        return new SimpleVectorWrapper<T>(vector);
    }

    @Override
    public TypedFieldId getFieldIdIfMatches(int id, SchemaPath expectedPath) {
        if (!expectedPath.getRootSegment().segmentEquals(this.vector.getField().getPath().getRootSegment())) {
            return null;
        }
        PathSegment.NameSegment seg = expectedPath.getRootSegment();
        if (this.vector instanceof UnionVector) {
            TypedFieldId.Builder builder = TypedFieldId.newBuilder();
            builder.addId(id).remainder(expectedPath.getRootSegment().getChild());
            List<TypeProtos.MinorType> minorTypes = ((UnionVector)this.vector).getSubTypes();
            TypeProtos.MajorType.Builder majorTypeBuilder = TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.UNION);
            for (TypeProtos.MinorType type : minorTypes) {
                majorTypeBuilder.addSubType(type);
            }
            TypeProtos.MajorType majorType = majorTypeBuilder.build();
            builder.intermediateType(majorType);
            if (seg.isLastPath()) {
                builder.finalType(majorType);
                return builder.build();
            }
            return ((UnionVector)this.vector).getFieldIdIfMatches(builder, false, seg.getChild());
        }
        if (this.vector instanceof ListVector) {
            ListVector list = (ListVector)this.vector;
            TypedFieldId.Builder builder = TypedFieldId.newBuilder();
            builder.intermediateType(this.vector.getField().getType());
            builder.addId(id);
            return list.getFieldIdIfMatches(builder, true, expectedPath.getRootSegment().getChild());
        }
        if (this.vector instanceof AbstractContainerVector) {
            AbstractContainerVector c = (AbstractContainerVector)this.vector;
            TypedFieldId.Builder builder = TypedFieldId.newBuilder();
            builder.intermediateType(this.vector.getField().getType());
            builder.addId(id);
            return c.getFieldIdIfMatches(builder, true, expectedPath.getRootSegment().getChild());
        }
        TypedFieldId.Builder builder = TypedFieldId.newBuilder();
        builder.intermediateType(this.vector.getField().getType());
        builder.addId(id);
        builder.finalType(this.vector.getField().getType());
        if (seg.isLastPath()) {
            return builder.build();
        }
        PathSegment child = seg.getChild();
        if (child.isArray() && child.isLastPath()) {
            builder.remainder(child);
            builder.withIndex();
            builder.finalType(this.vector.getField().getType().toBuilder().setMode(TypeProtos.DataMode.OPTIONAL).build());
            return builder.build();
        }
        return null;
    }

    @Override
    public void transfer(VectorWrapper<?> destination) {
        Preconditions.checkArgument(destination instanceof SimpleVectorWrapper);
        Preconditions.checkArgument(this.getField().getType().equals(destination.getField().getType()));
        this.vector.makeTransferPair((ValueVector)((SimpleVectorWrapper)destination).vector).transfer();
    }
}

