/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.Iterator;
import java.util.Map;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Range;
import oadd.com.google.common.collect.TreeRangeMap;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.ops.OperatorContext;
import oadd.org.apache.drill.exec.physical.impl.sort.RecordBatchData;
import oadd.org.apache.drill.exec.record.AbstractRecordBatch;
import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.RecordBatch;
import oadd.org.apache.drill.exec.record.TypedFieldId;
import oadd.org.apache.drill.exec.record.VectorAccessible;
import oadd.org.apache.drill.exec.record.VectorContainer;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordIterator
implements VectorAccessible {
    private static final Logger logger = LoggerFactory.getLogger(RecordIterator.class);
    private final RecordBatch incoming;
    private final AbstractRecordBatch<?> outgoing;
    private long outerPosition;
    private int innerPosition;
    private int innerRecordCount;
    private long totalRecordCount;
    private long startBatchPosition;
    private int markedInnerPosition;
    private long markedOuterPosition;
    private RecordBatch.IterOutcome lastOutcome;
    private int inputIndex;
    private boolean lastBatchRead;
    private boolean initialized;
    private final VectorContainer container;
    private final TreeRangeMap<Long, RecordBatchData> batches = TreeRangeMap.create();

    public RecordIterator(RecordBatch incoming, AbstractRecordBatch<?> outgoing, OperatorContext oContext, int inputIndex) {
        this.incoming = incoming;
        this.outgoing = outgoing;
        this.inputIndex = inputIndex;
        this.lastBatchRead = false;
        this.container = new VectorContainer(oContext);
        this.resetIndices();
        this.initialized = false;
    }

    private void resetIndices() {
        this.innerPosition = -1;
        this.startBatchPosition = -1L;
        this.outerPosition = -1L;
        this.totalRecordCount = 0L;
        this.innerRecordCount = 0;
        this.markedInnerPosition = -1;
        this.markedOuterPosition = -1L;
    }

    private void nextBatch() {
        if (this.lastBatchRead) {
            return;
        }
        this.lastOutcome = this.outgoing.next(this.inputIndex, this.incoming);
    }

    public void mark() {
        Map oldBatches = this.batches.subRangeMap(Range.closedOpen(0L, this.startBatchPosition)).asMapOfRanges();
        for (Range range : oldBatches.keySet()) {
            ((RecordBatchData)oldBatches.get(range.lowerEndpoint())).clear();
        }
        this.batches.remove(Range.closedOpen(0L, this.startBatchPosition));
        this.markedInnerPosition = this.innerPosition;
        this.markedOuterPosition = this.outerPosition;
    }

    public void reset() {
        if (this.markedOuterPosition >= 0L) {
            RecordBatchData rbdNew = (RecordBatchData)this.batches.get((Comparable)Long.valueOf(this.markedOuterPosition));
            RecordBatchData rbdOld = (RecordBatchData)this.batches.get((Comparable)Long.valueOf(this.startBatchPosition));
            Preconditions.checkArgument(rbdOld != null);
            Preconditions.checkArgument(rbdNew != null);
            if (rbdNew != rbdOld) {
                this.container.transferOut(rbdOld.getContainer());
                this.container.transferIn(rbdNew.getContainer());
            }
            this.innerPosition = this.markedInnerPosition;
            this.outerPosition = this.markedOuterPosition;
            this.startBatchPosition = (Long)((Range)this.batches.getEntry((Comparable)Long.valueOf(this.outerPosition)).getKey()).lowerEndpoint();
            this.innerRecordCount = (int)((Long)((Range)this.batches.getEntry((Comparable)Long.valueOf(this.outerPosition)).getKey()).upperEndpoint() - this.startBatchPosition);
            this.markedInnerPosition = -1;
            this.markedOuterPosition = -1L;
        }
    }

    public void forward(long delta) {
        Preconditions.checkArgument(delta >= 0L);
        Preconditions.checkArgument(delta + this.outerPosition < this.totalRecordCount);
        long nextOuterPosition = delta + this.outerPosition;
        RecordBatchData rbdNew = (RecordBatchData)this.batches.get((Comparable)Long.valueOf(nextOuterPosition));
        RecordBatchData rbdOld = (RecordBatchData)this.batches.get((Comparable)Long.valueOf(this.outerPosition));
        Preconditions.checkArgument(rbdNew != null);
        Preconditions.checkArgument(rbdOld != null);
        this.container.transferOut(rbdOld.getContainer());
        this.container.transferIn(rbdNew.getContainer());
        this.outerPosition = nextOuterPosition;
        this.startBatchPosition = (Long)((Range)this.batches.getEntry((Comparable)Long.valueOf(this.outerPosition)).getKey()).lowerEndpoint();
        this.innerPosition = (int)(this.outerPosition - this.startBatchPosition);
        this.innerRecordCount = (int)((Long)((Range)this.batches.getEntry((Comparable)Long.valueOf(this.outerPosition)).getKey()).upperEndpoint() - this.startBatchPosition);
    }

    public void prepare() {
        while (!this.lastBatchRead && this.outerPosition == -1L) {
            this.next();
        }
    }

    public RecordBatch.IterOutcome next() {
        block13: {
            int nextInnerPosition;
            long nextOuterPosition;
            block12: {
                if (this.finished()) {
                    return this.lastOutcome;
                }
                nextOuterPosition = this.outerPosition + 1L;
                nextInnerPosition = this.innerPosition + 1;
                if (this.initialized && nextOuterPosition < this.totalRecordCount) break block12;
                this.nextBatch();
                switch (this.lastOutcome) {
                    case NONE: 
                    case STOP: {
                        this.outerPosition = nextOuterPosition;
                        this.lastBatchRead = true;
                        break block13;
                    }
                    case OK_NEW_SCHEMA: 
                    case OK: {
                        if (this.initialized && this.lastOutcome == RecordBatch.IterOutcome.OK_NEW_SCHEMA) {
                            this.clear();
                            this.resetIndices();
                            this.initialized = false;
                            nextOuterPosition = 0L;
                        }
                        RecordBatchData rbd = new RecordBatchData((VectorAccessible)this.incoming);
                        this.innerRecordCount = this.incoming.getRecordCount();
                        if (!this.initialized) {
                            for (VectorWrapper<?> w : rbd.getContainer()) {
                                this.container.addOrGet(w.getField());
                            }
                            this.container.buildSchema(rbd.getContainer().getSchema().getSelectionVectorMode());
                            this.initialized = true;
                        }
                        if (this.innerRecordCount > 0) {
                            if (this.startBatchPosition != -1L && this.batches.get((Comparable)Long.valueOf(this.startBatchPosition)) != null) {
                                this.container.transferOut(((RecordBatchData)this.batches.get((Comparable)Long.valueOf(this.outerPosition))).getContainer());
                            }
                            this.container.transferIn(rbd.getContainer());
                            this.startBatchPosition = nextOuterPosition;
                            this.batches.put(Range.closedOpen(nextOuterPosition, nextOuterPosition + (long)this.innerRecordCount), (Object)rbd);
                            this.innerPosition = 0;
                            this.outerPosition = nextOuterPosition;
                            this.totalRecordCount += (long)this.innerRecordCount;
                        } else {
                            rbd.clear();
                        }
                        break block13;
                    }
                    case OUT_OF_MEMORY: {
                        return this.lastOutcome;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported outcome received " + (Object)((Object)this.lastOutcome));
                    }
                }
            }
            this.outerPosition = nextOuterPosition;
            this.innerPosition = nextInnerPosition;
        }
        return this.lastOutcome;
    }

    public boolean finished() {
        return this.lastBatchRead && this.outerPosition >= this.totalRecordCount;
    }

    public RecordBatch.IterOutcome getLastOutcome() {
        return this.lastOutcome;
    }

    public long getTotalRecordCount() {
        return this.totalRecordCount;
    }

    public int getInnerRecordCount() {
        return this.innerRecordCount;
    }

    public long getOuterPosition() {
        return this.outerPosition;
    }

    public int getCurrentPosition() {
        Preconditions.checkArgument(this.initialized);
        Preconditions.checkArgument(this.innerPosition >= 0 && this.innerPosition < this.innerRecordCount);
        return this.innerPosition;
    }

    @Override
    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... ids) {
        Preconditions.checkArgument(this.initialized);
        return this.container.getValueAccessorById(clazz, ids);
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        Preconditions.checkArgument(this.initialized);
        return this.container.getValueVectorId(path);
    }

    @Override
    public BatchSchema getSchema() {
        Preconditions.checkArgument(this.initialized);
        return this.container.getSchema();
    }

    @Override
    public int getRecordCount() {
        Preconditions.checkArgument(this.initialized);
        return this.innerRecordCount;
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        Preconditions.checkArgument(this.initialized);
        return this.container.iterator();
    }

    public void clear() {
        if (this.container != null) {
            this.container.clear();
        }
        for (RecordBatchData d : this.batches.asMapOfRanges().values()) {
            d.clear();
        }
        this.batches.clear();
    }

    public void clearInflightBatches() {
        while (this.lastOutcome == RecordBatch.IterOutcome.OK || this.lastOutcome == RecordBatch.IterOutcome.OK_NEW_SCHEMA) {
            for (VectorWrapper wrapper : this.incoming) {
                wrapper.getValueVector().clear();
            }
            this.lastOutcome = this.incoming.next();
        }
    }

    public void close() {
        this.clear();
        this.clearInflightBatches();
    }
}

