/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.dotdrill;

import java.util.ArrayList;
import java.util.List;
import oadd.com.fasterxml.jackson.annotation.JsonCreator;
import oadd.com.fasterxml.jackson.annotation.JsonIgnore;
import oadd.com.fasterxml.jackson.annotation.JsonInclude;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.com.fasterxml.jackson.annotation.JsonTypeName;
import oadd.com.google.common.collect.ImmutableList;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.calcite.avatica.util.TimeUnit;
import oadd.org.apache.calcite.rel.type.RelDataType;
import oadd.org.apache.calcite.rel.type.RelDataTypeFactory;
import oadd.org.apache.calcite.rel.type.RelDataTypeField;
import oadd.org.apache.calcite.sql.SqlIntervalQualifier;
import oadd.org.apache.calcite.sql.parser.SqlParserPos;
import oadd.org.apache.calcite.sql.type.SqlTypeFamily;
import oadd.org.apache.calcite.sql.type.SqlTypeName;
import oadd.org.apache.drill.exec.planner.StarColumnHelper;
import oadd.org.apache.drill.exec.planner.types.RelDataTypeDrillImpl;
import oadd.org.apache.drill.exec.planner.types.RelDataTypeHolder;

@JsonTypeName(value="view")
public class View {
    private final String name;
    private String sql;
    private List<FieldType> fields;
    private List<String> workspaceSchemaPath;

    public View(String name, String sql, RelDataType rowType, List<String> workspaceSchemaPath) {
        this.name = name;
        this.sql = sql;
        this.fields = Lists.newArrayList();
        for (RelDataTypeField f : rowType.getFieldList()) {
            this.fields.add(new FieldType(f.getName(), f.getType()));
        }
        this.workspaceSchemaPath = workspaceSchemaPath == null ? ImmutableList.of() : ImmutableList.copyOf(workspaceSchemaPath);
    }

    @JsonCreator
    public View(@JsonProperty(value="name") String name, @JsonProperty(value="sql") String sql, @JsonProperty(value="fields") List<FieldType> fields, @JsonProperty(value="workspaceSchemaPath") List<String> workspaceSchemaPath) {
        this.name = name;
        this.sql = sql;
        this.fields = fields;
        this.workspaceSchemaPath = workspaceSchemaPath == null ? ImmutableList.of() : ImmutableList.copyOf(workspaceSchemaPath);
    }

    public RelDataType getRowType(RelDataTypeFactory factory) {
        if (this.isDynamic()) {
            return new RelDataTypeDrillImpl(new RelDataTypeHolder(), factory);
        }
        ArrayList<RelDataType> types = Lists.newArrayList();
        ArrayList<String> names = Lists.newArrayList();
        for (FieldType field : this.fields) {
            names.add(field.getName());
            RelDataType type = SqlTypeFamily.INTERVAL_YEAR_MONTH == field.getType().getFamily() || SqlTypeFamily.INTERVAL_DAY_TIME == field.getType().getFamily() ? factory.createSqlIntervalType(field.getIntervalQualifier()) : (field.getPrecision() == null && field.getScale() == null ? factory.createSqlType(field.getType()) : (field.getPrecision() != null && field.getScale() == null ? factory.createSqlType(field.getType(), field.getPrecision().intValue()) : factory.createSqlType(field.getType(), field.getPrecision().intValue(), field.getScale().intValue())));
            if (field.getIsNullable().booleanValue()) {
                types.add(factory.createTypeWithNullability(type, true));
                continue;
            }
            types.add(type);
        }
        return factory.createStructType(types, names);
    }

    @JsonIgnore
    public boolean isDynamic() {
        return this.fields.isEmpty();
    }

    @JsonIgnore
    public boolean hasStar() {
        for (FieldType field : this.fields) {
            if (!StarColumnHelper.isNonPrefixedStarColumn((String)field.getName())) continue;
            return true;
        }
        return false;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getName() {
        return this.name;
    }

    public List<FieldType> getFields() {
        return this.fields;
    }

    public List<String> getWorkspaceSchemaPath() {
        return this.workspaceSchemaPath;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class FieldType {
        private final String name;
        private final SqlTypeName type;
        private final Integer precision;
        private final Integer scale;
        private SqlIntervalQualifier intervalQualifier;
        private final Boolean isNullable;

        @JsonCreator
        public FieldType(@JsonProperty(value="name") String name, @JsonProperty(value="type") SqlTypeName type, @JsonProperty(value="precision") Integer precision, @JsonProperty(value="scale") Integer scale, @JsonProperty(value="startUnit") TimeUnit startUnit, @JsonProperty(value="endUnit") TimeUnit endUnit, @JsonProperty(value="fractionalSecondPrecision") Integer fractionalSecondPrecision, @JsonProperty(value="isNullable") Boolean isNullable) {
            this.name = name;
            this.type = type;
            this.precision = precision;
            this.scale = scale;
            this.intervalQualifier = null == startUnit ? null : new SqlIntervalQualifier(startUnit, precision.intValue(), endUnit, fractionalSecondPrecision.intValue(), SqlParserPos.ZERO);
            this.isNullable = isNullable == null ? true : isNullable;
        }

        public FieldType(String name, RelDataType dataType) {
            this.name = name;
            this.type = dataType.getSqlTypeName();
            Integer p = null;
            Integer s = null;
            Object fractionalSecondPrecision = null;
            switch (dataType.getSqlTypeName()) {
                case CHAR: 
                case BINARY: 
                case VARBINARY: 
                case VARCHAR: {
                    p = dataType.getPrecision();
                    break;
                }
                case DECIMAL: {
                    p = dataType.getPrecision();
                    s = dataType.getScale();
                    break;
                }
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_DAY_TIME: {
                    p = dataType.getIntervalQualifier().getStartPrecisionPreservingDefault();
                }
            }
            this.precision = p;
            this.scale = s;
            this.intervalQualifier = dataType.getIntervalQualifier();
            this.isNullable = dataType.isNullable();
        }

        public String getName() {
            return this.name;
        }

        public SqlTypeName getType() {
            return this.type;
        }

        public Integer getPrecision() {
            return this.precision;
        }

        public Integer getScale() {
            return this.scale;
        }

        @JsonIgnore
        public SqlIntervalQualifier getIntervalQualifier() {
            return this.intervalQualifier;
        }

        public TimeUnit getStartUnit() {
            return null == this.intervalQualifier ? null : this.intervalQualifier.getStartUnit();
        }

        public TimeUnit getEndUnit() {
            return null == this.intervalQualifier ? null : this.intervalQualifier.getEndUnit();
        }

        public Integer getFractionalSecondPrecision() {
            return null == this.intervalQualifier ? null : Integer.valueOf(this.intervalQualifier.getFractionalSecondPrecisionPreservingDefault());
        }

        public Boolean getIsNullable() {
            return this.isNullable;
        }
    }
}

