/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.client;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import oadd.com.google.common.base.Stopwatch;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.DrillAutoCloseables;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.client.QuerySubmitter;
import oadd.org.apache.drill.exec.exception.SchemaChangeException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.RootAllocatorFactory;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.RecordBatchLoader;
import oadd.org.apache.drill.exec.record.VectorAccessible;
import oadd.org.apache.drill.exec.rpc.user.ConnectionThrottle;
import oadd.org.apache.drill.exec.rpc.user.QueryDataBatch;
import oadd.org.apache.drill.exec.rpc.user.UserResultsListener;
import oadd.org.apache.drill.exec.util.VectorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintingResultsListener
implements UserResultsListener {
    private static final Logger logger = LoggerFactory.getLogger(PrintingResultsListener.class);
    private final AtomicInteger count = new AtomicInteger();
    private final Stopwatch w = new Stopwatch();
    private final RecordBatchLoader loader;
    private final QuerySubmitter.Format format;
    private final int columnWidth;
    private final BufferAllocator allocator;

    public PrintingResultsListener(DrillConfig config, QuerySubmitter.Format format, int columnWidth) {
        this.allocator = RootAllocatorFactory.newRoot(config);
        this.loader = new RecordBatchLoader(this.allocator);
        this.format = format;
        this.columnWidth = columnWidth;
    }

    @Override
    public void submissionFailed(UserException ex) {
        System.out.println("Exception (no rows returned): " + ex + ".  Returned in " + this.w.elapsed(TimeUnit.MILLISECONDS) + "ms.");
    }

    @Override
    public void queryCompleted(UserBitShared.QueryResult.QueryState state) {
        DrillAutoCloseables.closeNoChecked(this.allocator);
        System.out.println("Total rows returned : " + this.count.get() + ".  Returned in " + this.w.elapsed(TimeUnit.MILLISECONDS) + "ms.");
    }

    @Override
    public void dataArrived(QueryDataBatch result, ConnectionThrottle throttle) {
        UserBitShared.QueryData header = result.getHeader();
        DrillBuf data = result.getData();
        if (data != null) {
            this.count.addAndGet(header.getRowCount());
            try {
                this.loader.load(header.getDef(), data);
            }
            catch (SchemaChangeException e) {
                this.submissionFailed(UserException.systemError(e).build(logger));
            }
            switch (this.format) {
                case TABLE: {
                    VectorUtil.showVectorAccessibleContent((VectorAccessible)this.loader, this.columnWidth);
                    break;
                }
                case TSV: {
                    VectorUtil.showVectorAccessibleContent((VectorAccessible)this.loader, "\t");
                    break;
                }
                case CSV: {
                    VectorUtil.showVectorAccessibleContent((VectorAccessible)this.loader, ",");
                }
            }
            this.loader.clear();
        }
        result.release();
    }

    @Override
    public void queryIdArrived(UserBitShared.QueryId queryId) {
        this.w.start();
    }
}

