/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression;

import java.math.BigDecimal;
import oadd.com.google.common.collect.ImmutableList;
import oadd.org.apache.drill.common.expression.BooleanOperator;
import oadd.org.apache.drill.common.expression.CastExpression;
import oadd.org.apache.drill.common.expression.ConvertExpression;
import oadd.org.apache.drill.common.expression.FunctionCall;
import oadd.org.apache.drill.common.expression.FunctionHolderExpression;
import oadd.org.apache.drill.common.expression.IfExpression;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.NullExpression;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.expression.TypedNullConstant;
import oadd.org.apache.drill.common.expression.ValueExpressions;
import oadd.org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionStringBuilder
extends AbstractExprVisitor<Void, StringBuilder, RuntimeException> {
    static final Logger logger = LoggerFactory.getLogger(ExpressionStringBuilder.class);
    static final ExpressionStringBuilder INSTANCE = new ExpressionStringBuilder();

    public static String toString(LogicalExpression expr) {
        StringBuilder sb = new StringBuilder();
        expr.accept(INSTANCE, sb);
        return sb.toString();
    }

    public static void toString(LogicalExpression expr, StringBuilder sb) {
        expr.accept(INSTANCE, sb);
    }

    @Override
    public Void visitFunctionCall(FunctionCall call, StringBuilder sb) throws RuntimeException {
        ImmutableList<LogicalExpression> args = call.args;
        sb.append(call.getName());
        sb.append("(");
        for (int i = 0; i < args.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            ((LogicalExpression)args.get(i)).accept(this, sb);
        }
        sb.append(") ");
        return null;
    }

    @Override
    public Void visitBooleanOperator(BooleanOperator op, StringBuilder sb) throws RuntimeException {
        return this.visitFunctionCall((FunctionCall)op, sb);
    }

    @Override
    public Void visitFunctionHolderExpression(FunctionHolderExpression holder, StringBuilder sb) throws RuntimeException {
        ImmutableList<LogicalExpression> args = holder.args;
        sb.append(holder.getName());
        sb.append("(");
        for (int i = 0; i < args.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            ((LogicalExpression)args.get(i)).accept(this, sb);
        }
        sb.append(") ");
        return null;
    }

    @Override
    public Void visitIfExpression(IfExpression ifExpr, StringBuilder sb) throws RuntimeException {
        sb.append(" ( ");
        IfExpression.IfCondition c = ifExpr.ifCondition;
        sb.append("if (");
        c.condition.accept(this, sb);
        sb.append(" ) then (");
        c.expression.accept(this, sb);
        sb.append(" ) ");
        sb.append(" else (");
        ifExpr.elseExpression.accept(this, sb);
        sb.append(" ) ");
        sb.append(" end ");
        sb.append(" ) ");
        return null;
    }

    @Override
    public Void visitSchemaPath(SchemaPath path, StringBuilder sb) throws RuntimeException {
        PathSegment seg = path.getRootSegment();
        if (seg.isArray()) {
            throw new IllegalStateException("Drill doesn't currently support top level arrays");
        }
        sb.append('`');
        sb.append(seg.getNameSegment().getPath());
        sb.append('`');
        while ((seg = seg.getChild()) != null) {
            if (seg.isNamed()) {
                sb.append('.');
                sb.append('`');
                sb.append(seg.getNameSegment().getPath());
                sb.append('`');
                continue;
            }
            sb.append('[');
            sb.append(seg.getArraySegment().getIndex());
            sb.append(']');
        }
        return null;
    }

    @Override
    public Void visitLongConstant(ValueExpressions.LongExpression lExpr, StringBuilder sb) throws RuntimeException {
        sb.append(lExpr.getLong());
        return null;
    }

    @Override
    public Void visitDateConstant(ValueExpressions.DateExpression lExpr, StringBuilder sb) throws RuntimeException {
        sb.append("cast( ");
        sb.append(lExpr.getDate());
        sb.append(" as DATE)");
        return null;
    }

    @Override
    public Void visitTimeConstant(ValueExpressions.TimeExpression lExpr, StringBuilder sb) throws RuntimeException {
        sb.append("cast( ");
        sb.append(lExpr.getTime());
        sb.append(" as TIME)");
        return null;
    }

    @Override
    public Void visitTimeStampConstant(ValueExpressions.TimeStampExpression lExpr, StringBuilder sb) throws RuntimeException {
        sb.append("cast( ");
        sb.append(lExpr.getTimeStamp());
        sb.append(" as TIMESTAMP)");
        return null;
    }

    @Override
    public Void visitIntervalYearConstant(ValueExpressions.IntervalYearExpression lExpr, StringBuilder sb) throws RuntimeException {
        sb.append("cast( '");
        sb.append(Period.months(lExpr.getIntervalYear()).toString());
        sb.append("' as INTERVALYEAR)");
        return null;
    }

    @Override
    public Void visitIntervalDayConstant(ValueExpressions.IntervalDayExpression lExpr, StringBuilder sb) throws RuntimeException {
        sb.append("cast( '");
        sb.append(Period.days(lExpr.getIntervalDay()).plusMillis(lExpr.getIntervalMillis()).toString());
        sb.append("' as INTERVALDAY)");
        return null;
    }

    @Override
    public Void visitDecimal9Constant(ValueExpressions.Decimal9Expression decExpr, StringBuilder sb) throws RuntimeException {
        BigDecimal value = new BigDecimal(decExpr.getIntFromDecimal());
        sb.append(value.setScale(decExpr.getScale()).toString());
        return null;
    }

    @Override
    public Void visitDecimal18Constant(ValueExpressions.Decimal18Expression decExpr, StringBuilder sb) throws RuntimeException {
        BigDecimal value = new BigDecimal(decExpr.getLongFromDecimal());
        sb.append(value.setScale(decExpr.getScale()).toString());
        return null;
    }

    @Override
    public Void visitDecimal28Constant(ValueExpressions.Decimal28Expression decExpr, StringBuilder sb) throws RuntimeException {
        sb.append(decExpr.toString());
        return null;
    }

    @Override
    public Void visitDecimal38Constant(ValueExpressions.Decimal38Expression decExpr, StringBuilder sb) throws RuntimeException {
        sb.append(decExpr.getBigDecimal().toString());
        return null;
    }

    @Override
    public Void visitDoubleConstant(ValueExpressions.DoubleExpression dExpr, StringBuilder sb) throws RuntimeException {
        sb.append(dExpr.getDouble());
        return null;
    }

    @Override
    public Void visitBooleanConstant(ValueExpressions.BooleanExpression e, StringBuilder sb) throws RuntimeException {
        sb.append(e.getBoolean());
        return null;
    }

    @Override
    public Void visitQuotedStringConstant(ValueExpressions.QuotedString e, StringBuilder sb) throws RuntimeException {
        sb.append("'");
        sb.append((String)e.value);
        sb.append("'");
        return null;
    }

    @Override
    public Void visitConvertExpression(ConvertExpression e, StringBuilder sb) throws RuntimeException {
        sb.append(e.getConvertFunction()).append("(");
        e.getInput().accept(this, sb);
        sb.append(", '").append(e.getEncodingType()).append("')");
        return null;
    }

    @Override
    public Void visitCastExpression(CastExpression e, StringBuilder sb) throws RuntimeException {
        TypeProtos.MajorType mt = e.getMajorType();
        sb.append("cast( (");
        e.getInput().accept(this, sb);
        sb.append(" ) as ");
        sb.append(mt.getMinorType().name());
        switch (mt.getMinorType()) {
            case FLOAT4: 
            case FLOAT8: 
            case BIT: 
            case INT: 
            case TINYINT: 
            case SMALLINT: 
            case BIGINT: 
            case UINT1: 
            case UINT2: 
            case UINT4: 
            case UINT8: 
            case DATE: 
            case TIMESTAMP: 
            case TIMESTAMPTZ: 
            case TIME: 
            case INTERVAL: 
            case INTERVALDAY: 
            case INTERVALYEAR: {
                break;
            }
            case VAR16CHAR: 
            case VARBINARY: 
            case VARCHAR: 
            case FIXED16CHAR: 
            case FIXEDBINARY: 
            case FIXEDCHAR: {
                sb.append("(");
                sb.append(mt.getWidth());
                sb.append(")");
                break;
            }
            case DECIMAL9: 
            case DECIMAL18: 
            case DECIMAL28DENSE: 
            case DECIMAL28SPARSE: 
            case DECIMAL38DENSE: 
            case DECIMAL38SPARSE: {
                sb.append("(");
                sb.append(mt.getPrecision());
                sb.append(", ");
                sb.append(mt.getScale());
                sb.append(")");
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unable to convert cast expression %s into string.", e));
            }
        }
        sb.append(" )");
        return null;
    }

    @Override
    public Void visitFloatConstant(ValueExpressions.FloatExpression fExpr, StringBuilder sb) throws RuntimeException {
        sb.append(fExpr.getFloat());
        return null;
    }

    @Override
    public Void visitIntConstant(ValueExpressions.IntExpression intExpr, StringBuilder sb) throws RuntimeException {
        sb.append(intExpr.getInt());
        return null;
    }

    @Override
    public Void visitNullConstant(TypedNullConstant e, StringBuilder sb) throws RuntimeException {
        sb.append("NULL");
        return null;
    }

    @Override
    public Void visitNullExpression(NullExpression e, StringBuilder sb) throws RuntimeException {
        sb.append("NULL");
        return null;
    }

    @Override
    public Void visitUnknown(LogicalExpression e, StringBuilder sb) {
        sb.append(e.toString());
        return null;
    }
}

