/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.exceptions;

import java.util.Set;
import javax.validation.ConstraintViolation;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.logical.data.LogicalOperator;
import oadd.org.apache.drill.common.logical.data.LogicalOperatorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalPlanParsingException
extends DrillRuntimeException {
    static final Logger logger = LoggerFactory.getLogger(LogicalPlanParsingException.class);
    private Set<ConstraintViolation<LogicalOperatorBase>> violations;
    private LogicalOperator operator;

    public LogicalPlanParsingException() {
    }

    public LogicalPlanParsingException(LogicalOperator operator, Set<ConstraintViolation<LogicalOperatorBase>> violations) {
        super(LogicalPlanParsingException.getErrorMessage(operator, violations));
        this.operator = operator;
        this.violations = violations;
    }

    public LogicalPlanParsingException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public LogicalPlanParsingException(String message, Throwable cause) {
        super(message, cause);
    }

    public LogicalPlanParsingException(String message) {
        super(message);
    }

    public LogicalPlanParsingException(Throwable cause) {
        super(cause);
    }

    private static String getErrorMessage(LogicalOperator operator, Set<ConstraintViolation<LogicalOperatorBase>> violations) {
        StringBuffer sb = new StringBuffer();
        sb.append("Failure while attempting to set up operator of type ");
        sb.append(operator.getClass().getCanonicalName());
        sb.append(".  Constraints violated:\n");
        for (ConstraintViolation<LogicalOperatorBase> v : violations) {
            sb.append("\t");
            sb.append(v.getMessage());
            sb.append(", Invalid value: ");
            sb.append(v.getInvalidValue());
            sb.append("\n");
        }
        return sb.toString();
    }
}

