/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.beanutils.converters;

import oadd.org.apache.commons.beanutils.ConversionException;
import oadd.org.apache.commons.beanutils.Converter;

public final class DoubleConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public DoubleConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public DoubleConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof Number) {
            return new Double(((Number)value).doubleValue());
        }
        try {
            return new Double(value.toString());
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(e);
        }
    }
}

