/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.bcel.generic;

import oadd.org.apache.bcel.Constants;
import oadd.org.apache.bcel.Repository;
import oadd.org.apache.bcel.classfile.JavaClass;
import oadd.org.apache.bcel.generic.ArrayType;
import oadd.org.apache.bcel.generic.BasicType;
import oadd.org.apache.bcel.generic.ObjectType;
import oadd.org.apache.bcel.generic.Type;

public class ReferenceType
extends Type {
    protected ReferenceType(byte t, String s) {
        super(t, s);
    }

    ReferenceType() {
        super((byte)14, "<null object>");
    }

    public boolean isCastableTo(Type t) {
        if (this.equals(Type.NULL)) {
            return true;
        }
        return this.isAssignmentCompatibleWith(t);
    }

    public boolean isAssignmentCompatibleWith(Type t) {
        if (!(t instanceof ReferenceType)) {
            return false;
        }
        ReferenceType T = (ReferenceType)t;
        if (this.equals(Type.NULL)) {
            return true;
        }
        if (this instanceof ObjectType && ((ObjectType)this).referencesClass()) {
            if (T instanceof ObjectType && ((ObjectType)T).referencesClass()) {
                if (this.equals(T)) {
                    return true;
                }
                if (Repository.instanceOf(((ObjectType)this).getClassName(), ((ObjectType)T).getClassName())) {
                    return true;
                }
            }
            if (T instanceof ObjectType && ((ObjectType)T).referencesInterface() && Repository.implementationOf(((ObjectType)this).getClassName(), ((ObjectType)T).getClassName())) {
                return true;
            }
        }
        if (this instanceof ObjectType && ((ObjectType)this).referencesInterface()) {
            if (T instanceof ObjectType && ((ObjectType)T).referencesClass() && T.equals(Type.OBJECT)) {
                return true;
            }
            if (T instanceof ObjectType && ((ObjectType)T).referencesInterface()) {
                if (this.equals(T)) {
                    return true;
                }
                if (Repository.implementationOf(((ObjectType)this).getClassName(), ((ObjectType)T).getClassName())) {
                    return true;
                }
            }
        }
        if (this instanceof ArrayType) {
            if (T instanceof ObjectType && ((ObjectType)T).referencesClass() && T.equals(Type.OBJECT)) {
                return true;
            }
            if (T instanceof ArrayType) {
                Type sc = ((ArrayType)this).getElementType();
                Type tc = ((ArrayType)this).getElementType();
                if (sc instanceof BasicType && tc instanceof BasicType && sc.equals(tc)) {
                    return true;
                }
                if (tc instanceof ReferenceType && sc instanceof ReferenceType && ((ReferenceType)sc).isAssignmentCompatibleWith((ReferenceType)tc)) {
                    return true;
                }
            }
            if (T instanceof ObjectType && ((ObjectType)T).referencesInterface()) {
                int ii = 0;
                while (ii < Constants.INTERFACES_IMPLEMENTED_BY_ARRAYS.length) {
                    if (T.equals(new ObjectType(Constants.INTERFACES_IMPLEMENTED_BY_ARRAYS[ii]))) {
                        return true;
                    }
                    ++ii;
                }
            }
        }
        return false;
    }

    public ReferenceType firstCommonSuperclass(ReferenceType t) {
        if (this.equals(Type.NULL)) {
            return t;
        }
        if (t.equals(Type.NULL)) {
            return this;
        }
        if (this.equals(t)) {
            return this;
        }
        if (this instanceof ArrayType || t instanceof ArrayType) {
            return Type.OBJECT;
        }
        if (this instanceof ObjectType && ((ObjectType)this).referencesInterface() || t instanceof ObjectType && ((ObjectType)t).referencesInterface()) {
            return Type.OBJECT;
        }
        ObjectType thiz = (ObjectType)this;
        ObjectType other = (ObjectType)t;
        JavaClass[] thiz_sups = Repository.getSuperClasses(thiz.getClassName());
        JavaClass[] other_sups = Repository.getSuperClasses(other.getClassName());
        if (thiz_sups == null || other_sups == null) {
            return null;
        }
        JavaClass[] this_sups = new JavaClass[thiz_sups.length + 1];
        JavaClass[] t_sups = new JavaClass[other_sups.length + 1];
        System.arraycopy(thiz_sups, 0, this_sups, 1, thiz_sups.length);
        System.arraycopy(other_sups, 0, t_sups, 1, other_sups.length);
        this_sups[0] = Repository.lookupClass(thiz.getClassName());
        t_sups[0] = Repository.lookupClass(other.getClassName());
        int i = 0;
        while (i < t_sups.length) {
            int j = 0;
            while (j < this_sups.length) {
                if (this_sups[j].equals(t_sups[i])) {
                    return new ObjectType(this_sups[j].getClassName());
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

