/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import oadd.org.apache.bcel.classfile.Attribute;
import oadd.org.apache.bcel.classfile.ConstantPool;
import oadd.org.apache.bcel.classfile.ConstantValue;
import oadd.org.apache.bcel.classfile.FieldOrMethod;
import oadd.org.apache.bcel.classfile.Utility;
import oadd.org.apache.bcel.classfile.Visitor;

public final class Field
extends FieldOrMethod {
    public Field(Field c) {
        super(c);
    }

    Field(DataInputStream file, ConstantPool constant_pool) throws IOException, ClassFormatError {
        super(file, constant_pool);
    }

    public Field(int access_flags, int name_index, int signature_index, Attribute[] attributes, ConstantPool constant_pool) {
        super(access_flags, name_index, signature_index, attributes, constant_pool);
    }

    public void accept(Visitor v) {
        v.visitField(this);
    }

    public final ConstantValue getConstantValue() {
        int i = 0;
        while (i < this.attributes_count) {
            if (this.attributes[i].getTag() == 1) {
                return (ConstantValue)this.attributes[i];
            }
            ++i;
        }
        return null;
    }

    public final String toString() {
        String access = Utility.accessToString(this.access_flags);
        access = access.equals("") ? "" : access + " ";
        String signature = Utility.signatureToString(this.getSignature());
        String name = this.getName();
        StringBuffer buf = new StringBuffer(access + signature + " " + name);
        ConstantValue cv = this.getConstantValue();
        if (cv != null) {
            buf.append(" = " + cv);
        }
        int i = 0;
        while (i < this.attributes_count) {
            Attribute a = this.attributes[i];
            if (!(a instanceof ConstantValue)) {
                buf.append(" [" + a.toString() + "]");
            }
            ++i;
        }
        return buf.toString();
    }

    public final Field copy(ConstantPool constant_pool) {
        return (Field)this.copy_(constant_pool);
    }
}

