/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.antlr.stringtemplate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oadd.org.antlr.stringtemplate.StringTemplateErrorListener;
import oadd.org.antlr.stringtemplate.StringTemplateGroup;
import oadd.org.antlr.stringtemplate.StringTemplateGroupInterface;
import oadd.org.antlr.stringtemplate.StringTemplateGroupLoader;
import oadd.org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class PathGroupLoader
implements StringTemplateGroupLoader {
    protected List dirs = null;
    protected StringTemplateErrorListener errors = null;
    String fileCharEncoding = System.getProperty("file.encoding");

    public PathGroupLoader(StringTemplateErrorListener errors) {
        this.errors = errors;
    }

    public PathGroupLoader(String dirStr, StringTemplateErrorListener errors) {
        this.errors = errors;
        StringTokenizer tokenizer = new StringTokenizer(dirStr, ":", false);
        while (tokenizer.hasMoreElements()) {
            String dir = (String)tokenizer.nextElement();
            if (this.dirs == null) {
                this.dirs = new ArrayList();
            }
            this.dirs.add(dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringTemplateGroup loadGroup(String groupName, Class templateLexer, StringTemplateGroup superGroup) {
        Class lexer;
        StringTemplateGroup group = null;
        BufferedReader br = null;
        Class clazz = lexer = AngleBracketTemplateLexer.class;
        if (templateLexer != null) {
            lexer = templateLexer;
        }
        try {
            br = this.locate(groupName + ".stg");
            if (br == null) {
                this.error("no such group file " + groupName + ".stg");
                StringTemplateGroup stringTemplateGroup = null;
                return stringTemplateGroup;
            }
            group = new StringTemplateGroup(br, lexer, this.errors, superGroup);
            br.close();
            br = null;
        }
        catch (IOException ioe) {
            this.error("can't load group " + groupName, ioe);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe2) {
                    this.error("Cannot close template group file: " + groupName + ".stg", ioe2);
                }
            }
        }
        return group;
    }

    public StringTemplateGroup loadGroup(String groupName, StringTemplateGroup superGroup) {
        return this.loadGroup(groupName, null, superGroup);
    }

    public StringTemplateGroup loadGroup(String groupName) {
        return this.loadGroup(groupName, null);
    }

    public StringTemplateGroupInterface loadInterface(String interfaceName) {
        StringTemplateGroupInterface I = null;
        try {
            BufferedReader br = this.locate(interfaceName + ".sti");
            if (br == null) {
                this.error("no such interface file " + interfaceName + ".sti");
                return null;
            }
            I = new StringTemplateGroupInterface(br, this.errors);
        }
        catch (IOException ioe) {
            this.error("can't load interface " + interfaceName, ioe);
        }
        return I;
    }

    protected BufferedReader locate(String name) throws IOException {
        for (int i = 0; i < this.dirs.size(); ++i) {
            String dir = (String)this.dirs.get(i);
            String fileName = dir + "/" + name;
            if (!new File(fileName).exists()) continue;
            FileInputStream fis = new FileInputStream(fileName);
            InputStreamReader isr = this.getInputStreamReader(fis);
            return new BufferedReader(isr);
        }
        return null;
    }

    protected InputStreamReader getInputStreamReader(InputStream in) {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(in, this.fileCharEncoding);
        }
        catch (UnsupportedEncodingException uee) {
            this.error("Invalid file character encoding: " + this.fileCharEncoding);
        }
        return isr;
    }

    public String getFileCharEncoding() {
        return this.fileCharEncoding;
    }

    public void setFileCharEncoding(String fileCharEncoding) {
        this.fileCharEncoding = fileCharEncoding;
    }

    public void error(String msg) {
        this.error(msg, null);
    }

    public void error(String msg, Exception e) {
        if (this.errors != null) {
            this.errors.error(msg, e);
        } else {
            System.err.println("StringTemplate: " + msg);
            if (e != null) {
                e.printStackTrace();
            }
        }
    }
}

