/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.netty.buffer;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import oadd.com.codahale.metrics.Gauge;
import oadd.com.codahale.metrics.Histogram;
import oadd.com.codahale.metrics.Metric;
import oadd.com.codahale.metrics.MetricFilter;
import oadd.com.codahale.metrics.MetricRegistry;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.LargeBuffer;
import oadd.io.netty.buffer.PoolArena;
import oadd.io.netty.buffer.PoolThreadCache;
import oadd.io.netty.buffer.PooledByteBuf;
import oadd.io.netty.buffer.PooledByteBufAllocator;
import oadd.io.netty.buffer.PooledUnsafeDirectByteBuf;
import oadd.io.netty.buffer.UnpooledByteBufAllocator;
import oadd.io.netty.buffer.UnsafeDirectLittleEndian;
import oadd.io.netty.util.internal.StringUtil;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.exec.metrics.DrillMetrics;
import oadd.org.apache.drill.exec.util.AssertionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledByteBufAllocatorL
extends PooledByteBufAllocator {
    static final Logger logger = LoggerFactory.getLogger(PooledByteBufAllocatorL.class);
    private static final Logger memoryLogger = LoggerFactory.getLogger("drill.allocator");
    private static final int MEMORY_LOGGER_FREQUENCY_SECONDS = 60;
    private static final String METRIC_PREFIX = "drill.allocator.";
    public static final PooledByteBufAllocatorL DEFAULT = new PooledByteBufAllocatorL();
    private final MetricRegistry registry = DrillMetrics.getInstance();
    private final AtomicLong hugeBufferSize = new AtomicLong(0L);
    private final AtomicLong hugeBufferCount = new AtomicLong(0L);
    private final AtomicLong normalBufferSize = new AtomicLong(0L);
    private final AtomicLong normalBufferCount = new AtomicLong(0L);
    private final PoolArena<ByteBuffer>[] directArenas;
    private final MemoryStatusThread statusThread;
    private final Histogram largeBuffersHist;
    private final Histogram normalBuffersHist;

    private PooledByteBufAllocatorL() {
        super(true);
        try {
            Field f = PooledByteBufAllocator.class.getDeclaredField("directArenas");
            f.setAccessible(true);
            this.directArenas = (PoolArena[])f.get(this);
        }
        catch (Exception e) {
            throw new RuntimeException("Failure while initializing allocator.  Unable to retrieve direct arenas field.", e);
        }
        if (memoryLogger.isTraceEnabled()) {
            this.statusThread = new MemoryStatusThread();
            this.statusThread.start();
        } else {
            this.statusThread = null;
        }
        this.removeOldMetrics();
        this.registry.register("drill.allocator.normal.size", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return PooledByteBufAllocatorL.this.normalBufferSize.get();
            }
        });
        this.registry.register("drill.allocator.normal.count", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return PooledByteBufAllocatorL.this.normalBufferCount.get();
            }
        });
        this.registry.register("drill.allocator.huge.size", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return PooledByteBufAllocatorL.this.hugeBufferSize.get();
            }
        });
        this.registry.register("drill.allocator.huge.count", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return PooledByteBufAllocatorL.this.hugeBufferCount.get();
            }
        });
        this.largeBuffersHist = this.registry.histogram("drill.allocator.huge.hist");
        this.normalBuffersHist = this.registry.histogram("drill.allocator.normal.hist");
    }

    private synchronized void removeOldMetrics() {
        this.registry.removeMatching(new MetricFilter(){

            @Override
            public boolean matches(String name, Metric metric) {
                return name.startsWith(PooledByteBufAllocatorL.METRIC_PREFIX);
            }
        });
    }

    @Override
    protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
        throw new UnsupportedOperationException("Drill doesn't support using heap buffers.");
    }

    @Override
    protected UnsafeDirectLittleEndian newDirectBuffer(int initialCapacity, int maxCapacity) {
        PoolThreadCache cache = (PoolThreadCache)this.threadCache.get();
        PoolArena<ByteBuffer> directArena = cache.directArena;
        if (directArena != null) {
            if (initialCapacity > directArena.chunkSize) {
                ByteBuf buf = UnpooledByteBufAllocator.DEFAULT.directBuffer(initialCapacity, maxCapacity);
                this.hugeBufferCount.incrementAndGet();
                this.hugeBufferSize.addAndGet(buf.capacity());
                this.largeBuffersHist.update(buf.capacity());
                return new UnsafeDirectLittleEndian(new LargeBuffer(buf, this.hugeBufferSize, this.hugeBufferCount));
            }
            PooledByteBuf<ByteBuffer> buf = directArena.allocate(cache, initialCapacity, maxCapacity);
            if (!(buf instanceof PooledUnsafeDirectByteBuf)) {
                this.fail();
            }
            this.normalBuffersHist.update(((ByteBuf)buf).capacity());
            if (AssertionUtil.ASSERT_ENABLED) {
                this.normalBufferSize.addAndGet(((ByteBuf)buf).capacity());
                this.normalBufferCount.incrementAndGet();
            }
            return new UnsafeDirectLittleEndian((PooledUnsafeDirectByteBuf)buf, this.normalBufferCount, this.normalBufferSize);
        }
        throw this.fail();
    }

    private UnsupportedOperationException fail() {
        return new UnsupportedOperationException("Drill requries that the JVM used supports access sun.misc.Unsafe.  This platform didn't provide that functionality.");
    }

    @Override
    public UnsafeDirectLittleEndian directBuffer(int initialCapacity, int maxCapacity) {
        if (initialCapacity == 0 && maxCapacity == 0) {
            this.newDirectBuffer(initialCapacity, maxCapacity);
        }
        PooledByteBufAllocatorL.validate(initialCapacity, maxCapacity);
        return this.newDirectBuffer(initialCapacity, maxCapacity);
    }

    @Override
    public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
        throw new UnsupportedOperationException("Drill doesn't support using heap buffers.");
    }

    private static void validate(int initialCapacity, int maxCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity: " + initialCapacity + " (expectd: 0+)");
        }
        if (initialCapacity > maxCapacity) {
            throw new IllegalArgumentException(String.format("initialCapacity: %d (expected: not greater than maxCapacity(%d)", initialCapacity, maxCapacity));
        }
    }

    public void checkAndReset() {
        if (this.hugeBufferCount.get() != 0L || this.normalBufferCount.get() != 0L) {
            StringBuilder buf = new StringBuilder();
            buf.append("Large buffers outstanding: ");
            buf.append(this.hugeBufferCount.get());
            buf.append(" totaling ");
            buf.append(this.hugeBufferSize.get());
            buf.append(" bytes.");
            buf.append('\n');
            buf.append("Normal buffers outstanding: ");
            buf.append(this.normalBufferCount.get());
            buf.append(" totaling ");
            buf.append(this.normalBufferSize.get());
            buf.append(" bytes.");
            this.hugeBufferCount.set(0L);
            this.normalBufferCount.set(0L);
            this.hugeBufferSize.set(0L);
            this.normalBufferSize.set(0L);
            throw new DrillRuntimeException(buf.toString());
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.directArenas.length);
        buf.append(" direct arena(s):");
        buf.append(StringUtil.NEWLINE);
        for (PoolArena<ByteBuffer> a : this.directArenas) {
            buf.append(a);
        }
        buf.append("Large buffers outstanding: ");
        buf.append(this.hugeBufferCount.get());
        buf.append(" totaling ");
        buf.append(this.hugeBufferSize.get());
        buf.append(" bytes.");
        buf.append('\n');
        buf.append("Normal buffers outstanding: ");
        buf.append(this.normalBufferCount.get());
        buf.append(" totaling ");
        buf.append(this.normalBufferSize.get());
        buf.append(" bytes.");
        return buf.toString();
    }

    private class MemoryStatusThread
    extends Thread {
        public MemoryStatusThread() {
            super("memory-status-logger");
            this.setDaemon(true);
            this.setName("allocation.logger");
        }

        @Override
        public void run() {
            while (true) {
                memoryLogger.trace("Memory Usage: \n{}", (Object)PooledByteBufAllocatorL.this.toString());
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }
}

