/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.databind.introspect;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import oadd.com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import oadd.com.fasterxml.jackson.annotation.JacksonInject;
import oadd.com.fasterxml.jackson.annotation.JsonAnyGetter;
import oadd.com.fasterxml.jackson.annotation.JsonAnySetter;
import oadd.com.fasterxml.jackson.annotation.JsonAutoDetect;
import oadd.com.fasterxml.jackson.annotation.JsonBackReference;
import oadd.com.fasterxml.jackson.annotation.JsonCreator;
import oadd.com.fasterxml.jackson.annotation.JsonFilter;
import oadd.com.fasterxml.jackson.annotation.JsonFormat;
import oadd.com.fasterxml.jackson.annotation.JsonGetter;
import oadd.com.fasterxml.jackson.annotation.JsonIdentityInfo;
import oadd.com.fasterxml.jackson.annotation.JsonIdentityReference;
import oadd.com.fasterxml.jackson.annotation.JsonIgnore;
import oadd.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import oadd.com.fasterxml.jackson.annotation.JsonIgnoreType;
import oadd.com.fasterxml.jackson.annotation.JsonInclude;
import oadd.com.fasterxml.jackson.annotation.JsonManagedReference;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.com.fasterxml.jackson.annotation.JsonPropertyDescription;
import oadd.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import oadd.com.fasterxml.jackson.annotation.JsonRawValue;
import oadd.com.fasterxml.jackson.annotation.JsonRootName;
import oadd.com.fasterxml.jackson.annotation.JsonSetter;
import oadd.com.fasterxml.jackson.annotation.JsonSubTypes;
import oadd.com.fasterxml.jackson.annotation.JsonTypeId;
import oadd.com.fasterxml.jackson.annotation.JsonTypeInfo;
import oadd.com.fasterxml.jackson.annotation.JsonTypeName;
import oadd.com.fasterxml.jackson.annotation.JsonUnwrapped;
import oadd.com.fasterxml.jackson.annotation.JsonValue;
import oadd.com.fasterxml.jackson.annotation.JsonView;
import oadd.com.fasterxml.jackson.annotation.ObjectIdGenerators;
import oadd.com.fasterxml.jackson.core.Version;
import oadd.com.fasterxml.jackson.databind.AnnotationIntrospector;
import oadd.com.fasterxml.jackson.databind.JavaType;
import oadd.com.fasterxml.jackson.databind.JsonDeserializer;
import oadd.com.fasterxml.jackson.databind.JsonSerializer;
import oadd.com.fasterxml.jackson.databind.KeyDeserializer;
import oadd.com.fasterxml.jackson.databind.PropertyName;
import oadd.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import oadd.com.fasterxml.jackson.databind.annotation.JsonNaming;
import oadd.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import oadd.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import oadd.com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import oadd.com.fasterxml.jackson.databind.annotation.JsonTypeResolver;
import oadd.com.fasterxml.jackson.databind.annotation.JsonValueInstantiator;
import oadd.com.fasterxml.jackson.databind.cfg.MapperConfig;
import oadd.com.fasterxml.jackson.databind.cfg.PackageVersion;
import oadd.com.fasterxml.jackson.databind.introspect.Annotated;
import oadd.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import oadd.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import oadd.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import oadd.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import oadd.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import oadd.com.fasterxml.jackson.databind.jsontype.NamedType;
import oadd.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import oadd.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import oadd.com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import oadd.com.fasterxml.jackson.databind.ser.std.RawSerializer;
import oadd.com.fasterxml.jackson.databind.util.ClassUtil;
import oadd.com.fasterxml.jackson.databind.util.Converter;
import oadd.com.fasterxml.jackson.databind.util.NameTransformer;

public class JacksonAnnotationIntrospector
extends AnnotationIntrospector
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public boolean isAnnotationBundle(Annotation ann) {
        return ann.annotationType().getAnnotation(JacksonAnnotationsInside.class) != null;
    }

    @Override
    public PropertyName findRootName(AnnotatedClass ac) {
        JsonRootName ann = ac.getAnnotation(JsonRootName.class);
        if (ann == null) {
            return null;
        }
        String ns = ann.namespace();
        if (ns != null && ns.length() == 0) {
            ns = null;
        }
        return PropertyName.construct(ann.value(), ns);
    }

    @Override
    public String[] findPropertiesToIgnore(Annotated ac) {
        JsonIgnoreProperties ignore = ac.getAnnotation(JsonIgnoreProperties.class);
        return ignore == null ? null : ignore.value();
    }

    @Override
    public Boolean findIgnoreUnknownProperties(AnnotatedClass ac) {
        JsonIgnoreProperties ignore = ac.getAnnotation(JsonIgnoreProperties.class);
        return ignore == null ? null : Boolean.valueOf(ignore.ignoreUnknown());
    }

    @Override
    public Boolean isIgnorableType(AnnotatedClass ac) {
        JsonIgnoreType ignore = ac.getAnnotation(JsonIgnoreType.class);
        return ignore == null ? null : Boolean.valueOf(ignore.value());
    }

    @Override
    @Deprecated
    public Object findFilterId(AnnotatedClass ac) {
        return this._findFilterId(ac);
    }

    @Override
    public Object findFilterId(Annotated a) {
        return this._findFilterId(a);
    }

    protected final Object _findFilterId(Annotated a) {
        String id;
        JsonFilter ann = a.getAnnotation(JsonFilter.class);
        if (ann != null && (id = ann.value()).length() > 0) {
            return id;
        }
        return null;
    }

    @Override
    public Object findNamingStrategy(AnnotatedClass ac) {
        JsonNaming ann = ac.getAnnotation(JsonNaming.class);
        return ann == null ? null : ann.value();
    }

    @Override
    public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass ac, VisibilityChecker<?> checker) {
        JsonAutoDetect ann = ac.getAnnotation(JsonAutoDetect.class);
        return ann == null ? checker : checker.with(ann);
    }

    @Override
    public AnnotationIntrospector.ReferenceProperty findReferenceType(AnnotatedMember member) {
        JsonManagedReference ref1 = member.getAnnotation(JsonManagedReference.class);
        if (ref1 != null) {
            return AnnotationIntrospector.ReferenceProperty.managed(ref1.value());
        }
        JsonBackReference ref2 = member.getAnnotation(JsonBackReference.class);
        if (ref2 != null) {
            return AnnotationIntrospector.ReferenceProperty.back(ref2.value());
        }
        return null;
    }

    @Override
    public NameTransformer findUnwrappingNameTransformer(AnnotatedMember member) {
        JsonUnwrapped ann = member.getAnnotation(JsonUnwrapped.class);
        if (ann == null || !ann.enabled()) {
            return null;
        }
        String prefix = ann.prefix();
        String suffix = ann.suffix();
        return NameTransformer.simpleTransformer(prefix, suffix);
    }

    @Override
    public boolean hasIgnoreMarker(AnnotatedMember m) {
        return this._isIgnorable(m);
    }

    @Override
    public Boolean hasRequiredMarker(AnnotatedMember m) {
        JsonProperty ann = m.getAnnotation(JsonProperty.class);
        if (ann != null) {
            return ann.required();
        }
        return null;
    }

    @Override
    public Object findInjectableValueId(AnnotatedMember m) {
        JacksonInject ann = m.getAnnotation(JacksonInject.class);
        if (ann == null) {
            return null;
        }
        String id = ann.value();
        if (id.length() == 0) {
            if (!(m instanceof AnnotatedMethod)) {
                return m.getRawType().getName();
            }
            AnnotatedMethod am = (AnnotatedMethod)m;
            if (am.getParameterCount() == 0) {
                return m.getRawType().getName();
            }
            return am.getRawParameterType(0).getName();
        }
        return id;
    }

    @Override
    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> config, AnnotatedClass ac, JavaType baseType) {
        return this._findTypeResolver(config, ac, baseType);
    }

    @Override
    public TypeResolverBuilder<?> findPropertyTypeResolver(MapperConfig<?> config, AnnotatedMember am, JavaType baseType) {
        if (baseType.isContainerType()) {
            return null;
        }
        return this._findTypeResolver(config, am, baseType);
    }

    @Override
    public TypeResolverBuilder<?> findPropertyContentTypeResolver(MapperConfig<?> config, AnnotatedMember am, JavaType containerType) {
        if (!containerType.isContainerType()) {
            throw new IllegalArgumentException("Must call method with a container type (got " + containerType + ")");
        }
        return this._findTypeResolver(config, am, containerType);
    }

    @Override
    public List<NamedType> findSubtypes(Annotated a) {
        JsonSubTypes t = a.getAnnotation(JsonSubTypes.class);
        if (t == null) {
            return null;
        }
        JsonSubTypes.Type[] types = t.value();
        ArrayList<NamedType> result = new ArrayList<NamedType>(types.length);
        for (JsonSubTypes.Type type : types) {
            result.add(new NamedType(type.value(), type.name()));
        }
        return result;
    }

    @Override
    public String findTypeName(AnnotatedClass ac) {
        JsonTypeName tn = ac.getAnnotation(JsonTypeName.class);
        return tn == null ? null : tn.value();
    }

    @Override
    public Object findSerializer(Annotated a) {
        Class<? extends JsonSerializer<?>> serClass;
        JsonSerialize ann = a.getAnnotation(JsonSerialize.class);
        if (ann != null && (serClass = ann.using()) != JsonSerializer.None.class) {
            return serClass;
        }
        JsonRawValue annRaw = a.getAnnotation(JsonRawValue.class);
        if (annRaw != null && annRaw.value()) {
            Class<?> cls = a.getRawType();
            return new RawSerializer(cls);
        }
        return null;
    }

    @Override
    public Class<? extends JsonSerializer<?>> findKeySerializer(Annotated a) {
        Class<? extends JsonSerializer<?>> serClass;
        JsonSerialize ann = a.getAnnotation(JsonSerialize.class);
        if (ann != null && (serClass = ann.keyUsing()) != JsonSerializer.None.class) {
            return serClass;
        }
        return null;
    }

    @Override
    public Class<? extends JsonSerializer<?>> findContentSerializer(Annotated a) {
        Class<? extends JsonSerializer<?>> serClass;
        JsonSerialize ann = a.getAnnotation(JsonSerialize.class);
        if (ann != null && (serClass = ann.contentUsing()) != JsonSerializer.None.class) {
            return serClass;
        }
        return null;
    }

    @Override
    public Object findNullSerializer(Annotated a) {
        Class<? extends JsonSerializer<?>> serClass;
        JsonSerialize ann = a.getAnnotation(JsonSerialize.class);
        if (ann != null && (serClass = ann.nullsUsing()) != JsonSerializer.None.class) {
            return serClass;
        }
        return null;
    }

    @Override
    public JsonInclude.Include findSerializationInclusion(Annotated a, JsonInclude.Include defValue) {
        JsonInclude inc = a.getAnnotation(JsonInclude.class);
        if (inc != null) {
            return inc.value();
        }
        JsonSerialize ann = a.getAnnotation(JsonSerialize.class);
        if (ann != null) {
            JsonSerialize.Inclusion i2 = ann.include();
            switch (i2) {
                case ALWAYS: {
                    return JsonInclude.Include.ALWAYS;
                }
                case NON_NULL: {
                    return JsonInclude.Include.NON_NULL;
                }
                case NON_DEFAULT: {
                    return JsonInclude.Include.NON_DEFAULT;
                }
                case NON_EMPTY: {
                    return JsonInclude.Include.NON_EMPTY;
                }
            }
        }
        return defValue;
    }

    @Override
    public Class<?> findSerializationType(Annotated am) {
        JsonSerialize ann = am.getAnnotation(JsonSerialize.class);
        return ann == null ? null : this._classIfExplicit(ann.as());
    }

    @Override
    public Class<?> findSerializationKeyType(Annotated am, JavaType baseType) {
        JsonSerialize ann = am.getAnnotation(JsonSerialize.class);
        return ann == null ? null : this._classIfExplicit(ann.keyAs());
    }

    @Override
    public Class<?> findSerializationContentType(Annotated am, JavaType baseType) {
        JsonSerialize ann = am.getAnnotation(JsonSerialize.class);
        return ann == null ? null : this._classIfExplicit(ann.contentAs());
    }

    @Override
    public JsonSerialize.Typing findSerializationTyping(Annotated a) {
        JsonSerialize ann = a.getAnnotation(JsonSerialize.class);
        return ann == null ? null : ann.typing();
    }

    @Override
    public Object findSerializationConverter(Annotated a) {
        JsonSerialize ann = a.getAnnotation(JsonSerialize.class);
        return ann == null ? null : this._classIfExplicit(ann.converter(), Converter.None.class);
    }

    @Override
    public Object findSerializationContentConverter(AnnotatedMember a) {
        JsonSerialize ann = a.getAnnotation(JsonSerialize.class);
        return ann == null ? null : this._classIfExplicit(ann.contentConverter(), Converter.None.class);
    }

    @Override
    public Class<?>[] findViews(Annotated a) {
        JsonView ann = a.getAnnotation(JsonView.class);
        return ann == null ? null : ann.value();
    }

    @Override
    public Boolean isTypeId(AnnotatedMember member) {
        return member.hasAnnotation(JsonTypeId.class);
    }

    @Override
    public ObjectIdInfo findObjectIdInfo(Annotated ann) {
        JsonIdentityInfo info = ann.getAnnotation(JsonIdentityInfo.class);
        if (info == null || info.generator() == ObjectIdGenerators.None.class) {
            return null;
        }
        PropertyName name = new PropertyName(info.property());
        return new ObjectIdInfo(name, info.scope(), info.generator(), info.resolver());
    }

    @Override
    public ObjectIdInfo findObjectReferenceInfo(Annotated ann, ObjectIdInfo objectIdInfo) {
        JsonIdentityReference ref = ann.getAnnotation(JsonIdentityReference.class);
        if (ref != null) {
            objectIdInfo = objectIdInfo.withAlwaysAsId(ref.alwaysAsId());
        }
        return objectIdInfo;
    }

    @Override
    public JsonFormat.Value findFormat(Annotated annotated) {
        JsonFormat ann = annotated.getAnnotation(JsonFormat.class);
        return ann == null ? null : new JsonFormat.Value(ann);
    }

    @Override
    public String findPropertyDescription(Annotated annotated) {
        JsonPropertyDescription desc = annotated.getAnnotation(JsonPropertyDescription.class);
        return desc == null ? null : desc.value();
    }

    @Override
    public Integer findPropertyIndex(Annotated annotated) {
        int ix;
        JsonProperty ann = annotated.getAnnotation(JsonProperty.class);
        if (ann != null && (ix = ann.index()) != -1) {
            return ix;
        }
        return null;
    }

    @Override
    public String findImplicitPropertyName(AnnotatedMember param) {
        return null;
    }

    @Override
    public String[] findSerializationPropertyOrder(AnnotatedClass ac) {
        JsonPropertyOrder order = ac.getAnnotation(JsonPropertyOrder.class);
        return order == null ? null : order.value();
    }

    @Override
    public Boolean findSerializationSortAlphabetically(Annotated ann) {
        return this._findSortAlpha(ann);
    }

    @Override
    @Deprecated
    public Boolean findSerializationSortAlphabetically(AnnotatedClass ac) {
        return this._findSortAlpha(ac);
    }

    private final Boolean _findSortAlpha(Annotated ann) {
        JsonPropertyOrder order = ann.getAnnotation(JsonPropertyOrder.class);
        return order == null ? null : Boolean.valueOf(order.alphabetic());
    }

    @Override
    public PropertyName findNameForSerialization(Annotated a) {
        String name = null;
        JsonGetter jg = a.getAnnotation(JsonGetter.class);
        if (jg != null) {
            name = jg.value();
        } else {
            JsonProperty pann = a.getAnnotation(JsonProperty.class);
            if (pann != null) {
                name = pann.value();
            } else if (a.hasAnnotation(JsonSerialize.class) || a.hasAnnotation(JsonView.class)) {
                name = "";
            } else {
                return null;
            }
        }
        if (name.length() == 0) {
            return PropertyName.USE_DEFAULT;
        }
        return new PropertyName(name);
    }

    @Override
    public boolean hasAsValueAnnotation(AnnotatedMethod am) {
        JsonValue ann = am.getAnnotation(JsonValue.class);
        return ann != null && ann.value();
    }

    @Override
    public Class<? extends JsonDeserializer<?>> findDeserializer(Annotated a) {
        Class<? extends JsonDeserializer<?>> deserClass;
        JsonDeserialize ann = a.getAnnotation(JsonDeserialize.class);
        if (ann != null && (deserClass = ann.using()) != JsonDeserializer.None.class) {
            return deserClass;
        }
        return null;
    }

    @Override
    public Class<? extends KeyDeserializer> findKeyDeserializer(Annotated a) {
        Class<? extends KeyDeserializer> deserClass;
        JsonDeserialize ann = a.getAnnotation(JsonDeserialize.class);
        if (ann != null && (deserClass = ann.keyUsing()) != KeyDeserializer.None.class) {
            return deserClass;
        }
        return null;
    }

    @Override
    public Class<? extends JsonDeserializer<?>> findContentDeserializer(Annotated a) {
        Class<? extends JsonDeserializer<?>> deserClass;
        JsonDeserialize ann = a.getAnnotation(JsonDeserialize.class);
        if (ann != null && (deserClass = ann.contentUsing()) != JsonDeserializer.None.class) {
            return deserClass;
        }
        return null;
    }

    @Override
    public Class<?> findDeserializationType(Annotated am, JavaType baseType) {
        JsonDeserialize ann = am.getAnnotation(JsonDeserialize.class);
        return ann == null ? null : this._classIfExplicit(ann.as());
    }

    @Override
    public Class<?> findDeserializationKeyType(Annotated am, JavaType baseKeyType) {
        JsonDeserialize ann = am.getAnnotation(JsonDeserialize.class);
        return ann == null ? null : this._classIfExplicit(ann.keyAs());
    }

    @Override
    public Class<?> findDeserializationContentType(Annotated am, JavaType baseContentType) {
        JsonDeserialize ann = am.getAnnotation(JsonDeserialize.class);
        return ann == null ? null : this._classIfExplicit(ann.contentAs());
    }

    @Override
    public Object findDeserializationConverter(Annotated a) {
        JsonDeserialize ann = a.getAnnotation(JsonDeserialize.class);
        return ann == null ? null : this._classIfExplicit(ann.converter(), Converter.None.class);
    }

    @Override
    public Object findDeserializationContentConverter(AnnotatedMember a) {
        JsonDeserialize ann = a.getAnnotation(JsonDeserialize.class);
        return ann == null ? null : this._classIfExplicit(ann.contentConverter(), Converter.None.class);
    }

    @Override
    public Object findValueInstantiator(AnnotatedClass ac) {
        JsonValueInstantiator ann = ac.getAnnotation(JsonValueInstantiator.class);
        return ann == null ? null : ann.value();
    }

    @Override
    public Class<?> findPOJOBuilder(AnnotatedClass ac) {
        JsonDeserialize ann = ac.getAnnotation(JsonDeserialize.class);
        return ann == null ? null : this._classIfExplicit(ann.builder());
    }

    @Override
    public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass ac) {
        JsonPOJOBuilder ann = ac.getAnnotation(JsonPOJOBuilder.class);
        return ann == null ? null : new JsonPOJOBuilder.Value(ann);
    }

    @Override
    public PropertyName findNameForDeserialization(Annotated a) {
        String name;
        JsonSetter js = a.getAnnotation(JsonSetter.class);
        if (js != null) {
            name = js.value();
        } else {
            JsonProperty pann = a.getAnnotation(JsonProperty.class);
            if (pann != null) {
                name = pann.value();
            } else if (a.hasAnnotation(JsonDeserialize.class) || a.hasAnnotation(JsonView.class) || a.hasAnnotation(JsonUnwrapped.class) || a.hasAnnotation(JsonBackReference.class) || a.hasAnnotation(JsonManagedReference.class)) {
                name = "";
            } else {
                return null;
            }
        }
        if (name.length() == 0) {
            return PropertyName.USE_DEFAULT;
        }
        return new PropertyName(name);
    }

    @Override
    public boolean hasAnySetterAnnotation(AnnotatedMethod am) {
        return am.hasAnnotation(JsonAnySetter.class);
    }

    @Override
    public boolean hasAnyGetterAnnotation(AnnotatedMethod am) {
        return am.hasAnnotation(JsonAnyGetter.class);
    }

    @Override
    public boolean hasCreatorAnnotation(Annotated a) {
        return a.hasAnnotation(JsonCreator.class);
    }

    protected boolean _isIgnorable(Annotated a) {
        JsonIgnore ann = a.getAnnotation(JsonIgnore.class);
        return ann != null && ann.value();
    }

    protected Class<?> _classIfExplicit(Class<?> cls) {
        if (cls == null || ClassUtil.isBogusClass(cls)) {
            return null;
        }
        return cls;
    }

    protected Class<?> _classIfExplicit(Class<?> cls, Class<?> implicit) {
        return (cls = this._classIfExplicit(cls)) == null || cls == implicit ? null : cls;
    }

    protected TypeResolverBuilder<?> _findTypeResolver(MapperConfig<?> config, Annotated ann, JavaType baseType) {
        TypeIdResolver idRes;
        StdTypeResolverBuilder b;
        JsonTypeInfo info = ann.getAnnotation(JsonTypeInfo.class);
        JsonTypeResolver resAnn = ann.getAnnotation(JsonTypeResolver.class);
        if (resAnn != null) {
            if (info == null) {
                return null;
            }
            b = config.typeResolverBuilderInstance(ann, resAnn.value());
        } else {
            if (info == null) {
                return null;
            }
            if (info.use() == JsonTypeInfo.Id.NONE) {
                return this._constructNoTypeResolverBuilder();
            }
            b = this._constructStdTypeResolverBuilder();
        }
        JsonTypeIdResolver idResInfo = ann.getAnnotation(JsonTypeIdResolver.class);
        TypeIdResolver typeIdResolver = idRes = idResInfo == null ? null : config.typeIdResolverInstance(ann, idResInfo.value());
        if (idRes != null) {
            idRes.init(baseType);
        }
        b = b.init(info.use(), idRes);
        JsonTypeInfo.As inclusion = info.include();
        if (inclusion == JsonTypeInfo.As.EXTERNAL_PROPERTY && ann instanceof AnnotatedClass) {
            inclusion = JsonTypeInfo.As.PROPERTY;
        }
        b = b.inclusion(inclusion);
        b = b.typeProperty(info.property());
        Class<?> defaultImpl = info.defaultImpl();
        if (defaultImpl != JsonTypeInfo.None.class) {
            b = b.defaultImpl(defaultImpl);
        }
        b = b.typeIdVisibility(info.visible());
        return b;
    }

    protected StdTypeResolverBuilder _constructStdTypeResolverBuilder() {
        return new StdTypeResolverBuilder();
    }

    protected StdTypeResolverBuilder _constructNoTypeResolverBuilder() {
        return StdTypeResolverBuilder.noTypeInfoBuilder();
    }
}

