/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.carrotsearch.hppc;

import oadd.com.carrotsearch.hppc.ArraySizingStrategy;
import oadd.com.carrotsearch.hppc.LongArrayList;
import oadd.com.carrotsearch.hppc.LongContainer;
import oadd.com.carrotsearch.hppc.cursors.LongCursor;

public class LongStack
extends LongArrayList {
    public LongStack() {
    }

    public LongStack(int initialCapacity) {
        super(initialCapacity);
    }

    public LongStack(int initialCapacity, ArraySizingStrategy resizer) {
        super(initialCapacity, resizer);
    }

    public LongStack(LongContainer container) {
        super(container);
    }

    public final void push(long e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public final void push(long e1, long e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public final void push(long e1, long e2, long e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public final void push(long e1, long e2, long e3, long e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public final void push(long[] elements, int start, int len) {
        assert (start >= 0 && len >= 0);
        this.ensureBufferSpace(len);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, len);
        this.elementsCount += len;
    }

    public final void push(long ... elements) {
        this.push(elements, 0, elements.length);
    }

    public final int pushAll(LongContainer container) {
        return this.addAll(container);
    }

    public final int pushAll(Iterable<? extends LongCursor> iterable) {
        return this.addAll(iterable);
    }

    public final void discard(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
    }

    public final void discard() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
    }

    public final long pop() {
        assert (this.elementsCount > 0);
        long v = this.buffer[--this.elementsCount];
        return v;
    }

    public final long peek() {
        assert (this.elementsCount > 0);
        return this.buffer[this.elementsCount - 1];
    }

    public static LongStack newInstance() {
        return new LongStack();
    }

    public static LongStack newInstanceWithCapacity(int initialCapacity) {
        return new LongStack(initialCapacity);
    }

    public static LongStack from(long ... elements) {
        LongStack stack = new LongStack(elements.length);
        stack.push(elements);
        return stack;
    }

    public static LongStack from(LongContainer container) {
        return new LongStack(container);
    }

    @Override
    public LongStack clone() {
        return (LongStack)super.clone();
    }
}

