/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import oadd.com.carrotsearch.hppc.AbstractDoubleCollection;
import oadd.com.carrotsearch.hppc.AbstractIterator;
import oadd.com.carrotsearch.hppc.DoubleContainer;
import oadd.com.carrotsearch.hppc.DoubleLookupContainer;
import oadd.com.carrotsearch.hppc.DoubleSet;
import oadd.com.carrotsearch.hppc.Internals;
import oadd.com.carrotsearch.hppc.cursors.DoubleCursor;
import oadd.com.carrotsearch.hppc.predicates.DoublePredicate;
import oadd.com.carrotsearch.hppc.procedures.DoubleProcedure;

public class DoubleOpenHashSet
extends AbstractDoubleCollection
implements DoubleLookupContainer,
DoubleSet,
Cloneable {
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public double[] keys;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;

    public DoubleOpenHashSet() {
        this(16, 0.75f);
    }

    public DoubleOpenHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public DoubleOpenHashSet(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(4, initialCapacity);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor < 1.0f) : "Load factor must be between (0, 1).";
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public DoubleOpenHashSet(DoubleContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.addAll(container);
    }

    @Override
    public boolean add(double e) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(e) & mask;
        while (this.allocated[slot]) {
            if (e == this.keys[slot]) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = e;
        return true;
    }

    public int add(double e1, double e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(double ... elements) {
        int count = 0;
        for (double e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public final int addAll(DoubleContainer container) {
        return this.addAll((Iterable<? extends DoubleCursor>)container);
    }

    public final int addAll(Iterable<? extends DoubleCursor> iterable) {
        int count = 0;
        for (DoubleCursor doubleCursor : iterable) {
            if (!this.add(doubleCursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndRehash() {
        double[] oldKeys = this.keys;
        boolean[] oldStates = this.allocated;
        assert (this.assigned >= this.resizeThreshold);
        this.allocateBuffers(this.nextCapacity(this.keys.length));
        int mask = this.allocated.length - 1;
        for (int i = 0; i < oldStates.length; ++i) {
            if (!oldStates[i]) continue;
            double key = oldKeys[i];
            int slot = Internals.rehash(key) & mask;
            while (this.allocated[slot] && key != this.keys[slot]) {
                slot = slot + 1 & mask;
            }
            this.allocated[slot] = true;
            this.keys[slot] = key;
        }
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = new double[capacity];
        this.allocated = new boolean[capacity];
        this.resizeThreshold = (int)((float)capacity * 0.75f);
    }

    @Override
    public int removeAllOccurrences(double key) {
        return this.remove(key) ? 1 : 0;
    }

    public boolean remove(double key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    protected final void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr]) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    public double lget() {
        assert (this.lastSlot >= 0) : "Call contains() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.keys[this.lastSlot];
    }

    @Override
    public boolean contains(double key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    protected int roundCapacity(int requestedCapacity) {
        int capacity;
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        for (capacity = 4; capacity < requestedCapacity; capacity <<= 1) {
        }
        return capacity;
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
        Arrays.fill(this.keys, 0.0);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        double[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = states.length;
        while (--i >= 0) {
            if (!states[i]) continue;
            h += Internals.rehash(keys[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            DoubleSet other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof DoubleSet && (other = (DoubleSet)obj).size() == this.size()) {
                for (DoubleCursor c : this) {
                    if (other.contains(c.value)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<DoubleCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends DoubleProcedure> T forEach(T procedure) {
        double[] keys = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i]);
        }
        return procedure;
    }

    @Override
    public final double[] toArray() {
        double[] cloned = new double[this.assigned];
        int j = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.allocated[i]) continue;
            cloned[j++] = this.keys[i];
        }
        return cloned;
    }

    public DoubleOpenHashSet clone() {
        try {
            DoubleOpenHashSet cloned = (DoubleOpenHashSet)super.clone();
            cloned.keys = (double[])this.keys.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends DoublePredicate> T forEach(T predicate) {
        double[] keys = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length && (!states[i] || predicate.apply(keys[i])); ++i) {
        }
        return predicate;
    }

    @Override
    public int removeAll(DoublePredicate predicate) {
        double[] keys = this.keys;
        boolean[] allocated = this.allocated;
        int before = this.assigned;
        int i = 0;
        while (i < allocated.length) {
            if (allocated[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    public static DoubleOpenHashSet from(double ... elements) {
        DoubleOpenHashSet set = new DoubleOpenHashSet((int)((float)elements.length * 1.75f));
        set.add(elements);
        return set;
    }

    public static DoubleOpenHashSet from(DoubleContainer container) {
        return new DoubleOpenHashSet(container);
    }

    public static DoubleOpenHashSet newInstance() {
        return new DoubleOpenHashSet();
    }

    public static DoubleOpenHashSet newInstanceWithCapacity(int initialCapacity, float loadFactor) {
        return new DoubleOpenHashSet(initialCapacity, loadFactor);
    }

    private final class EntryIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor = new DoubleCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected DoubleCursor fetch() {
            int i;
            int max = DoubleOpenHashSet.this.keys.length;
            for (i = this.cursor.index + 1; i < DoubleOpenHashSet.this.keys.length && !DoubleOpenHashSet.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (DoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = DoubleOpenHashSet.this.keys[i];
            return this.cursor;
        }
    }
}

