/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.carrotsearch.hppc;

import java.util.Arrays;
import oadd.com.carrotsearch.hppc.ShortCollection;
import oadd.com.carrotsearch.hppc.ShortLookupContainer;
import oadd.com.carrotsearch.hppc.cursors.ShortCursor;
import oadd.com.carrotsearch.hppc.predicates.ShortPredicate;

abstract class AbstractShortCollection
implements ShortCollection {
    AbstractShortCollection() {
    }

    @Override
    public int removeAll(ShortLookupContainer c) {
        final ShortLookupContainer c2 = c;
        return this.removeAll(new ShortPredicate(){

            @Override
            public boolean apply(short k) {
                return c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(ShortLookupContainer c) {
        final ShortLookupContainer c2 = c;
        return this.removeAll(new ShortPredicate(){

            @Override
            public boolean apply(short k) {
                return !c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final ShortPredicate predicate) {
        return this.removeAll(new ShortPredicate(){

            @Override
            public boolean apply(short value) {
                return !predicate.apply(value);
            }
        });
    }

    @Override
    public short[] toArray() {
        int size = this.size();
        short[] array = new short[size];
        int i = 0;
        for (ShortCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

