/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import oadd.org.apache.log4j.Logger;

public class LDAPUtil {
    public static final String LDAP_PARAM_PREFIX = "mapr.ldap.";
    public static final String ParamLdapUseConf = "mapr.ldap.useconf";
    public static final String ParamLdapConfPath = "mapr.ldap.conf.path";
    public static final String ParamLdapServer = "mapr.ldap.server";
    public static final String ParamLdapPort = "mapr.ldap.port";
    public static final String ParamLdapSslRequired = "mapr.ldap.sslrequired";
    public static final String ParamLdapBindDn = "mapr.ldap.binddn";
    public static final String ParamLdapBindDnPasswd = "mapr.ldap.binddnpasswd";
    public static final String ParamLdapBaseDn = "mapr.ldap.basedn";
    public static final String ParamLdapUidAttrib = "mapr.ldap.attribute.uid";
    public static final String ParamLdapMailAttrib = "mapr.ldap.attribute.mail";
    private static final Logger LOG = Logger.getLogger(LDAPUtil.class);

    public static String getEmailAddress(Properties prop, String user, boolean type) throws IOException {
        String uidAttrib;
        String uri = null;
        String baseDn = null;
        String bindDn = null;
        String bindDnPasswd = null;
        String useConf = prop.getProperty(ParamLdapUseConf);
        if (useConf != null && Integer.valueOf(useConf) > 0) {
            String ldapFile = prop.getProperty(ParamLdapConfPath);
            Properties ldapProp = new Properties();
            try {
                ldapProp.load(new FileInputStream(ldapFile));
            }
            catch (IOException e) {
                LOG.error((Object)("Could not open conf file: " + ldapFile + " " + e.getLocalizedMessage()));
                return null;
            }
            uri = ldapProp.getProperty("URI");
            if (uri == null || uri.isEmpty()) {
                LOG.error((Object)("Could not fetch URI from conf file " + ldapFile));
                return null;
            }
            baseDn = ldapProp.getProperty("BASE");
            if (baseDn == null || baseDn.isEmpty()) {
                LOG.error((Object)("Could not fetch BaseDn from conf file " + ldapFile));
                return null;
            }
        } else {
            String server = prop.getProperty(ParamLdapServer);
            if (server == null || server.isEmpty()) {
                LOG.error((Object)"Server not defined ");
                return null;
            }
            baseDn = prop.getProperty(ParamLdapBaseDn);
            if (baseDn == null || baseDn.isEmpty()) {
                LOG.error((Object)"BaseDn not defined ");
                return null;
            }
            bindDn = prop.getProperty(ParamLdapBindDn);
            if (bindDn == null || bindDn.isEmpty()) {
                LOG.error((Object)"BindDn not defined ");
                return null;
            }
            bindDnPasswd = prop.getProperty(ParamLdapBindDnPasswd);
            int ssl = Integer.valueOf(prop.getProperty(ParamLdapSslRequired, "0"));
            String portStr = prop.getProperty(ParamLdapPort);
            portStr = portStr == null || portStr.isEmpty() ? (ssl == 0 ? "389" : "636") : prop.getProperty(ParamLdapPort);
            String protocol = ssl == 0 ? "ldap" : "ldaps";
            uri = protocol + "://" + server + ":" + portStr + "/";
        }
        if ((uidAttrib = prop.getProperty(ParamLdapUidAttrib)) == null || uidAttrib.isEmpty()) {
            LOG.error((Object)"Uid Attribute not defined ");
            return null;
        }
        String mailAttrib = prop.getProperty(ParamLdapMailAttrib);
        if (mailAttrib == null || mailAttrib.isEmpty()) {
            LOG.error((Object)"Mail Attribute not defined ");
            return null;
        }
        Hashtable<String, String> env = new Hashtable<String, String>(11);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", uri);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", bindDn);
        if (bindDnPasswd != null && !bindDnPasswd.isEmpty()) {
            env.put("java.naming.security.credentials", bindDnPasswd);
        }
        InitialDirContext ctx = null;
        try {
            ctx = new InitialDirContext(env);
        }
        catch (Exception e) {
            LOG.error((Object)("Problem connecting to LDAP server:" + e.getLocalizedMessage()));
            return null;
        }
        String filter = "(" + uidAttrib + "=" + user + ")";
        String[] searchAttrs = new String[]{mailAttrib};
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        constraints.setTimeLimit(30000);
        constraints.setReturningAttributes(searchAttrs);
        String email = null;
        try {
            NamingEnumeration<SearchResult> answer = ctx.search(baseDn, filter, constraints);
            while (answer.hasMore()) {
                SearchResult ldapResult = answer.next();
                Attribute emailAttr = ldapResult.getAttributes().get(mailAttrib);
                email = (String)emailAttr.get();
            }
            ctx.close();
        }
        catch (NamingException e) {
            LOG.error((Object)("Problem fetching Email for user " + user + " from LDAP server:" + e.getLocalizedMessage()));
            return null;
        }
        return email;
    }
}

