/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.util;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.mail.Authenticator;
import oadd.org.apache.commons.codec.binary.Base64;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import oadd.org.apache.commons.mail.DefaultAuthenticator;
import oadd.org.apache.commons.mail.SimpleEmail;

public class EmailUtil {
    private static final String SMTP_PARAM_PREFIX = "mapr.smtp.";
    private static final String ParamSmtpPort = "mapr.smtp.port";
    private static final String ParamSmtpServer = "mapr.smtp.server";
    private static final String ParamSmtpSslRequired = "mapr.smtp.sslrequired";
    private static final String ParamSmtpSenderUserName = "mapr.smtp.sender.username";
    private static final String ParamSmtpSenderPassword = "mapr.smtp.sender.password";
    private static final String ParamSmtpSenderFullName = "mapr.smtp.sender.fullname";
    private static final String ParamSmtpSenderEmail = "mapr.smtp.sender.email";
    private static final Log LOG = LogFactory.getLog(EmailUtil.class);
    private static final String PassPhrase = "MapR_Random_$$_Phrase";
    private static SecretKey PassKey;
    private static Base64 base64decoder;

    public EmailUtil() throws Exception {
        DESKeySpec keySpec = new DESKeySpec(PassPhrase.getBytes("UTF8"));
        PassKey = SecretKeyFactory.getInstance("DES").generateSecret(keySpec);
        base64decoder = new Base64();
    }

    static String decryptPassword(String p) throws Exception {
        byte[] encryptedPwdBytes = base64decoder.decode(p);
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(2, PassKey);
        byte[] plainTextPwdBytes = cipher.doFinal(encryptedPwdBytes);
        return new String(plainTextPwdBytes);
    }

    public void sendEmail(Properties prop, String toAddr, String msg, String subject) throws Exception {
        String rcpt;
        String server = prop.getProperty(ParamSmtpServer);
        if (server == null || server.isEmpty()) {
            LOG.error((Object)"EmailUtil: Failed to send email, Invalid SMTP Server");
            return;
        }
        String portStr = prop.getProperty(ParamSmtpPort);
        if (portStr == null || portStr.isEmpty()) {
            LOG.error((Object)"EmailUtil: Failed to send email, Invalid SMTP Port");
            return;
        }
        int port = Integer.parseInt(portStr);
        if (port == 0) {
            LOG.error((Object)"EmailUtil: Failed to send email, Invalid SMTP Port");
            return;
        }
        String senderEmail = prop.getProperty(ParamSmtpSenderEmail);
        String string = rcpt = toAddr != null ? toAddr : senderEmail;
        if (rcpt == null || rcpt.isEmpty() || !this.validateEmail(rcpt)) {
            LOG.error((Object)"EmailUtil: Failed to send email, Invalid recipient");
            return;
        }
        String senderName = prop.getProperty(ParamSmtpSenderFullName);
        SimpleEmail email = new SimpleEmail();
        email.setHostName(server);
        email.setSmtpPort(port);
        boolean sslRequired = Boolean.parseBoolean(prop.getProperty(ParamSmtpSslRequired, "false"));
        if (sslRequired) {
            email.setTLS(true);
            email.setSSL(true);
        }
        String userName = prop.getProperty(ParamSmtpSenderUserName);
        String passwd = prop.getProperty(ParamSmtpSenderPassword);
        if (userName != null && !userName.isEmpty() && passwd != null && !passwd.isEmpty()) {
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(userName, EmailUtil.decryptPassword(passwd)));
        }
        email.setDebug(LOG.isDebugEnabled());
        if (senderEmail != null && !senderEmail.isEmpty() && this.validateEmail(senderEmail)) {
            email.setFrom(senderEmail, senderName);
        }
        email.addTo(rcpt);
        email.setSubject(subject);
        email.setMsg(msg);
        email.send();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("EmailUtil: Sent email to " + rcpt));
        }
    }

    private boolean validateEmail(String email) {
        Pattern p = Pattern.compile(".+@.+\\.[a-z]+");
        Matcher m = p.matcher(email);
        return m.matches();
    }
}

