/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security.maprsasl;

import com.mapr.fs.proto.Security;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import com.mapr.security.callback.MaprSaslCallbackHandler;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import oadd.org.apache.commons.codec.binary.Base64;
import oadd.org.apache.log4j.Logger;

public class MaprSaslServer
implements SaslServer {
    private static final Logger LOG = Logger.getLogger(MaprSaslServer.class);
    public static final String MAPR_SECURITY_MECH_NAME = "MAPR-SECURITY";
    private boolean completed = false;
    private boolean firstPassDone;
    private CallbackHandler cbh;
    private String authorizationId;
    private String authenticationId;
    private Security.Key sessionKeyNew;
    private String negotiatedQOPProperty;
    private String localqopProperty;

    public MaprSaslServer(CallbackHandler cbh, String protocol, Map<String, ?> props) throws SaslException {
        if (props == null || props.isEmpty()) {
            this.localqopProperty = QOP.AUTHENTICATION.getQopString();
        } else {
            for (Map.Entry<String, ?> entry : props.entrySet()) {
                Object valueO;
                String key = entry.getKey();
                if (!key.equals("javax.security.sasl.qop") || !((valueO = entry.getValue()) instanceof String)) continue;
                this.localqopProperty = (String)entry.getValue();
            }
        }
        this.cbh = cbh;
    }

    @Override
    public void dispose() throws SaslException {
        this.sessionKeyNew = null;
        this.authorizationId = null;
        this.authenticationId = null;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        if (!this.firstPassDone) {
            if (response == null || response.length < 1) {
                throw new SaslException("Received challenge is empty when secret expected");
            }
            MaprSaslCallbackHandler.MaprCallback mc = new MaprSaslCallbackHandler.MaprCallback();
            try {
                this.cbh.handle(new Callback[]{mc});
            }
            catch (IOException e) {
                throw new SaslException("MaprSaslClient IO Exception while handling callback");
            }
            catch (UnsupportedCallbackException e) {
                throw new SaslException("MaprSaslClient Error acquiring Subject");
            }
            try {
                byte[] base64decoded = Base64.decodeBase64(response);
                Security.AuthenticationReqFull reply = Security.AuthenticationReqFull.parseFrom(base64decoded);
                if (reply != null && reply.getEncryptedTicket() != null) {
                    byte[] encryptedTicket = reply.getEncryptedTicket().toByteArray();
                    MutableInt err = new MutableInt();
                    Security.Ticket decryptedTicket = Security.DecryptTicket(encryptedTicket, err);
                    if (err.GetValue() != 0 || decryptedTicket == null) {
                        throw new SaslException("Error while trying to decrypt ticket: " + err.GetValue());
                    }
                    Security.CredentialsMsg userCreds = decryptedTicket.getUserCreds();
                    Security.Key userKey = decryptedTicket.getUserKey();
                    this.authorizationId = userCreds.getUserName();
                    byte[] secretNumberBytes = reply.getEncryptedRandomSecret().toByteArray();
                    byte[] secretNumberBytesDecrypted = Security.Decrypt(userKey, secretNumberBytes, err);
                    if (secretNumberBytesDecrypted.length != 8) {
                        throw new SaslException("Bad random ticket");
                    }
                    long returnLong = ((long)secretNumberBytesDecrypted[0] << 56) + ((long)(secretNumberBytesDecrypted[1] & 0xFF) << 48) + ((long)(secretNumberBytesDecrypted[2] & 0xFF) << 40) + ((long)(secretNumberBytesDecrypted[3] & 0xFF) << 32) + ((long)(secretNumberBytesDecrypted[4] & 0xFF) << 24) + (long)((secretNumberBytesDecrypted[5] & 0xFF) << 16) + (long)((secretNumberBytesDecrypted[6] & 0xFF) << 8) + (long)((secretNumberBytesDecrypted[7] & 0xFF) << 0);
                    Security.AuthenticationResp.Builder authResp = Security.AuthenticationResp.newBuilder();
                    authResp.setChallengeResponse(returnLong);
                    if (!QOP.AUTHENTICATION.getQopString().equals(this.localqopProperty)) {
                        this.sessionKeyNew = Security.GenerateRandomKey();
                        authResp.setSessionKey(this.sessionKeyNew);
                    }
                    authResp.setStatus(0);
                    int qopIntOption = QOP.getIntFromQOPString(this.localqopProperty);
                    if (qopIntOption < 0) {
                        throw new SaslException("Invalid QOP option: " + this.localqopProperty);
                    }
                    authResp.setEncodingType(qopIntOption);
                    byte[] resp = authResp.build().toByteArray();
                    byte[] respEncrypted = Security.Encrypt(userKey, resp, err);
                    this.firstPassDone = true;
                    return Base64.encodeBase64(respEncrypted);
                }
                LOG.error((Object)"Malformed client response");
                throw new SaslException("Malformed client response");
            }
            catch (Throwable t) {
                throw new SaslException("Bad server key ", t);
            }
        }
        if (response.length != 0) {
            throw new SaslException("Unexpected evaluation requested");
        }
        this.completed = true;
        return null;
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizationId;
    }

    @Override
    public String getMechanismName() {
        return MAPR_SECURITY_MECH_NAME;
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (this.completed) {
            this.negotiatedQOPProperty = this.localqopProperty;
            if ("javax.security.sasl.qop".equals(propName)) {
                return this.negotiatedQOPProperty;
            }
            throw new IllegalStateException("MAPR-SECURITY does not support any property except javax.security.sasl.qop");
        }
        throw new IllegalStateException("MAPR-SECURITY authentication not completed");
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        byte[] keyBytes = new byte[len];
        System.arraycopy(incoming, offset, keyBytes, 0, len);
        MutableInt err = new MutableInt();
        byte[] decrypted = Security.Decrypt(this.sessionKeyNew, keyBytes, err);
        return decrypted;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        byte[] keyBytes = new byte[len];
        System.arraycopy(outgoing, offset, keyBytes, 0, len);
        MutableInt err = new MutableInt();
        byte[] encrypted = Security.Encrypt(this.sessionKeyNew, keyBytes, err);
        return encrypted;
    }

    public static class SaslMaprServerFactory
    implements SaslServerFactory {
        @Override
        public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) {
            if (MaprSaslServer.MAPR_SECURITY_MECH_NAME.equals(mechanism)) {
                try {
                    return new MaprSaslServer(cbh, protocol, props);
                }
                catch (SaslException e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return new String[]{MaprSaslServer.MAPR_SECURITY_MECH_NAME};
        }
    }

    static enum QOP {
        AUTHENTICATION("auth", 1),
        INTEGRITY("auth-int", 2),
        PRIVACY("auth-conf", 4);

        private final int optionInt;
        private final String qopString;

        private QOP(String qopString, int optionInt) {
            this.qopString = qopString;
            this.optionInt = optionInt;
        }

        public int getOptionInt() {
            return this.optionInt;
        }

        public String getQopString() {
            return this.qopString;
        }

        public static int getIntFromQOPString(String option) {
            for (QOP value : QOP.values()) {
                if (!value.getQopString().equals(option)) continue;
                return value.getOptionInt();
            }
            return -1;
        }

        public static String getStringFromQOPInt(int intOption) {
            for (QOP value : QOP.values()) {
                if (value.getOptionInt() != intOption) continue;
                return value.getQopString();
            }
            return null;
        }
    }
}

