/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.hadoop.yarn.security;

import com.mapr.hadoop.yarn.util.YarnAppUtil;
import com.mapr.security.JNISecurity;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

public class MapRTicketUploader {
    private static final Log LOG = LogFactory.getLog(MapRTicketUploader.class);

    public void uploadToken(ApplicationId appId, Configuration conf) {
        try {
            if (!UserGroupInformation.isSecurityEnabled() || UserGroupInformation.getCurrentUser().getRealUser() != null) {
                return;
            }
            this.upload(appId.toString(), conf);
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(String appIdStr, Configuration conf) throws IOException {
        String ticketPath = JNISecurity.GetUserTicketAndKeyFileLocation();
        if (ticketPath == null) {
            LOG.warn((Object)"Security is enabled, but userTicketFile is null. May cause failures later.");
            return;
        }
        File ticketFile = new File(ticketPath);
        if (!ticketFile.exists() || !ticketFile.isFile()) {
            LOG.warn((Object)"Security is enabled, but userTicketFile cannot be found. May cause failures later.");
            return;
        }
        FileSystem fs = FileSystem.get(conf);
        Path appStagingDir = YarnAppUtil.getRMStagingDir(appIdStr, fs, conf);
        Path outTicketFilePath = YarnAppUtil.getMapRTicketPath(appStagingDir);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Uploading MapR ticket for app: " + appIdStr + " at " + outTicketFilePath + " . Source ticket: " + ticketPath));
        }
        FileSystem.mkdirs(fs, appStagingDir, YarnAppUtil.APP_DIR_PERMISSION);
        FSDataOutputStream outTicket = FileSystem.create(fs, outTicketFilePath, new FsPermission(YarnAppUtil.APP_FILE_PERMISSION));
        FileInputStream fis = new FileInputStream(ticketFile);
        byte[] inBytes = new byte[1024];
        try {
            int ticketLen;
            while ((ticketLen = fis.read(inBytes)) != -1) {
                outTicket.write(inBytes, 0, ticketLen);
            }
        }
        finally {
            fis.close();
            outTicket.close();
        }
    }
}

