/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.jni;

import java.io.IOException;
import java.nio.ByteBuffer;

public class RowColParser {
    private ByteBuffer byteBuf;
    private int endOffset;
    STATE state;
    int fieldOffset;
    int fieldLen;
    boolean isLast;
    int dataOffset;
    int dataLen;
    long version;
    ValType valType;

    public void Init(ByteBuffer byteBuf, int endOffset) {
        this.byteBuf = byteBuf;
        this.endOffset = endOffset;
        this.state = STATE.kInit;
    }

    public void RowColParserNext() throws IOException {
        switch (this.state) {
            case kInit: {
                this.ParseValue();
                return;
            }
            case kFoundBaseTS: {
                this.ParseValue();
                return;
            }
            case kFoundField: {
                this.ParseValue();
                return;
            }
            case kFoundValue: {
                if (!this.isLast) {
                    this.ParseValue();
                    return;
                }
                if (this.byteBuf.position() < this.endOffset) {
                    this.ParseField();
                    return;
                }
                this.state = STATE.kFinished;
                return;
            }
            case kFinished: {
                throw new IOException("Parser is incorrectly used");
            }
        }
        throw new IOException("Parser is incorrectly used");
    }

    public int getFieldOffset() {
        return this.fieldOffset;
    }

    public int getFieldLen() {
        return this.fieldLen;
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public int getDataLen() {
        return this.dataLen;
    }

    public long getVersion() {
        return this.version;
    }

    public boolean getIsLast() {
        return this.isLast;
    }

    public STATE getState() {
        return this.state;
    }

    public ValType getValType() {
        return this.valType;
    }

    private void ParseField() {
        this.fieldLen = this.byteBuf.getShort() & 0xFFFF;
        this.fieldOffset = this.byteBuf.position();
        this.state = STATE.kFoundField;
        this.byteBuf.position(this.byteBuf.position() + this.fieldLen);
    }

    private void ParseValue() throws IOException {
        byte type = this.byteBuf.get();
        this.isLast = false;
        if ((type & ValType.kRowColLastValueFlag.getValue()) != 0) {
            this.isLast = true;
        }
        type = (byte)(type & ~ValType.kRowColLastValueFlag.getValue());
        this.valType = ValType.valtypeFromByte(type);
        if (this.valType != ValType.kRowColMap && this.valType != ValType.kRowColBaseTS) {
            this.version = this.byteBuf.getLong();
        }
        this.dataOffset = this.byteBuf.position();
        switch (this.valType) {
            case kRowColBaseTS: {
                long baseTS = this.byteBuf.getLong();
                if (baseTS <= 0L) {
                    throw new IOException("Invalid baseTS");
                }
                this.dataLen = 0;
                break;
            }
            case kRowColMap: {
                this.dataLen = 0;
                break;
            }
            case kRowColDeleteAll: 
            case kRowColDeleteExact: {
                this.dataLen = 0;
                break;
            }
            case kRowColBinary8: {
                int len = this.byteBuf.get() & 0xFF;
                this.byteBuf.position(this.byteBuf.position() + len);
                this.dataLen = this.byteBuf.position() - this.dataOffset;
                break;
            }
            case kRowColBinary16: {
                int len = this.byteBuf.getShort() & 0xFFFF;
                this.byteBuf.position(this.byteBuf.position() + len);
                this.dataLen = this.byteBuf.position() - this.dataOffset;
                break;
            }
            case kRowColBinary32: {
                int len = this.byteBuf.getInt();
                this.byteBuf.position(this.byteBuf.position() + len);
                this.dataLen = this.byteBuf.position() - this.dataOffset;
                break;
            }
            default: {
                throw new IOException("Invalid valtype still " + (Object)((Object)this.valType));
            }
        }
        this.state = this.valType == ValType.kRowColBaseTS ? STATE.kFoundBaseTS : STATE.kFoundValue;
    }

    static enum ValType {
        kRowColDeleteAll(1),
        kRowColMap(4),
        kRowColBinary8(16),
        kRowColBinary16(17),
        kRowColBinary32(18),
        kRowColDeleteExact(20),
        kRowColBaseTS(22),
        kRowColLastValueFlag(-128);

        private final byte val;

        private ValType(byte inVal) {
            this.val = inVal;
        }

        public byte getValue() {
            return this.val;
        }

        static ValType valtypeFromByte(byte val) throws IOException {
            switch (val) {
                case 1: {
                    return kRowColDeleteAll;
                }
                case 4: {
                    return kRowColMap;
                }
                case 16: {
                    return kRowColBinary8;
                }
                case 17: {
                    return kRowColBinary16;
                }
                case 18: {
                    return kRowColBinary32;
                }
                case 20: {
                    return kRowColDeleteExact;
                }
                case 22: {
                    return kRowColBaseTS;
                }
                case -128: {
                    return kRowColLastValueFlag;
                }
            }
            throw new IOException("Invalid valtype " + val);
        }
    }

    static enum STATE {
        kInit,
        kFoundBaseTS,
        kFoundField,
        kFoundValue,
        kFinished;

    }
}

