/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.jni;

import com.mapr.fs.jni.RowColDecoderCallback;
import com.mapr.fs.jni.RowColParser;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class RowColDecoder {
    private RowColDecoderCallback cbs;

    RowColDecoder(RowColDecoderCallback cbs) {
        this.cbs = cbs;
    }

    public void Decode(ByteBuffer buf, int startOffset, int endOffset) throws IOException {
        if (buf == null || buf.limit() == 0 || buf.limit() <= startOffset || buf.limit() < endOffset) {
            throw new IOException("Invalid rowcol buffer");
        }
        RowColParser parser = new RowColParser();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.position(startOffset);
        parser.Init(buf, endOffset);
        while (true) {
            parser.RowColParserNext();
            block0 : switch (parser.getState()) {
                case kInit: {
                    throw new IOException("Invalid Parser State");
                }
                case kFoundBaseTS: {
                    break;
                }
                case kFoundField: {
                    this.cbs.foundField(parser.getFieldOffset(), parser.getFieldLen());
                    break;
                }
                case kFoundValue: {
                    switch (parser.getValType()) {
                        case kRowColDeleteAll: {
                            this.cbs.foundValue(0, 0, parser.getVersion(), parser.getIsLast(), 1, 0);
                            break block0;
                        }
                        case kRowColDeleteExact: {
                            this.cbs.foundValue(0, 0, parser.getVersion(), parser.getIsLast(), 0, 1);
                            break block0;
                        }
                        case kRowColMap: {
                            break block0;
                        }
                        case kRowColBaseTS: {
                            break block0;
                        }
                        case kRowColBinary8: {
                            this.cbs.foundValue(parser.getDataOffset() + 1, parser.getDataLen() - 1, parser.getVersion(), parser.getIsLast(), 0, 0);
                            break block0;
                        }
                        case kRowColBinary16: {
                            this.cbs.foundValue(parser.getDataOffset() + 2, parser.getDataLen() - 2, parser.getVersion(), parser.getIsLast(), 0, 0);
                            break block0;
                        }
                        case kRowColBinary32: {
                            this.cbs.foundValue(parser.getDataOffset() + 4, parser.getDataLen() - 4, parser.getVersion(), parser.getIsLast(), 0, 0);
                            break block0;
                        }
                        default: {
                            throw new IOException("Unrecognised data type");
                        }
                    }
                }
                case kFinished: {
                    return;
                }
            }
        }
    }
}

