/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.jni;

public class ParsedRow {
    public int[] coff;
    public int[] clen;
    public int[] nval;
    public int[] valoff;
    public int[] vallen;
    public long[] ts;
    public int[] isDelete;
    public int[] isDeleteExact;
    public int curNVal;
    public int curCoff;
    public int curClen;
    public boolean parseColumnCalled;
    private int MinArraySize;
    private int ncols;
    private int nvals;
    private int colIdx;
    private int valIdx;

    public ParsedRow() {
        this.ncols = this.MinArraySize = 8;
        this.coff = new int[this.ncols];
        this.clen = new int[this.ncols];
        this.nval = new int[this.ncols];
        this.nvals = this.MinArraySize;
        this.valoff = new int[this.nvals];
        this.vallen = new int[this.nvals];
        this.ts = new long[this.nvals];
        this.isDelete = new int[this.nvals];
        this.isDeleteExact = new int[this.nvals];
        this.colIdx = 0;
        this.valIdx = 0;
        this.parseColumnCalled = false;
    }

    void Clear() {
        this.parseColumnCalled = false;
        this.colIdx = 0;
        this.valIdx = 0;
    }

    public void addColumn(int off, int len, int numValues) {
        if (this.colIdx == this.ncols) {
            int tmpNcols = this.ncols + this.MinArraySize;
            int[] tmpCoff = new int[tmpNcols];
            int[] tmpClen = new int[tmpNcols];
            int[] tmpNval = new int[tmpNcols];
            System.arraycopy(this.coff, 0, tmpCoff, 0, this.ncols);
            System.arraycopy(this.clen, 0, tmpClen, 0, this.ncols);
            System.arraycopy(this.nval, 0, tmpNval, 0, this.ncols);
            this.ncols = tmpNcols;
            this.coff = tmpCoff;
            this.clen = tmpClen;
            this.nval = tmpNval;
        }
        this.coff[this.colIdx] = off;
        this.clen[this.colIdx] = len;
        this.nval[this.colIdx] = numValues;
        ++this.colIdx;
    }

    public void addValue(int off, int len, long version, int isdel, int isdelexact) {
        if (this.valIdx == this.nvals) {
            int tmpNvals = this.nvals + this.MinArraySize;
            int[] tmpValoff = new int[tmpNvals];
            int[] tmpVallen = new int[tmpNvals];
            long[] tmpTs = new long[tmpNvals];
            int[] tmpIsDelete = new int[tmpNvals];
            int[] tmpIsDeleteExact = new int[tmpNvals];
            System.arraycopy(this.valoff, 0, tmpValoff, 0, this.nvals);
            System.arraycopy(this.vallen, 0, tmpVallen, 0, this.nvals);
            System.arraycopy(this.ts, 0, tmpTs, 0, this.nvals);
            System.arraycopy(this.isDelete, 0, tmpIsDelete, 0, this.nvals);
            System.arraycopy(this.isDeleteExact, 0, tmpIsDeleteExact, 0, this.nvals);
            this.nvals = tmpNvals;
            this.valoff = tmpValoff;
            this.vallen = tmpVallen;
            this.ts = tmpTs;
            this.isDelete = tmpIsDelete;
            this.isDeleteExact = tmpIsDeleteExact;
        }
        this.valoff[this.valIdx] = off;
        this.vallen[this.valIdx] = len;
        this.ts[this.valIdx] = version;
        this.isDelete[this.valIdx] = isdel;
        this.isDeleteExact[this.valIdx] = isdelexact;
        ++this.valIdx;
    }

    public int getNumColumns() {
        return this.colIdx;
    }

    public int getNumValues() {
        return this.valIdx;
    }
}

