/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.jni;

import com.mapr.fs.jni.InodeAttributes;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class Page {
    public static final boolean ALLOC_IN_SHM = true;
    public boolean inlru;
    public long pageId;
    public InodeAttributes iattr;
    CacheState state;
    public boolean dirty;
    public boolean isCompressed;
    public boolean inShm;
    public boolean allocatedForRA;
    public int validStart;
    public int validLen;
    public int ref;
    public ByteBuffer bbuf;
    public Condition cv;
    public Page prev;
    public Page next;
    public Page hnext;

    private native int decompress();

    private native int compress();

    private native int releaseMemory(ByteBuffer var1, boolean var2, boolean var3);

    private native boolean allocateByteBuf(int var1, boolean var2, boolean var3);

    public void setValid() {
        this.state = CacheState.Valid;
    }

    public boolean valid() {
        return this.state == CacheState.Valid;
    }

    public boolean filling() {
        return this.state == CacheState.Filling;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public boolean invalid() {
        return this.state == CacheState.Invalid;
    }

    public boolean eq(Page p) {
        return this.iattr.eq(p.iattr) && this.pageId == p.pageId;
    }

    public boolean eq(InodeAttributes a, long pId) {
        return this.iattr.eq(a) && this.pageId == pId;
    }

    public String toString() {
        return "(" + this.pageId + ", state " + (Object)((Object)this.state) + ")";
    }

    public void invalidate() {
        this.state = CacheState.Invalid;
        this.pageId = 0L;
        this.validLen = 0;
        this.validStart = 0;
        this.isCompressed = false;
    }

    public void setFilling() {
        this.state = CacheState.Filling;
    }

    public void releaseStorage() {
        this.releaseMemory(this.bbuf, this.inShm, this.allocatedForRA);
        this.bbuf = null;
    }

    public Page(Lock lock, boolean inShm, int pageSize, boolean allocateForRA) {
        this.inShm = inShm;
        this.allocatedForRA = allocateForRA;
        this.pageId = 0L;
        this.validStart = 0;
        this.validLen = pageSize;
        this.ref = 0;
        this.iattr = null;
        this.isCompressed = false;
        this.dirty = false;
        this.state = CacheState.Invalid;
        inShm = this.allocateByteBuf(pageSize, inShm, allocateForRA);
        if (lock != null) {
            this.cv = lock.newCondition();
        }
        this.inlru = false;
    }

    private static enum CacheState {
        Invalid,
        Valid,
        Filling;

    }
}

