/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.jni;

import com.mapr.fs.jni.ParsedRow;
import com.mapr.fs.jni.RowColDecoder;
import com.mapr.fs.jni.RowColDecoderCallback;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MapRResult {
    private ByteBuffer bbuf = null;
    public byte[] bufBytes = null;
    public int bufSize = 0;
    public int keyLength = 0;
    public boolean isDelete = false;
    public int[] familyOffsets;
    public int[] columnOffsets = null;
    public int[] columnLengths = null;
    public long[] timestamps = null;
    public int[] valueOffsets = null;
    public int[] valueLengths = null;
    public int[] isColDelete = null;
    public int[] isColDeleteExact = null;
    public int[] cfIds = null;
    public int[] cellsPerFamily = null;
    public int[] versions = null;

    public void DecodeByteBuf(ParsedRow prow) throws IOException {
        if (this.isEmpty() || this.isDelete) {
            return;
        }
        this.bbuf = ByteBuffer.wrap(this.bufBytes);
        prow.Clear();
        MapRResultDecoderCallback cbs = new MapRResultDecoderCallback(prow);
        RowColDecoder dec = new RowColDecoder(cbs);
        int nfamilies = this.cfIds.length;
        if (nfamilies == 0) {
            throw new IOException("Number of familes for non-empty Result is 0");
        }
        this.cellsPerFamily = new int[nfamilies];
        int lastNumCols = 0;
        for (int f = 0; f < nfamilies; ++f) {
            prow.parseColumnCalled = false;
            if (f != nfamilies - 1) {
                dec.Decode(this.bbuf, this.familyOffsets[f], this.familyOffsets[f + 1]);
            } else {
                dec.Decode(this.bbuf, this.familyOffsets[f], this.bbuf.limit());
            }
            this.cellsPerFamily[f] = prow.getNumColumns() - lastNumCols;
            lastNumCols = prow.getNumColumns();
        }
        int numCols = prow.getNumColumns();
        int numVals = prow.getNumValues();
        this.columnOffsets = new int[numCols];
        this.columnLengths = new int[numCols];
        this.versions = new int[numCols];
        System.arraycopy(prow.coff, 0, this.columnOffsets, 0, numCols);
        System.arraycopy(prow.clen, 0, this.columnLengths, 0, numCols);
        System.arraycopy(prow.nval, 0, this.versions, 0, numCols);
        this.valueOffsets = new int[numVals];
        this.valueLengths = new int[numVals];
        this.timestamps = new long[numVals];
        this.isColDelete = new int[numVals];
        this.isColDeleteExact = new int[numVals];
        System.arraycopy(prow.valoff, 0, this.valueOffsets, 0, numVals);
        System.arraycopy(prow.vallen, 0, this.valueLengths, 0, numVals);
        System.arraycopy(prow.ts, 0, this.timestamps, 0, numVals);
        System.arraycopy(prow.isDelete, 0, this.isColDelete, 0, numVals);
        System.arraycopy(prow.isDeleteExact, 0, this.isColDeleteExact, 0, numVals);
    }

    public int getBufSize() {
        return this.bufSize;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public boolean getIsDelete() {
        return this.isDelete;
    }

    public int[] getColumnOffsets() {
        return this.columnOffsets;
    }

    public int[] getColumnLengths() {
        return this.columnLengths;
    }

    public int[] getValueOffsets() {
        return this.valueOffsets;
    }

    public int[] getValueLengths() {
        return this.valueLengths;
    }

    public int[] getIsColDelete() {
        return this.isColDelete;
    }

    public int[] getIsColDeleteExact() {
        return this.isColDeleteExact;
    }

    public long[] getTimeStamps() {
        return this.timestamps;
    }

    public int[] getCfids() {
        return this.cfIds;
    }

    public int[] getCellsPerFamily() {
        return this.cellsPerFamily;
    }

    public int[] versions() {
        return this.versions;
    }

    public boolean isEmpty() {
        return this.bufSize == 0;
    }

    private class MapRResultDecoderCallback
    implements RowColDecoderCallback {
        private ParsedRow prow;

        public MapRResultDecoderCallback(ParsedRow prow) {
            this.prow = prow;
        }

        @Override
        public void foundField(int fieldOffset, int fieldLen) {
            this.prow.curCoff = fieldOffset;
            this.prow.curClen = fieldLen;
            this.prow.curNVal = 0;
            this.prow.parseColumnCalled = true;
        }

        @Override
        public void foundValue(int valueOffset, int valueLength, long version, boolean isLast, int isDelete, int isDeleteExact) {
            this.prow.addValue(valueOffset, valueLength, version, isDelete, isDeleteExact);
            ++this.prow.curNVal;
            if (isLast) {
                if (this.prow.parseColumnCalled) {
                    this.prow.addColumn(this.prow.curCoff, this.prow.curClen, this.prow.curNVal);
                } else {
                    this.prow.addColumn(0, 0, this.prow.curNVal);
                }
            }
        }
    }
}

