/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.jni;

import com.mapr.fs.jni.Errno;
import com.mapr.fs.jni.MapRAsyncRpc;
import com.mapr.fs.jni.MapRCallBackQueue;
import com.mapr.fs.jni.MapRKeyValue;
import java.util.Arrays;
import java.util.LinkedList;

public class MapRPut
extends MapRAsyncRpc {
    private static final int SIZEOF_LONG = 8;
    public byte[] key;
    public int[] families;
    public int[] cellsPerFamily;
    public MapRKeyValue[] keyvals;
    public long rowTotalBytes;
    public int numFamilies;
    public int numCells;
    public byte type;
    public int status;
    public long rowTimeStamp;
    public byte[] tableUuid;
    public MapRPut next;

    public MapRPut() {
    }

    public MapRKeyValue[] getKeyValues() {
        return this.keyvals;
    }

    private void MapRPutCommon(byte[] key, int[] reqFamilies, byte[][][] qualifiers, byte[][][] values, long timestamp, long[][] timestamps, byte type) {
        int i;
        this.key = key;
        this.type = type;
        this.numCells = 0;
        this.numFamilies = reqFamilies == null ? 0 : reqFamilies.length;
        this.families = new int[this.numFamilies];
        for (i = 0; i < this.numFamilies; ++i) {
            this.families[i] = reqFamilies[i];
        }
        this.cellsPerFamily = new int[this.numFamilies];
        if (qualifiers == null) {
            for (i = 0; i < this.numFamilies; ++i) {
                this.cellsPerFamily[i] = 0;
            }
        } else {
            for (i = 0; i < this.numFamilies; ++i) {
                this.cellsPerFamily[i] = qualifiers[i].length;
                this.numCells += this.cellsPerFamily[i];
            }
        }
        this.rowTotalBytes = key.length;
        this.rowTimeStamp = timestamp;
        if (this.numCells > 0) {
            this.keyvals = new MapRKeyValue[this.numCells];
            i = 0;
            for (int j = 0; j < this.numFamilies; ++j) {
                for (int k = 0; k < this.cellsPerFamily[j]; ++k) {
                    boolean firstCell = false;
                    boolean lastCell = false;
                    if (k == 0 || !Arrays.equals(qualifiers[j][k - 1], qualifiers[j][k])) {
                        firstCell = true;
                    }
                    if (k == this.cellsPerFamily[j] - 1 || !Arrays.equals(qualifiers[j][k], qualifiers[j][k + 1])) {
                        lastCell = true;
                    }
                    long kvTimestamp = timestamps == null ? timestamp : timestamps[j][k];
                    byte[] value = null;
                    if ((type & 0x10) == 0) {
                        value = values[j][k];
                    }
                    this.keyvals[i] = new MapRKeyValue(qualifiers[j][k], value, kvTimestamp, firstCell, lastCell);
                    ++i;
                    int valLength = value == null ? 0 : values[j][k].length;
                    this.rowTotalBytes += (long)(qualifiers[j][k].length + valLength + 8);
                }
            }
        }
    }

    public MapRPut(byte[] key, int family, byte[][] qualifiers, byte[][] values, long timestamp) {
        this.MapRPutCommon(key, new int[]{family}, new byte[][][]{qualifiers}, new byte[][][]{values}, timestamp, null, (byte)1);
    }

    public MapRPut(byte[] key, int family, byte[][] qualifiers, byte[][] values, long timestamp, Object request, MapRCallBackQueue cbq) {
        this.request = request;
        this.cbq = cbq;
        this.MapRPutCommon(key, new int[]{family}, new byte[][][]{qualifiers}, new byte[][][]{values}, timestamp, null, (byte)1);
    }

    public MapRPut(byte[] key, int family, byte[][] qualifiers, byte[][] values, long timestamp, byte type) {
        this.MapRPutCommon(key, new int[]{family}, new byte[][][]{qualifiers}, new byte[][][]{values}, timestamp, null, type);
    }

    public MapRPut(byte[] key, int[] families, byte[][][] qualifiers, byte[][][] values, long timestamp, long[][] timestamps, byte type) {
        this.MapRPutCommon(key, families, qualifiers, values, timestamp, timestamps, type);
    }

    public MapRPut(byte[] key, int[] families, byte[][][] qualifiers, byte[][][] values, long timestamp, long[][] timestamps, Object request, MapRCallBackQueue cbq) {
        this.request = request;
        this.cbq = cbq;
        this.MapRPutCommon(key, families, qualifiers, values, timestamp, timestamps, (byte)1);
    }

    public long rowTotalBytes() {
        return this.rowTotalBytes;
    }

    public void done() {
        LinkedList<Object> requests = new LinkedList<Object>();
        LinkedList<Object> responses = new LinkedList<Object>();
        Object error = "MultiActionSuccess";
        if (this.status != 0) {
            error = new Exception("Error in inserting row: " + Errno.toString(this.status) + "(" + this.status + ")");
        }
        MapRPut req = this;
        while (req != null) {
            if (req.getAsyncRequest() != null) {
                requests.add(req.getAsyncRequest());
                responses.add(error);
            }
            MapRPut t = req.next;
            req.next = null;
            req = t;
        }
        this.callback(requests, responses);
    }
}

