/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.clicommands;

import com.mapr.baseutils.Errno;
import com.mapr.fs.MapRBlockLocation;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.jni.JNIFileStatus;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Security;
import com.mapr.security.UnixUserGroupHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class MapRCliCommands
extends Configured
implements Tool {
    private static final int MAX_SYMLINK_HEIGHT = 8;
    private static final int MAX_BLOCKS_IN_ONE_GO = 100;
    private static final Log LOG = LogFactory.getLog(MapRCliCommands.class);
    private int symlinkHeight;
    public static int RecursiveBit = 1;
    public static int DirOnlyBit = 2;
    public static int DiskBlockOnlyBit = 4;
    public static int DereferenceSymlinkBit = 8;
    public static int SingleVolumeBit = 16;
    public static int FidBit = 32;
    protected static MapRFileSystem fs;
    private Configuration conf;
    private static UnixUserGroupHelper ui;
    public static final SimpleDateFormat dateForm;
    protected static final SimpleDateFormat modifFmt;
    private static final Comparator<MapRFileStatus> fileStatusComparator;

    public MapRCliCommands(Configuration conf) {
        super(conf);
        fs = null;
        this.conf = conf;
    }

    public MapRCliCommands() {
        this(null);
    }

    protected void init() throws IOException {
        if (this.conf == null) {
            this.conf = this.getConf();
        }
        this.conf.setQuietMode(true);
    }

    private boolean isMapRFsPath(Path p) throws IOException {
        FileSystem f = p.getFileSystem(this.conf);
        if (f.getUri().getScheme().toString().equals("maprfs")) {
            fs = (MapRFileSystem)f;
            return true;
        }
        return false;
    }

    private int ls(String cmd, String srcf, int lsFlag) throws Exception {
        int numOfErrors;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(cmd + " srcf=" + srcf + " flag=" + lsFlag));
        }
        FileStatus[] srcs = null;
        if ((lsFlag & FidBit) != 0) {
            this.isMapRFsPath(new Path("maprfs:///dummy"));
            String mntPath = fs.getMountPathFid(srcf);
            if (mntPath == null) {
                throw new FileNotFoundException(srcf + ": No path for fid");
            }
            srcs = new FileStatus[]{fs.getFileStatus(new Path(mntPath))};
        } else {
            Path srcPath = new Path(srcf);
            if (!this.isMapRFsPath(srcPath)) {
                throw new FileNotFoundException("Not a MapRFs uri " + srcf);
            }
            srcs = fs.globStatus(srcPath);
        }
        if (srcs == null) {
            throw new FileNotFoundException("Cannot access " + srcf + ": No such file or directory.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("globStatus: " + srcs.length));
        }
        return (numOfErrors = this.ls(cmd, srcs, lsFlag)) == 0 ? 0 : -1;
    }

    private int ls(String cmd, FileStatus[] src, int lsFlag) throws Exception {
        MapRFileStatus stat;
        int i;
        boolean dironly = (lsFlag & DirOnlyBit) != 0;
        boolean recursive = (lsFlag & RecursiveBit) != 0;
        boolean followlinks = (lsFlag & DereferenceSymlinkBit) != 0;
        boolean singleVolume = (lsFlag & SingleVolumeBit) != 0;
        ShellListResult res = MapRCliCommands.shellListStatus(cmd, src, dironly, recursive);
        MapRFileStatus[] items = res.lsResult;
        int numOfErrors = res.lsErrors;
        if (!recursive && items.length != 0) {
            System.out.println("Found " + items.length + " items");
        }
        int maxReplication = 3;
        int maxLen = 10;
        int maxBlockLen = 10;
        int maxOwner = 0;
        int maxGroup = 0;
        boolean getBlockError = false;
        for (i = 0; i < items.length; ++i) {
            stat = items[i];
            int replication = String.valueOf(stat.getReplication()).length();
            int len = String.valueOf(stat.getLen()).length();
            int blockLen = String.valueOf(stat.getBlockSize()).length();
            int owner = String.valueOf(stat.getOwner()).length();
            int group = String.valueOf(stat.getGroup()).length();
            if (replication > maxReplication) {
                maxReplication = replication;
            }
            if (len > maxLen) {
                maxLen = len;
            }
            if (blockLen > maxBlockLen) {
                maxBlockLen = blockLen;
            }
            if (owner > maxOwner) {
                maxOwner = owner;
            }
            if (group <= maxGroup) continue;
            maxGroup = group;
        }
        for (i = 0; i < items.length; ++i) {
            boolean skipVolumeLs;
            String fileType;
            int vCid = 0;
            int vCinum = 0;
            int vUniq = 0;
            int volLinkAttrType = 0;
            String volName = null;
            long totalDiskBlocks = 0L;
            MapRBlockLocation[] blocks = null;
            stat = items[i];
            boolean isVolumeDir = stat.isVol();
            if (isVolumeDir) {
                fileType = "v";
                JNIFileStatus.VolumeInfo volInfo = stat.getVolumeInfo();
                vCid = volInfo.getCid();
                vCinum = volInfo.getCinum();
                vUniq = volInfo.getUniq();
                volName = volInfo.getName();
                volLinkAttrType = volInfo.getVolLinkAttrType();
            } else {
                fileType = stat.isDir() ? "d" : (stat.isSymlink() ? "l" : (stat.isTable() ? "t" : "-"));
            }
            Path cur = stat.getPath();
            String mdate = dateForm.format(new Date(stat.getModificationTime()));
            if (followlinks && stat.isSymlink()) {
                if (this.symlinkHeight < 8) {
                    Path symlinkPath = stat.getSymlink();
                    String symlinkStr = symlinkPath.isAbsolute() ? symlinkPath.toString() : new Path(cur.getParent(), symlinkPath).toString();
                    ++this.symlinkHeight;
                    numOfErrors += this.ls(cmd, symlinkStr, lsFlag);
                    --this.symlinkHeight;
                    continue;
                }
                System.out.println("Cannot access " + cur + ": Too many levels of symbolic links");
                continue;
            }
            System.out.print(fileType);
            System.out.print(stat.getPermission());
            System.out.print(stat.getCompressString());
            System.out.print(stat.getWireSecurity());
            System.out.print(" ");
            System.out.printf("%" + maxReplication + "s ", !stat.isDir() ? Short.valueOf(stat.getReplication()) : "-");
            if (maxOwner > 0) {
                System.out.printf("%-" + maxOwner + "s ", stat.getOwner());
            }
            if (maxGroup > 0) {
                System.out.printf("%-" + maxGroup + "s ", stat.getGroup());
            }
            System.out.printf("%" + maxLen + "d ", stat.getLen());
            System.out.print(mdate + " ");
            System.out.printf("%" + maxBlockLen + "d ", stat.getBlockSize());
            if (stat.isSymlink()) {
                System.out.println(cur.toUri().getPath() + " -> " + stat.getSymlink().toString());
            } else {
                System.out.println(cur.toUri().getPath());
            }
            long blockIndex = 0L;
            long startOffset = 0L;
            long fileLengthInOneGo = stat.getBlockSize() > 0L ? stat.getBlockSize() * 100L : stat.getLen();
            do {
                try {
                    blocks = null;
                    blocks = fs.getMapRFileBlockLocations(stat, startOffset, fileLengthInOneGo, true, true);
                    if (blocks != null && (lsFlag & DiskBlockOnlyBit) != 0) {
                        for (MapRBlockLocation b : blocks) {
                            totalDiskBlocks += b.getNumDiskBlocks();
                        }
                    }
                    this.fidmap(blocks, maxLen, volName, volLinkAttrType, vCid, vCinum, vUniq, (lsFlag & DiskBlockOnlyBit) != 0, blockIndex);
                }
                catch (Exception e) {
                    System.out.println("\nException while fetching blocklocations for " + cur.toUri().getPath() + ", error: " + e.getMessage());
                    ++numOfErrors;
                    getBlockError = true;
                    break;
                }
                if (!stat.isRegular() || blocks == null) break;
                MapRBlockLocation finalBlock = blocks[blocks.length - 1];
                long endOffset = finalBlock.getOffset() + finalBlock.getLength() - 1L;
                startOffset = endOffset + 1L;
                blockIndex += (long)blocks.length;
            } while (startOffset < stat.getLen());
            if (getBlockError) {
                getBlockError = false;
                continue;
            }
            if ((lsFlag & DiskBlockOnlyBit) != 0) {
                System.out.println("\t       Total Disk Blocks : " + totalDiskBlocks);
            }
            boolean bl = skipVolumeLs = isVolumeDir && singleVolume;
            if (recursive && stat.isDir() && !skipVolumeLs) {
                numOfErrors += this.ls(cmd, new MapRFileStatus[]{stat}, lsFlag);
                continue;
            }
            if (!stat.isTable()) continue;
            try {
                this.printTablets(cur);
                continue;
            }
            catch (Exception e) {
                System.out.println("\nCannot display tablets for " + cur + ", Error: " + e.getMessage());
                ++numOfErrors;
            }
        }
        return numOfErrors;
    }

    private static ShellListResult shellListStatus(String cmd, FileStatus[] statusArray, boolean dironly, boolean recursive) {
        int lsErrors = 0;
        LinkedList<MapRFileStatus> result = new LinkedList<MapRFileStatus>();
        for (FileStatus src : statusArray) {
            Path path = src.getPath();
            if (!src.isDir() || dironly) {
                result.add((MapRFileStatus)src);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Adding path to result: dir=" + src.isDir() + " " + path));
                continue;
            }
            try {
                MapRFileStatus[] files = fs.listMapRStatus(path, true, !recursive);
                if (files == null) {
                    ++lsErrors;
                    System.err.println(cmd + ": could not get listing for '" + path + "'");
                    continue;
                }
                for (MapRFileStatus f : files) {
                    result.add(f);
                }
            }
            catch (IOException e) {
                ++lsErrors;
                System.err.println(cmd + ": could not get listing for '" + path + "' : " + e.getMessage().split("\n")[0]);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ShellListResult: statuses=" + result.size() + " errors=" + lsErrors));
        }
        MapRFileStatus[] resultArray = new MapRFileStatus[result.size()];
        result.toArray(resultArray);
        Arrays.sort(resultArray, fileStatusComparator);
        return new ShellListResult(resultArray, lsErrors);
    }

    private void fidmap(MapRBlockLocation[] blocks, int maxLen, String volName, int volLinkAttrType, int vCid, int vCinum, int vUniq, boolean needNumDiskBlocks, long startBlock) throws IOException {
        if (blocks == null || blocks.length == 0) {
            return;
        }
        String volLinkAttrName = null;
        if (volName != null) {
            volLinkAttrName = volLinkAttrType == 1 ? "writeable" : (volLinkAttrType == 2 ? "mirror" : "default");
        }
        int i = 0;
        while (i < blocks.length) {
            String master;
            System.out.print("\t       " + (startBlock == 0L ? "p" : Long.valueOf(startBlock - 1L)) + " ");
            if (volName != null) {
                System.out.print(volName + " " + volLinkAttrName + " " + vCid + "." + vCinum + "." + vUniq + " -> ");
            }
            System.out.print(blocks[i].getCid() + "." + blocks[i].getCinum() + "." + blocks[i].getUniq() + "  ");
            if (volName == null && needNumDiskBlocks) {
                System.out.printf("%" + 2 * (maxLen - 1) + "d ", blocks[i].getNumDiskBlocks());
            }
            if ((master = blocks[i].getMaster()) != null && !master.isEmpty()) {
                System.out.print(master + " ");
                for (String host : blocks[i].getNames()) {
                    if (host.equalsIgnoreCase(master)) continue;
                    System.out.print(host + " ");
                }
            }
            System.out.println("");
            ++i;
            ++startBlock;
        }
    }

    private void printTablets(Path path) throws Exception {
        List<Dbserver.TabletDesc> nextSet;
        MapRTabletScanner scanner = fs.getTabletScanner(path);
        while ((nextSet = scanner.nextSet()) != null) {
            ArrayList<Integer> cidList = new ArrayList<Integer>();
            for (Dbserver.TabletDesc tablet : nextSet) {
                cidList.add(tablet.getFid().getCid());
            }
            List<CLDBProto.ContainerInfo> containers = this.getContainersForCids(path, cidList);
            if (containers == null || containers.size() != nextSet.size()) {
                throw new IOException("Container lookup response has no containers in it ");
            }
            int i = 0;
            for (Dbserver.TabletDesc tablet : nextSet) {
                System.out.print("\t       r " + tablet.getFid().getCid() + "." + tablet.getFid().getCinum() + "." + tablet.getFid().getUniq() + "  ");
                CLDBProto.ContainerInfo cInfo = containers.get(i);
                String primaryNode = cInfo.getMServer().getIpsList().get(0).getHostname() + ":" + cInfo.getMServer().getIpsList().get(0).getPort();
                System.out.println(primaryNode + " " + this.getSecondaryNodes(cInfo));
                ++i;
            }
        }
    }

    private List<CLDBProto.ContainerInfo> getContainersForCids(Path path, List<Integer> cidList) throws Exception {
        ArrayList<CLDBProto.ContainerInfo> containers = new ArrayList<CLDBProto.ContainerInfo>();
        int from = 0;
        int to = 50;
        while (to < cidList.size()) {
            containers.addAll(this.fetchContainersFromCLDB(path, cidList.subList(from, to)));
            from = to;
            to = from + 50;
        }
        if (from < cidList.size()) {
            containers.addAll(this.fetchContainersFromCLDB(path, cidList.subList(from, cidList.size())));
        }
        return containers;
    }

    private List<CLDBProto.ContainerInfo> fetchContainersFromCLDB(Path path, List<Integer> cidList) throws Exception {
        byte[] replyData = fs.getContainerInfo(path, cidList);
        if (replyData == null) {
            throw new IOException("Failed to connect to CLDB");
        }
        CLDBProto.ContainerLookupResponse resp = CLDBProto.ContainerLookupResponse.parseFrom(replyData);
        if (resp.getStatus() != 0) {
            throw new IOException("Container lookup failed. Error: " + Errno.toString(resp.getStatus()));
        }
        return resp.getContainersList();
    }

    private Security.CredentialsMsg getUserCredentials() {
        String user = ui.getLoggedinUsername();
        return this.getUserCredentials(user);
    }

    private Security.CredentialsMsg getUserCredentials(String user) {
        int uid = ui.getUserId(user);
        int[] gids = ui.getGroups(user);
        Security.CredentialsMsg.Builder msg = Security.CredentialsMsg.newBuilder().setUid(uid);
        for (int gid : gids) {
            msg.addGids(gid);
        }
        return msg.build();
    }

    private String getSecondaryNodes(CLDBProto.ContainerInfo containerInfo) {
        StringBuilder secondaryNodesBuilder = new StringBuilder();
        boolean first = true;
        for (Common.Server secondaryServers : containerInfo.getAServersList()) {
            if (MapRCliCommands.compareIPAddress(containerInfo.getMServer().getIps(0), secondaryServers.getIps(0))) continue;
            if (!first) {
                secondaryNodesBuilder.append(" ");
            }
            String host = null;
            if (secondaryServers.hasHostname()) {
                host = secondaryServers.getHostname();
            }
            if (host == null || host.isEmpty()) {
                host = secondaryServers.getIps(0).getHostname();
            }
            secondaryNodesBuilder.append(host + ":" + secondaryServers.getIps(0).getPort());
            first = false;
        }
        return secondaryNodesBuilder.toString();
    }

    public static boolean compareIPAddress(Common.IPAddress a, Common.IPAddress b) {
        if (a == null || b == null) {
            return false;
        }
        return (a.getHostname().equalsIgnoreCase(b.getHostname()) || a.getHost() == b.getHost()) && a.getPort() == b.getPort();
    }

    private int setcompression(String srcf, boolean val, String compType) throws IOException {
        Path srcPath = new Path(srcf);
        if (!this.isMapRFsPath(srcPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + srcf);
        }
        return fs.setCompression(srcPath, val, compType);
    }

    private int setnetworkencryption(String srcf, boolean val) throws IOException {
        Path srcPath = new Path(srcf);
        if (!this.isMapRFsPath(srcPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + srcf);
        }
        return fs.setWireSecurity(srcPath, val);
    }

    private int setchunksize(String srcf, long val) throws IOException {
        Path srcPath = new Path(srcf);
        if (!this.isMapRFsPath(srcPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + srcf);
        }
        if (val % 65536L != 0L) {
            throw new IOException("chunksize should be a multiple of 64K");
        }
        return fs.setChunkSize(srcPath, val);
    }

    private int ln(String target, String link) throws IOException {
        System.out.println("Creating Symlink: " + link + " -> " + target);
        Path srcPath = new Path(link);
        if (!this.isMapRFsPath(srcPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + link);
        }
        return fs.createSymlink(target, srcPath, true);
    }

    private void printHelp(String cmd) {
        String summary = "hadoop mfs is the command to execute MapR shell commands. The full syntax is: \n\nhadoop mfs [-ls] [-lsr] [-lsrv] [-Lsr] [-lsd] [-lsfid]  [-lss] [-lssr] [-ln] [-setcompression] [-setchunksize] [-setnetworkencryption] [-help [cmd]]\n";
        String ls = "-ls <path>: \t\t\tList the contents that match the specified file pattern. If\n\t\t\t\tpath is not specified, the contents of /user/<currentUser>\n\t\t\t\twill be listed. Directory entries are of the form \n\t\t\t\t\tdirName (full path) <dir> \n\t\t\t\tand file entries are of the form \n\t\t\t\t\tfileName(full path) <r n> size \n\t\t\t\twhere n is the number of replicas specified for the file \n\t\t\t\tand size is the size of the file, in bytes.\n";
        String lsr = "-lsr <path>: \t\t\tRecursively list the contents that match the specified\n\t\t\t\tfile pattern.  Behaves very similarly to hadoop fs -ls,\n\t\t\t\texcept that the data is shown for all the entries in the\n\t\t\t\tsubtree.\n";
        String lsrv = "-lsrv <path>: \t\t\tEquivalent to lsr; does not follow volume links\n";
        String Lsr2 = "-Lsr <path>: \t\t\tEquivalent to lsr; in addition derefernces symbolic links\n";
        String lsd = "-lsd <path>: \t\t\tList the properties of the directory that match the\n\t\t\t\tspecified pattern.\n";
        String lsfid = "-lsfid <cid.cinum.uniq>: \t\t\tList the properties of the\t\t\t\tpath specified by the fid. Requires root privileges.\n";
        String ln = "-ln <target> <link>: \t\tCreate a symbolic link to a target.\n";
        String setcompression = "-setcompression <on|off|lzf|lz4|zlib> <dir|table>: Set the compression on a directory or a table.\n";
        String setnetworkencryption = "-setnetworkencryption <on|off> <file|dir|table>: Set network encryption on a file or a directory or a table.\n";
        String setchunksize = "-setchunksize <size> <dir>: \tSet the Chunk Size in bytes (multiple of 64K), on a directory.\n";
        String lss = "-lss <path>: \t\t\tList the contents that match the specified file pattern.\n\t\t\t\tIn addition, list the number of disk-blocks (of size 8192 bytes) per block\n";
        String lssr = "-lssr <path>: \t\t\tRecursively list the contents that match the specified file pattern.\n\t\t\t\tIn addition, list the number of disk-blocks (of size 8192 bytes) per block\n";
        String help = "-help [cmd]: \t\t\tDisplays help for given command or all commands if none\n\t\t\t\tis specified.\n";
        if ("ls".equals(cmd)) {
            System.out.println(ls);
        } else if ("lsr".equals(cmd)) {
            System.out.println(lsr);
        } else if ("lsrv".equals(cmd)) {
            System.out.println(lsrv);
        } else if ("Lsr".equals(cmd)) {
            System.out.println(Lsr2);
        } else if ("lsd".equals(cmd)) {
            System.out.println(lsd);
        } else if ("lsfid".equals(cmd)) {
            System.out.println(lsfid);
        } else if ("ln".equals(cmd)) {
            System.out.println(ln);
        } else if ("setcompression".equals(cmd)) {
            System.out.println(setcompression);
        } else if ("setnetworkencryption".equals(cmd)) {
            System.out.println(setnetworkencryption);
        } else if ("setchunksize".equals(cmd)) {
            System.out.println(setchunksize);
        } else if ("lss".equals(cmd)) {
            System.out.println(lss);
        } else if ("lssr".equals(cmd)) {
            System.out.println(lssr);
        } else if ("help".equals(cmd)) {
            System.out.println(help);
        } else {
            System.out.println(summary);
            System.out.println(ls);
            System.out.println(lsr);
            System.out.println(lsrv);
            System.out.println(Lsr2);
            System.out.println(lsd);
            System.out.println(lsfid);
            System.out.println(lss);
            System.out.println(lssr);
            System.out.println(ln);
            System.out.println(setcompression);
            System.out.println(setnetworkencryption);
            System.out.println(setchunksize);
            System.out.println(help);
        }
    }

    private int doall(String cmd, String[] argv, int startindex) {
        int exitCode = 0;
        boolean compress = false;
        boolean wiresecure = false;
        String compressiontype = null;
        long chunksize = 0L;
        if ("-setnetworkencryption".equals(cmd)) {
            if (argv[startindex].equals("on")) {
                wiresecure = true;
            }
            ++startindex;
        } else if ("-setcompression".equals(cmd)) {
            if (argv[startindex].equals("on")) {
                compress = true;
            } else if (argv[startindex].equals("off")) {
                compress = false;
            } else if (argv[startindex].equals("lzf") || argv[startindex].equals("lz4") || argv[startindex].equals("zlib")) {
                compress = true;
                compressiontype = argv[startindex];
            } else {
                MapRCliCommands.printUsage(cmd);
                return -1;
            }
            ++startindex;
        } else if ("-setchunksize".equals(cmd)) {
            chunksize = Long.valueOf(argv[startindex]);
            ++startindex;
        }
        for (int i = startindex; i < argv.length; ++i) {
            Object content;
            try {
                if ("-ls".equals(cmd)) {
                    exitCode = this.ls(cmd, argv[i], 0);
                    continue;
                }
                if ("-lsr".equals(cmd)) {
                    exitCode = this.ls(cmd, argv[i], RecursiveBit);
                    continue;
                }
                if ("-lsrv".equals(cmd)) {
                    exitCode = this.ls(cmd, argv[i], RecursiveBit | SingleVolumeBit);
                    continue;
                }
                if ("-Lsr".equals(cmd)) {
                    exitCode = this.ls(cmd, argv[i], RecursiveBit | DereferenceSymlinkBit);
                    continue;
                }
                if ("-lsd".equals(cmd)) {
                    exitCode = this.ls(cmd, argv[i], DirOnlyBit);
                    continue;
                }
                if ("-lsfid".equals(cmd)) {
                    exitCode = this.ls(cmd, argv[i], DirOnlyBit | FidBit);
                    continue;
                }
                if ("-lss".equals(cmd)) {
                    exitCode = this.ls(cmd, argv[i], DiskBlockOnlyBit);
                    continue;
                }
                if ("-lssr".equals(cmd)) {
                    exitCode = this.ls(cmd, argv[i], RecursiveBit | DiskBlockOnlyBit);
                    continue;
                }
                if ("-ln".equals(cmd)) {
                    exitCode = this.ln(argv[i], argv[i + 1]);
                    ++i;
                    continue;
                }
                if ("-setcompression".equals(cmd)) {
                    exitCode = this.setcompression(argv[i], compress, compressiontype);
                    continue;
                }
                if ("-setnetworkencryption".equals(cmd)) {
                    exitCode = this.setnetworkencryption(argv[i], wiresecure);
                    continue;
                }
                if (!"-setchunksize".equals(cmd)) continue;
                exitCode = this.setchunksize(argv[i], chunksize);
                continue;
            }
            catch (RemoteException e) {
                exitCode = -1;
                try {
                    content = e.getLocalizedMessage().split("\n");
                    System.err.println(cmd.substring(1) + ": " + content[0]);
                }
                catch (Exception ex) {
                    System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
                }
                continue;
            }
            catch (IOException e) {
                exitCode = -1;
                content = e.getLocalizedMessage();
                if (content != null) {
                    content = content.split("\n")[0];
                }
                System.err.println(cmd.substring(1) + ": " + (String)content);
                continue;
            }
            catch (Exception e) {
                System.err.println(e.getLocalizedMessage());
            }
        }
        return exitCode;
    }

    private static void printUsage(String cmd) {
        String prefix = "Usage: mfs";
        if ("-ls".equals(cmd) || "-lsr".equals(cmd) || "-lsrv".equals(cmd) || "-Lsr".equals(cmd) || "-lsd".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <path>]");
        } else if ("-lsfid".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <cid.cinum.uniq>]");
        } else if ("-ln".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <target> <symlink>]");
        } else if ("-setcompression".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <on|off|lzf|lz4|zlib> <dir|table>]");
        } else if ("-setnetworkencryption".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <on|off> <file|dir|table>]");
        } else if ("-setchunksize".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <size> <dir>]");
        } else if ("-lss".equals(cmd) || "-lssr".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <file>]");
        } else {
            System.err.println(prefix);
            System.err.println("           [-ls <path>]");
            System.err.println("           [-lsr <path>]");
            System.err.println("           [-lsrv <path>]");
            System.err.println("           [-Lsr <path>]");
            System.err.println("           [-lsd <path>]");
            System.err.println("           [-lsfid <cid.cinum.uniq>]");
            System.err.println("           [-lss <path>]");
            System.err.println("           [-lssr <path>]");
            System.err.println("           [-ln <target> <symlink>]");
            System.err.println("           [-setcompression <on|off|lzf|lz4|zlib>] <dir|table>");
            System.err.println("           [-setchunksize <size in bytes (multiple of 65536)> <dir>]");
            System.err.println("           [-setnetworkencryption <on|off> <file|dir|table>]");
            System.err.println("           [-help [cmd]]");
            System.err.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int run(String[] argv) throws Exception {
        if (argv.length < 1) {
            MapRCliCommands.printUsage("");
            return -1;
        }
        int exitCode = -1;
        int i = 0;
        String cmd = argv[i++];
        try {
            this.init();
        }
        catch (RPC.VersionMismatch v) {
            System.err.println("Version Mismatch between client and server... command aborted.");
            return exitCode;
        }
        catch (IOException e) {
            System.err.println("Bad connection to FS. command aborted.");
            return exitCode;
        }
        exitCode = 0;
        try {
            if ("-ls".equals(cmd)) {
                if (i >= argv.length) return this.ls(cmd, ".", 0);
                return this.doall(cmd, argv, i);
            }
            if ("-lsr".equals(cmd)) {
                if (i >= argv.length) return this.ls(cmd, ".", RecursiveBit);
                return this.doall(cmd, argv, i);
            }
            if ("-lsrv".equals(cmd)) {
                if (i >= argv.length) return this.ls(cmd, ".", RecursiveBit | SingleVolumeBit);
                return this.doall(cmd, argv, i);
            }
            if ("-Lsr".equals(cmd)) {
                if (i >= argv.length) return this.ls(cmd, ".", RecursiveBit | DereferenceSymlinkBit);
                return this.doall(cmd, argv, i);
            }
            if ("-lsd".equals(cmd)) {
                if (i >= argv.length) return this.ls(cmd, ".", DirOnlyBit);
                return this.doall(cmd, argv, i);
            }
            if ("-lsfid".equals(cmd)) {
                if (i < argv.length) {
                    return this.doall(cmd, argv, i);
                }
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-lss".equals(cmd)) {
                if (i >= argv.length) return this.ls(cmd, ".", DiskBlockOnlyBit);
                return this.doall(cmd, argv, i);
            }
            if ("-lssr".equals(cmd)) {
                if (i >= argv.length) return this.ls(cmd, ".", RecursiveBit | DiskBlockOnlyBit);
                return this.doall(cmd, argv, i);
            }
            if ("-ln".equals(cmd)) {
                if (argv.length >= 3) return this.doall(cmd, argv, i);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-setcompression".equals(cmd)) {
                if (argv.length >= 3) return this.doall(cmd, argv, i);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-setnetworkencryption".equals(cmd)) {
                if (argv.length >= 3) return this.doall(cmd, argv, i);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-setchunksize".equals(cmd)) {
                if (argv.length >= 3) return this.doall(cmd, argv, i);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if (!"-help".equals(cmd)) {
                exitCode = -1;
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if (i < argv.length) {
                this.printHelp(argv[i]);
                return exitCode;
            }
            this.printHelp("");
            return exitCode;
        }
        catch (IllegalArgumentException arge) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + arge.getLocalizedMessage());
            MapRCliCommands.printUsage(cmd);
            return exitCode;
        }
        catch (RemoteException e) {
            exitCode = -1;
            try {
                String[] content = e.getLocalizedMessage().split("\n");
                System.err.println(cmd.substring(1) + ": " + content[0]);
                return exitCode;
            }
            catch (Exception ex) {
                System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
                return exitCode;
            }
        }
        catch (IOException e) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
            return exitCode;
        }
        catch (Exception re) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + re.getLocalizedMessage());
            return exitCode;
        }
    }

    public void close() throws IOException {
        if (fs != null) {
            fs.close();
            fs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        int res;
        try (MapRCliCommands shell = new MapRCliCommands();){
            res = ToolRunner.run(shell, argv);
        }
        System.exit(res);
    }

    static {
        ui = new UnixUserGroupHelper();
        dateForm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        modifFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        modifFmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        fileStatusComparator = new Comparator<MapRFileStatus>(){

            @Override
            public int compare(MapRFileStatus f1, MapRFileStatus f2) {
                return f1.getPath().toString().compareTo(f2.getPath().toString());
            }
        };
    }

    private static final class ShellListResult {
        private final int lsErrors;
        private final MapRFileStatus[] lsResult;

        private ShellListResult(MapRFileStatus[] lsResult, int lsErrors) {
            this.lsResult = lsResult;
            this.lsErrors = lsErrors;
        }
    }
}

