/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.OSInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.ProtectionDomain;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ShimLoader {
    static final String NATIVE_LOADER_CLASS_NAME = "com.mapr.fs.shim.LibraryLoader";
    static final String[] PRELOAD_CLASSES = new String[]{"com.mapr.fs.jni.Errno", "com.mapr.fs.jni.MapRConstants", "com.mapr.fs.jni.MapRConstants$JniUsername", "com.mapr.fs.jni.MapRConstants$ErrorValue", "com.mapr.fs.jni.MapRConstants$RowConstants", "com.mapr.fs.jni.MapRConstants$PutConstants", "com.mapr.fs.jni.JNIBlockLocation", "com.mapr.fs.jni.JNIFsStatus", "com.mapr.fs.jni.JNIFileStatus", "com.mapr.fs.jni.JNIFileStatus$VolumeInfo", "com.mapr.fs.jni.JNILoggerProxy", "com.mapr.fs.jni.IPPort", "com.mapr.fs.jni.GatewaySource", "com.mapr.fs.jni.Page", "com.mapr.fs.jni.Page$CacheState", "com.mapr.fs.jni.InodeAttributes", "com.mapr.fs.jni.SFid", "com.mapr.fs.jni.MapRAsyncRpc", "com.mapr.fs.jni.MapRGet", "com.mapr.fs.jni.MapRPut", "com.mapr.fs.jni.MapRIncrement", "com.mapr.fs.jni.MapRKeyValue", "com.mapr.fs.jni.MapRRowConstraint", "com.mapr.fs.jni.MapRScan", "com.mapr.fs.jni.MapRCallBackQueue", "com.mapr.fs.jni.MapRClient", "com.mapr.fs.jni.MapRTableTools", "com.mapr.security.JNISecurity", "com.mapr.security.JNISecurity$MutableErr", "com.mapr.security.UnixUserGroupHelper", "com.mapr.fs.jni.MapRUserGroupInfo", "com.mapr.fs.jni.MapRUserInfo", "com.mapr.fs.jni.RpcNative", "com.mapr.fs.RpcCallContext", "com.mapr.fs.jni.MapRClientInitParams", "com.mapr.fs.jni.RowColDecoder", "com.mapr.fs.jni.RowColDecoder$1", "com.mapr.fs.jni.RowColDecoderCallback", "com.mapr.fs.jni.RowColParser", "com.mapr.fs.jni.RowColParser$1", "com.mapr.fs.jni.RowColParser$STATE", "com.mapr.fs.jni.RowColParser$ValType", "com.mapr.fs.jni.MapRResult", "com.mapr.fs.jni.MapRResult$MapRResultDecoderCallback", "com.mapr.fs.jni.ParsedRow"};
    static final String[] WEBAPP_SYSTEM_CLASSES = new String[]{"com.mapr.fs.jni."};
    private static volatile boolean isLoaded = false;
    private static boolean debugLog = System.getProperty("shimloader.debuglog") != null;
    private static final String USER_NAME = System.getProperty("user.name").replaceAll("[\\\\/:]", "_");
    private static final String LIBRARY_VERSION = ShimLoader.getLibraryVersion(ShimLoader.class);

    private static ClassLoader getRootClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ShimLoader.class.getClassLoader();
        }
        ShimLoader.trace("getRootClassLoader: thread classLoader is '%s'", cl.getClass().getCanonicalName());
        while (cl.getParent() != null) {
            cl = cl.getParent();
        }
        ShimLoader.trace("getRootClassLoader: root classLoader is '%s'", cl.getClass().getCanonicalName());
        return cl;
    }

    private static byte[] getByteCode(String resourcePath) throws IOException {
        int readLength;
        InputStream in = ShimLoader.class.getResourceAsStream(resourcePath);
        if (in == null) {
            throw new IOException(resourcePath + " is not found");
        }
        byte[] buf = new byte[1024];
        ByteArrayOutputStream byteCodeBuf = new ByteArrayOutputStream();
        while ((readLength = in.read(buf)) != -1) {
            byteCodeBuf.write(buf, 0, readLength);
        }
        in.close();
        return byteCodeBuf.toByteArray();
    }

    public static boolean isNativeLibraryLoaded() {
        return isLoaded;
    }

    private static boolean isMaprClntLibLoaded() {
        boolean loaderLoaded = false;
        try {
            Class<?> loaderClass = Class.forName(NATIVE_LOADER_CLASS_NAME);
            Method getMethod = loaderClass.getDeclaredMethod("isMapRClntLibLoaded", new Class[0]);
            loaderLoaded = (Boolean)getMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            loaderLoaded = false;
        }
        return loaderLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void load() {
        if (isLoaded) {
            ShimLoader.trace("MapR native classes already loaded", new Object[0]);
            return;
        }
        boolean loadInRootClassloader = System.getProperty("mapr.library.flatclass") == null;
        ShimLoader.trace("Load in root Classloader: %s.", loadInRootClassloader);
        try {
            if (loadInRootClassloader) {
                if (!ShimLoader.isMaprClntLibLoaded()) {
                    String synchronizationString;
                    ShimLoader.trace("Injecting Native Loader", new Object[0]);
                    String string = synchronizationString = NATIVE_LOADER_CLASS_NAME.intern();
                    synchronized (string) {
                        if (!ShimLoader.isMaprClntLibLoaded()) {
                            Class<?> nativeLoader = ShimLoader.injectNativeLoader();
                            ShimLoader.loadNativeLibrary(nativeLoader);
                            ShimLoader.trace("Native Loader injected", new Object[0]);
                        }
                    }
                }
                ShimLoader.addSystemClassesToWebApps(PRELOAD_CLASSES);
            } else {
                ShimLoader.loadNativeLibrary(System.class);
            }
            isLoaded = true;
        }
        catch (Exception e) {
            ShimLoader.trace("Unable to load libMapRClient.so native library.", new Object[0]);
            e.printStackTrace(System.err);
            throw new ExceptionInInitializerError(e);
        }
    }

    private static Class<?> injectNativeLoader() {
        try {
            ClassLoader rootClassLoader = ShimLoader.getRootClassLoader();
            byte[] libLoaderByteCode = ShimLoader.getByteCode("/com/mapr/fs/shim/LibraryLoader.bytecode");
            ArrayList<byte[]> preloadClassByteCode = new ArrayList<byte[]>(PRELOAD_CLASSES.length);
            for (String each : PRELOAD_CLASSES) {
                preloadClassByteCode.add(ShimLoader.getByteCode(String.format("/%s.class", each.replaceAll("\\.", "/"))));
            }
            Class<?> classLoader = Class.forName("java.lang.ClassLoader");
            Method defineClass = classLoader.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
            ProtectionDomain pd = System.class.getProtectionDomain();
            defineClass.setAccessible(true);
            try {
                ShimLoader.trace("injectNativeLoader: Loading MapR native classes", new Object[0]);
                defineClass.invoke((Object)rootClassLoader, NATIVE_LOADER_CLASS_NAME, libLoaderByteCode, 0, libLoaderByteCode.length, pd);
                for (int i = 0; i < PRELOAD_CLASSES.length; ++i) {
                    byte[] b = (byte[])preloadClassByteCode.get(i);
                    defineClass.invoke((Object)rootClassLoader, PRELOAD_CLASSES[i], b, 0, b.length, pd);
                }
            }
            catch (InvocationTargetException ex) {
                throw ex;
            }
            finally {
                defineClass.setAccessible(false);
            }
            return rootClassLoader.loadClass(NATIVE_LOADER_CLASS_NAME);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException("Failure loading MapRClient. ", e);
        }
    }

    private static void loadNativeLibrary(Class<?> loaderClass) throws Exception {
        if (loaderClass == null) {
            throw new RuntimeException("Missing LibraryLoader native loader class");
        }
        try {
            Method loadMethod = loaderClass.getDeclaredMethod("loadLibrary", String.class);
            loadMethod.invoke(null, "MapRClient");
            ShimLoader.trace("Loaded native library from '%s'.", System.getProperty("java.library.path"));
            return;
        }
        catch (Exception ex) {
            Exception straightLoadException = ex;
            try {
                File nativeLib = ShimLoader.findNativeLibrary();
                if (nativeLib != null) {
                    Method loadMethod = loaderClass.getDeclaredMethod("load", String.class);
                    loadMethod.invoke(null, nativeLib.getAbsolutePath());
                    ShimLoader.trace("Native library loaded.", new Object[0]);
                    Method setMethod = loaderClass.getDeclaredMethod("setMaprClntLibLoaded", new Class[0]);
                    setMethod.invoke(null, new Object[0]);
                    return;
                }
                throw straightLoadException;
            }
            catch (RuntimeException ex2) {
                System.err.println("==========Unable to find library on native path due to Exception. ==============");
                straightLoadException.printStackTrace(System.err);
                System.err.println("==========Unable to find library in jar due to exception. ==============");
                ex2.printStackTrace(System.err);
                throw straightLoadException;
            }
        }
    }

    static String md5sum(InputStream input) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(input);){
            MessageDigest digest = MessageDigest.getInstance("MD5");
            DigestInputStream digestInputStream = new DigestInputStream(in, digest);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = digestInputStream.read(buffer)) != -1) {
            }
            ByteArrayOutputStream md5out = new ByteArrayOutputStream();
            md5out.write(digest.digest());
            String string = md5out.toString();
            return string;
        }
    }

    private static File extractLibraryFile(String libFolderForCurrentOS, String libraryFileName, String targetFolder) {
        ShimLoader.trace("Extracting native library to '%s'.", targetFolder);
        int extentionStart = libraryFileName.lastIndexOf(46);
        String extractedLibFileName = "mapr-" + USER_NAME + "-" + libraryFileName.substring(0, extentionStart + 1) + LIBRARY_VERSION + libraryFileName.substring(extentionStart);
        File extractedLibFile = new File(targetFolder, extractedLibFileName);
        ShimLoader.trace("Native library for this platform is '%s'.", extractedLibFileName);
        try {
            String nativeLibraryFilePath = libFolderForCurrentOS + "/" + libraryFileName;
            if (extractedLibFile.exists()) {
                ShimLoader.trace("Target file '%s' already exists, verifying checksum.", extractedLibFile.getAbsolutePath());
                String md5sum1 = ShimLoader.md5sum(ShimLoader.class.getResourceAsStream(nativeLibraryFilePath));
                String md5sum2 = ShimLoader.md5sum(new FileInputStream(extractedLibFile));
                if (md5sum1.equals(md5sum2)) {
                    ShimLoader.trace("Checksum matches, will not extract from the JAR.", new Object[0]);
                    return extractedLibFile;
                }
                ShimLoader.trace("Checksum did not match, will replace existing file from the JAR.", new Object[0]);
                if (!extractedLibFile.delete()) {
                    throw new IOException("Failed to remove existing native library file: " + extractedLibFile.getAbsolutePath());
                }
            }
            ShimLoader.trace("Target file '%s' does not exist, will extract from the JAR.", extractedLibFile);
            InputStream reader = ShimLoader.class.getResourceAsStream(nativeLibraryFilePath);
            File targetFolderFile = new File(targetFolder);
            if (!targetFolderFile.exists()) {
                ShimLoader.trace("Creating target folder %s", targetFolder);
                targetFolderFile.mkdirs();
            }
            FileOutputStream writer = new FileOutputStream(extractedLibFile);
            byte[] buffer = new byte[8192];
            int bytesRead = 0;
            while ((bytesRead = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, bytesRead);
            }
            writer.close();
            reader.close();
            if (!System.getProperty("os.name").contains("Windows")) {
                try {
                    Runtime.getRuntime().exec(new String[]{"chmod", "755", extractedLibFile.getAbsolutePath()}).waitFor();
                }
                catch (Throwable e) {
                    ShimLoader.trace("Error setting executable permission.\n%s.", e.getMessage());
                }
            }
            return extractedLibFile;
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static String getLibraryVersion(Class<?> clazz) {
        String libVersion = "unknown";
        try {
            String className = clazz.getSimpleName() + ".class";
            String qualifiedClassName = clazz.getName().replace('.', '/') + ".class";
            String classURL = clazz.getResource(className).toString();
            int endIndex = classURL.startsWith("jar:") ? classURL.lastIndexOf("!") + 1 : classURL.lastIndexOf(qualifiedClassName) - 1;
            String manifestPath = classURL.substring(0, endIndex) + "/META-INF/MANIFEST.MF";
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes attr = manifest.getMainAttributes();
            Attributes.Name attrName = new Attributes.Name("Implementation-Version");
            if (attr.containsKey(attrName)) {
                libVersion = attr.getValue(attrName);
            } else {
                attrName = new Attributes.Name("Bundle-Version");
                if (attr.containsKey(attrName)) {
                    libVersion = attr.getValue(attrName);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return libVersion;
    }

    static File findNativeLibrary() {
        String nativeLibraryName = System.mapLibraryName("MapRClient");
        String nativeLibraryPath = "/com/mapr/fs/native/" + OSInfo.getNativeLibFolderPathForCurrentOS();
        ShimLoader.trace("Searching for native library '%s/%s'.", nativeLibraryPath, nativeLibraryName);
        boolean hasNativeLib = ShimLoader.hasResource(nativeLibraryPath + "/" + nativeLibraryName);
        if (!hasNativeLib && OSInfo.getOSName().equals("Mac")) {
            String altName = "libMapRClient.dylib";
            ShimLoader.trace("Searching for alternative library '%s' on Mac.", altName);
            if (ShimLoader.hasResource(nativeLibraryPath + "/" + altName)) {
                nativeLibraryName = altName;
                hasNativeLib = true;
            }
        }
        if (!hasNativeLib) {
            String errorMessage = String.format("no native library is found for os.name=%s and os.arch=%s", OSInfo.getOSName(), OSInfo.getArchName());
            ShimLoader.trace(errorMessage, new Object[0]);
            throw new RuntimeException(errorMessage);
        }
        String tempFolder = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
        return ShimLoader.extractLibraryFile(nativeLibraryPath, nativeLibraryName, tempFolder);
    }

    private static boolean hasResource(String path) {
        return ShimLoader.class.getResource(path) != null;
    }

    private static void addSystemClassesToWebApps(String[] systemClasses) {
        try {
            Class<?> jettyWebAppContextClass = Class.forName("org.mortbay.jetty.webapp.WebAppContext");
            Method getCurrentWebAppContextMethod = jettyWebAppContextClass.getMethod("getCurrentWebAppContext", new Class[0]);
            Method getSystemClassesMethod = jettyWebAppContextClass.getMethod("getSystemClasses", new Class[0]);
            Method setSystemClassesMethod = jettyWebAppContextClass.getMethod("setSystemClasses", String[].class);
            Object jettyCurrentWebAppContext = getCurrentWebAppContextMethod.invoke(null, new Object[0]);
            if (jettyCurrentWebAppContext != null) {
                String[] currentSystemClasses = (String[])getSystemClassesMethod.invoke(jettyCurrentWebAppContext, new Object[0]);
                ArrayList newSystemClasses = new ArrayList();
                Collections.addAll(newSystemClasses, currentSystemClasses);
                Collections.addAll(newSystemClasses, systemClasses);
                Object[] newSystemClassesAsObjectArray = new Object[]{newSystemClasses.toArray(new String[0])};
                setSystemClassesMethod.invoke(jettyCurrentWebAppContext, newSystemClassesAsObjectArray);
            }
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void trace(String msg, Object ... args) {
        if (debugLog) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            System.err.println(dateFormat.format(new Date()) + " [" + Thread.currentThread().getId() + "] " + String.format(msg, args));
        }
    }

    public static void main(String[] args) {
        debugLog = true;
        ShimLoader.trace("ShimLoader library version: %s.", LIBRARY_VERSION);
        if (args.length > 0 && args[0].equals("load")) {
            ShimLoader.load();
        } else {
            ShimLoader.trace("Native library path: '%s'.", ShimLoader.findNativeLibrary());
        }
    }
}

