/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.Inode;
import com.mapr.fs.JobTrackerWatcher;
import com.mapr.fs.LoggerProxy;
import com.mapr.fs.MapRBlockLocation;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRFsInStream;
import com.mapr.fs.MapRFsOutStream;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.jni.Errno;
import com.mapr.fs.jni.GatewaySource;
import com.mapr.fs.jni.IOExceptionWithErrorCode;
import com.mapr.fs.jni.IPPort;
import com.mapr.fs.jni.InodeAttributes;
import com.mapr.fs.jni.JNIFsStatus;
import com.mapr.fs.jni.MapRClient;
import com.mapr.fs.jni.MapRClientInitParams;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.jni.MapRUserInfo;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Fileserver;
import com.mapr.login.MapRLoginException;
import com.mapr.login.client.MapRLoginHttpsClient;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import oadd.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathId;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.Progressable;

public class MapRClientImpl
extends MapRClient
implements MapRConstants {
    public static final Log LOG = LogFactory.getLog(MapRClient.class);
    private static boolean readBuffering_ = true;
    private static int slowOpsThreshold = 0;
    private long clntPtr;
    private String clusterName;
    private JobTrackerWatcher jtwatcher;
    private String zkString;

    public MapRClientImpl(String clusterName, long[] ips, String auth, boolean disableNameCache, MapRClientInitParams clientInitParams) throws IOException {
        try {
            try {
                MapRLoginHttpsClient loginclient = new MapRLoginHttpsClient();
                loginclient.authenticateIfNeeded(clusterName);
            }
            catch (MapRLoginException e) {
                throw new IOException("failure to authenticate to cluster " + clusterName, e);
            }
            this.clntPtr = this.OpenClient(clusterName, ips, auth, disableNameCache, clientInitParams);
            if (this.clntPtr == 0L) {
                throw new IOException("Could not create FileClient");
            }
        }
        catch (UnknownHostException e) {
            System.out.println("Exception occured " + e);
        }
        this.clusterName = clusterName;
        this.jtwatcher = null;
        this.zkString = MapRClientImpl.getZkConnectString(this.clntPtr, true);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void close() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MapRClient closing");
        }
        long ptr = this.clntPtr;
        this.clntPtr = 0L;
        this.CloseClient(ptr);
    }

    public int GetUserInfo(MapRUserInfo userInfo) {
        return this.GetUserInfo(this.clntPtr, userInfo);
    }

    public static void setReadBuffering(boolean v) {
        readBuffering_ = v;
    }

    public static boolean readBuffering() {
        return readBuffering_;
    }

    public static void setSlowOpsThreshold(int v) {
        slowOpsThreshold = v;
    }

    public static int getSlowOpsThreshold() {
        return slowOpsThreshold;
    }

    public MapRFsOutStream create(String name, int mask, int mode, boolean createIfNonExistant, boolean append, boolean overwrite, short replication, long chunkSize, Progressable progress, MapRConstants.ErrorValue err, boolean createParent, MapRUserInfo userInfo, FileSystem.Statistics stats) throws IOException {
        long filePtr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Create: " + name + " mode = " + mode + " replication = " + replication + " chunkSize = " + ((mask & 0x80) != 0 ? Long.valueOf(chunkSize) : "default") + " overwrite = " + overwrite));
        }
        if ((filePtr = this.create(this.clntPtr, name, mask, mode, createIfNonExistant, append, overwrite, replication, chunkSize, createParent, err, userInfo)) == 0L) {
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                return null;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + userInfo.userName + "(user id " + userInfo.GetUserID() + ") " + "does not have access to " + name);
            }
            if (err.error == 2) {
                throw new FileNotFoundException("Create failed for file: " + name + ", error: " + Errno.toString(err.error) + "(" + err.error + ")");
            }
            throw new IOException("Create failed for file: " + name + ", error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
        return new MapRFsOutStream(this.clntPtr, filePtr, name, stats, userInfo);
    }

    public IPPort[] getGatewayIps(String file, String dstCluster, boolean skipCache, GatewaySource source, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return MapRClientImpl.getGatewayIps(this.clntPtr, file, dstCluster, skipCache, source, err, userInfo);
    }

    public MapRFsInStream open(String name, MapRConstants.ErrorValue err, MapRUserInfo userInfo, FileSystem.Statistics stats) throws IOException {
        InodeAttributes attr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Open: path = " + name));
        }
        if ((attr = this.open(this.clntPtr, name, 0, err, userInfo)) == null || attr.filePtr == 0L) {
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 13) {
                throw new AccessControlException("Open failed for file: " + name + ", error: " + Errno.toString(err.error) + " (" + err.error + ")");
            }
            if (err.error == 136) {
                return null;
            }
            if (err.error == 2) {
                throw new FileNotFoundException(name);
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + userInfo.userName + "(user id " + userInfo.GetUserID() + ") " + "does not have access to " + name);
            }
            throw new IOException("Open failed for file: " + name + ", error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
        return new MapRFsInStream(this.clntPtr, attr.filePtr, name, stats, attr, userInfo);
    }

    public MapRFsInStream openFid2(PathId pfid, String file, int length, MapRUserInfo userInfo, FileSystem.Statistics stats) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("openFid2: fid = " + pfid + ", file = " + (file != null ? file : "") + ", length = " + length));
        }
        MapRFsInStream is = new MapRFsInStream(this.clntPtr, 0L, null, stats, userInfo);
        is.openAndRead(pfid, file, length);
        return is;
    }

    public MapRFsInStream openFid(String fid, long[] ips, long chunkSize, long fileSize, MapRUserInfo userInfo, FileSystem.Statistics stats) throws IOException, IOExceptionWithErrorCode {
        MapRConstants.ErrorValue err;
        InodeAttributes attr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("openFid: fid = " + fid + ", chunkSize = " + chunkSize + ", fileSize = " + fileSize));
        }
        if ((attr = this.openFidWithParams(this.clntPtr, fid, ips, chunkSize, fileSize, err = new MapRConstants.ErrorValue(), userInfo)) == null || attr.filePtr == 0L) {
            throw new IOExceptionWithErrorCode("openFid failed for fid: " + fid + ", error: " + Errno.toString(err.error) + " (" + err.error + ")", err.error);
        }
        return new MapRFsInStream(this.clntPtr, attr.filePtr, null, stats, attr, userInfo);
    }

    public MapRFsInStream openFid(String pfid, String file, long[] ips, MapRUserInfo userInfo, FileSystem.Statistics stats) throws IOException, IOExceptionWithErrorCode {
        MapRConstants.ErrorValue err;
        InodeAttributes attr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("openFid: pfid = " + pfid + ", file = " + file));
        }
        if ((attr = this.openFid(this.clntPtr, pfid, file, ips, err = new MapRConstants.ErrorValue(), userInfo)) == null || attr.filePtr == 0L) {
            String errMsg = err.error != 0 ? ", error: " + Errno.toString(err.error) + " (" + err.error + ")" : "";
            throw new IOExceptionWithErrorCode("openFid failed for pfid: " + pfid + ", file: " + file + errMsg, err.error);
        }
        return new MapRFsInStream(this.clntPtr, attr.filePtr, null, stats, attr, userInfo);
    }

    public MapRFsOutStream createFid(String pfid, String file, int mask, int mode, long chunkSize, MapRUserInfo userInfo, FileSystem.Statistics stats) throws IOException {
        MapRConstants.ErrorValue err;
        long filePtr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createFid: pfid = " + pfid + ", file = " + file));
        }
        if ((filePtr = this.createFid(this.clntPtr, pfid, file, mask, mode, chunkSize, err = new MapRConstants.ErrorValue(), userInfo)) == 0L) {
            throw new IOException("createFid failed for pfid: " + pfid + ", file: " + file + ", error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
        return new MapRFsOutStream(this.clntPtr, filePtr, null, stats, userInfo);
    }

    public int deleteFid(String pfid, String dir, MapRUserInfo userInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deleteFid: pfid = " + pfid + ", dir = " + (dir != null ? dir : "")));
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        return this.removeFid(this.clntPtr, pfid, dir, err, userInfo);
    }

    public String mkdirsFid(String pfid, String dir, int mask, int mode, boolean compress, long chunkSize, MapRUserInfo userInfo) throws IOException {
        MapRConstants.ErrorValue err;
        String fidStr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mkdirsFid: pfid = " + pfid + ", dir = " + dir));
        }
        if ((fidStr = this.mkdirsFid(this.clntPtr, pfid, dir, mask, mode, compress, chunkSize, err = new MapRConstants.ErrorValue(), userInfo)) == null) {
            throw new IOException("mkdirsFid failed, Error: " + Errno.toString(err.error));
        }
        return fidStr;
    }

    public MapRFsOutStream append(String name, MapRConstants.ErrorValue err, MapRUserInfo userInfo, FileSystem.Statistics stats) throws IOException {
        InodeAttributes attr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Append: path = " + name));
        }
        if ((attr = this.open(this.clntPtr, name, 1, err, userInfo)) == null || attr.filePtr == 0L) {
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 13) {
                throw new AccessControlException("Append failed for file: " + name + ", error: " + Errno.toString(err.error) + " (" + err.error + ")");
            }
            if (err.error == 136) {
                return null;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + userInfo.userName + "(user id " + userInfo.GetUserID() + ") " + " does not have access to " + name);
            }
            throw new IOException("Append failed for file: " + name + ", error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
        MapRFsOutStream os = new MapRFsOutStream(this.clntPtr, attr.filePtr, name, stats, userInfo);
        os.seekToEof();
        return os;
    }

    public int delete(String name, boolean recursive, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return this.remove(this.clntPtr, name, recursive, err, userInfo);
    }

    public MapRFileStatus getFileStatus(String name, boolean needSlashMapr, String scheme, String authority, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return MapRFileStatus.getStatus(this.getattr(this.clntPtr, name, needSlashMapr, authority, err, userInfo), scheme);
    }

    public MapRFileStatus[] listStatus(String name, boolean showVols, boolean needSlashMapr, boolean showHidden, String scheme, String authority, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return MapRFileStatus.getStatus(this.readdirplus(this.clntPtr, name, showVols, needSlashMapr, showHidden, authority, err, userInfo), scheme);
    }

    public int rename(String src, String dest, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return this.rename(this.clntPtr, src, dest, err, userInfo);
    }

    public int mkdirs(String name, int mask, int mode, boolean compress, long chunkSize, MapRConstants.ErrorValue err, boolean needFid, boolean createParent, MapRUserInfo userInfo) {
        return this.mkdirs(this.clntPtr, name, mask, mode, compress, chunkSize, err, needFid, createParent, userInfo);
    }

    public MapRBlockLocation[] getBlockLocations(String name, long start, long len, boolean usePrimaryFid, boolean needDiskBlocks, MapRConstants.ErrorValue err) {
        return MapRBlockLocation.getLocation(this.getBlockInfo(this.clntPtr, name, start, len, usePrimaryFid, needDiskBlocks, err));
    }

    public int setattr(String name, int bitmask, String user, String group, long mtime, long atime, int mode, short repl, boolean canCompress, String compressionName, long chunkSize, boolean wireSecurityEnabled, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return this.setattr(this.clntPtr, name, bitmask, user, group, mtime, atime, mode, repl, canCompress, compressionName, chunkSize, wireSecurityEnabled, err, userInfo);
    }

    public int setOwner(String name, String user, String group, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        int b = 0;
        if (user != null) {
            b |= 1;
        }
        if (group != null) {
            b |= 2;
        }
        return this.setattr(this.clntPtr, name, b, user, group, 0L, 0L, -1, (short)0, true, null, -1L, false, err, userInfo);
    }

    public int setOwnerFid(String name, String user, String group, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        int b = 0;
        if (user != null) {
            b |= 1;
        }
        if (group != null) {
            b |= 2;
        }
        return this.setattr(this.clntPtr, name, b |= 0x400, user, group, 0L, 0L, -1, (short)0, true, null, -1L, false, err, userInfo);
    }

    public int setTimes(String name, long mtime, long atime, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        int b = 0;
        if (mtime != -1L) {
            b |= 4;
        }
        if (atime != -1L) {
            b |= 8;
        }
        return this.setattr(this.clntPtr, name, b, null, null, mtime, atime, -1, (short)0, true, null, -1L, false, err, userInfo);
    }

    public int setPermission(String name, int mode, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return this.setattr(this.clntPtr, name, 16, null, null, 0L, 0L, mode, (short)0, true, null, -1L, false, err, userInfo);
    }

    public FsStatus getStatus() {
        JNIFsStatus fs = this.getStatus(this.clntPtr);
        return new FsStatus(fs.getCapacity(), fs.getUsed(), fs.getRemaining());
    }

    public int setReplication(String name, short repl, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return this.setattr(this.clntPtr, name, 32, null, null, 0L, 0L, -1, repl, true, null, -1L, false, err, userInfo);
    }

    public void createSymlink(String target, String link, boolean createParent, int mask, int mode, long chunkSize, MapRConstants.ErrorValue linkErr, MapRUserInfo userInfo) throws IOException {
        this.createSymlink(this.clntPtr, target, link, createParent, mask, mode, chunkSize, linkErr, userInfo);
    }

    public Path getLinkTarget(String f, MapRConstants.ErrorValue err) {
        String link = this.readlink(this.clntPtr, f, err);
        return new Path(link);
    }

    public int setCompression(String path, boolean val, String compName, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        MapRFileStatus status = MapRFileStatus.getStatus(this.getattr(this.clntPtr, path, false, null, err, userInfo));
        if (status.isDir() || status.isTable()) {
            int mask = 64;
            if (compName != null) {
                mask |= 0x200;
            }
            return this.setattr(this.clntPtr, path, mask, null, null, 0L, 0L, -1, (short)0, val, compName, -1L, false, err, userInfo);
        }
        return -1;
    }

    public int setWireSecurity(String path, boolean val, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        MapRFileStatus status = MapRFileStatus.getStatus(this.getattr(this.clntPtr, path, false, null, err, userInfo));
        int mask = 4096;
        return this.setattr(this.clntPtr, path, mask, null, null, 0L, 0L, -1, (short)0, val, null, -1L, val, err, userInfo);
    }

    public int setChunkSize(String path, long val, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        MapRFileStatus status = MapRFileStatus.getStatus(this.getattr(this.clntPtr, path, false, null, err, userInfo));
        if (err.error < 0) {
            err.error = -err.error;
        }
        if (status == null || err.error == 136) {
            return -1;
        }
        if (status.isDir()) {
            return this.setattr(this.clntPtr, path, 128, null, null, 0L, 0L, -1, (short)0, true, null, val, false, err, userInfo);
        }
        return -1;
    }

    public int mountVolume(String volName, String mountPath, String username, MapRUserInfo userInfo, int mode) {
        return this.mountVolume(this.clntPtr, volName, mountPath, username, userInfo, mode);
    }

    public int unmountVolume(String volName, String mountPath, String username, int pCid, int pCinum, int pUniq, MapRUserInfo userInfo) {
        return this.unmountVolume(this.clntPtr, volName, mountPath, username, pCid, pCinum, pUniq, userInfo);
    }

    public String getMountPath(String username, int pCid, int pCinum, int pUniq, MapRUserInfo userInfo) {
        return this.getPathFromFid(this.clntPtr, username, pCid, pCinum, pUniq, userInfo);
    }

    public int createSnapshot(String volName, int volId, int rootCid, String snapshotName, boolean mirrorSnapshot, String username, MapRUserInfo userInfo) {
        return this.createSnapshot(this.clntPtr, volName, volId, rootCid, snapshotName, mirrorSnapshot, username, userInfo);
    }

    public int createVolLink(String volName, String volLink, boolean writeable, boolean hidden, MapRUserInfo userInfo) {
        return this.createVolLink(this.clntPtr, volName, volLink, writeable, hidden, userInfo);
    }

    public int deleteVolLink(String volLink, MapRUserInfo userInfo) {
        return this.deleteVolLink(this.clntPtr, volLink, userInfo);
    }

    public static int getModeBits(FsPermission permission, Configuration conf) {
        int mode = permission != null ? permission.toShort() : FsPermission.getDefault().toShort();
        short umask = FsPermission.getUMask(conf).toShort();
        return mode &= ~umask;
    }

    public synchronized String getZkConnectString() {
        String ret = this.zkString;
        if (ret == null || ret.isEmpty()) {
            ret = MapRClientImpl.getZkConnectString(this.clntPtr, false);
        }
        this.zkString = null;
        return ret;
    }

    public synchronized InetSocketAddress[] getJobTrackerAddrs() throws IOException {
        String zkConnectString;
        boolean done = false;
        int attempts = 0;
        InetSocketAddress[] jobTrackerAddrs = new InetSocketAddress[1];
        while (!done) {
            if (this.jtwatcher == null) {
                zkConnectString = this.getZkConnectString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("zkConnectString: = " + zkConnectString));
                }
                if (zkConnectString != null && !zkConnectString.isEmpty()) {
                    this.jtwatcher = new JobTrackerWatcher(zkConnectString);
                    if (!this.jtwatcher.connect()) {
                        this.jtwatcher.close();
                        this.jtwatcher = null;
                        throw new IOException("Failed to connect to Zookeeper at " + zkConnectString + " for cluster " + this.getClusterName());
                    }
                } else {
                    throw new IOException("Failed to get Zookeeper information for cluster " + this.getClusterName());
                }
            }
            try {
                jobTrackerAddrs[0] = this.jtwatcher.findJobTrackerAddr();
                done = true;
            }
            catch (KeeperException ke) {
                if (ke instanceof KeeperException.SessionExpiredException || ke instanceof KeeperException.SessionMovedException || ke instanceof KeeperException.ConnectionLossException) {
                    this.jtwatcher.close();
                    this.jtwatcher = null;
                    LOG.error((Object)("Retrying...Fetching new Zookeeper locations from CLDB.  Attempt #" + ++attempts));
                    try {
                        if (attempts * 2 > 30) {
                            Thread.currentThread();
                            Thread.sleep(30000L);
                            continue;
                        }
                        Thread.currentThread();
                        Thread.sleep(attempts * 2 * 1000);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                throw new IOException("Failed to get Zookeeper information for cluster " + this.getClusterName());
            }
        }
        if (jobTrackerAddrs[0] == null) {
            zkConnectString = this.jtwatcher.getZKString();
            this.jtwatcher.close();
            this.jtwatcher = null;
            throw new IOException("Failed to get jobtracker location from Zookeeper at " + zkConnectString + " for cluster " + this.getClusterName());
        }
        return jobTrackerAddrs;
    }

    public byte[] scanKV(String name, byte[] start, byte[] end, int maxkeys, MapRConstants.ErrorValue err) {
        return this.scanKV(this.clntPtr, name, start, end, maxkeys, err);
    }

    public Fileserver.KvstoreLookupResponse lookupKV(String kvPath, Fileserver.KvStoreKey key, MapRConstants.ErrorValue err) throws IOException {
        byte[] reply = this.lookupkv(this.clntPtr, kvPath, key.toByteArray(), err);
        if (reply == null) {
            throw new IOException("Reply to lookup on file " + kvPath);
        }
        return Fileserver.KvstoreLookupResponse.parseFrom(reply);
    }

    public Fileserver.KvstoreScanResponse scanKVGivenFid(Common.FidMsg kvFid, Fileserver.KvStoreKey stKey, Fileserver.KvStoreKey enKey, MapRConstants.ErrorValue err) throws IOException {
        byte[] reply;
        byte[] end = null;
        if (end != null) {
            end = enKey.toByteArray();
        }
        if ((reply = this.scankvgivenfid(this.clntPtr, kvFid.toByteArray(), stKey.toByteArray(), end, err)) == null) {
            throw new IOException("Reply to scan of file is null.");
        }
        return Fileserver.KvstoreScanResponse.parseFrom(reply);
    }

    public Inode openTable(String name, MapRConstants.ErrorValue err, MapRHTable table, MapRUserInfo userInfo) throws IOException {
        long filePtr = this.opentable(this.clntPtr, name, err, userInfo);
        if (filePtr == 0L) {
            if (err.error < 0) {
                err.error = -err.error;
            }
            switch (err.error) {
                case 136: {
                    return null;
                }
                case 2: {
                    throw new FileNotFoundException(name);
                }
            }
            throw new IOException("Open failed for table: " + name + ", error: " + Errno.toString(err.error) + " (" + err.error + ")");
        }
        return new Inode(this.clntPtr, filePtr, name, table, LoggerProxy.InodeLogger, userInfo);
    }

    public String createTable(String name, String user, Dbserver.TableAttr attr, Dbserver.TableAces aces, int mode, byte[][] splitKeys, boolean needServerInfo, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        return this.createtable(this.clntPtr, name, user, attr.toByteArray(), aces.toByteArray(), mode, splitKeys, needServerInfo, err, userInfo);
    }

    public Dbserver.TabletLookupResponse getTablets(String tablePath, byte[] stKey, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        byte[] reply = this.gettablets(this.clntPtr, tablePath, stKey, err, userInfo);
        if (reply == null) {
            throw new IOException("Reply to get tablets on table: " + tablePath + " is null.");
        }
        Dbserver.TabletLookupResponse lookupResp = Dbserver.TabletLookupResponse.parseFrom(reply);
        return lookupResp;
    }

    public void createColumnFamily(String tablePath, String name, Dbserver.ColumnFamilyAttr schFamily, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        this.createcolumnfamily(this.clntPtr, tablePath, name, schFamily.toByteArray(), err, userInfo);
    }

    public void modifyColumnFamily(String tablePath, String name, Dbserver.ColumnFamilyAttr schFamily, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        this.modifycolumnfamily(this.clntPtr, tablePath, name, schFamily.toByteArray(), err, userInfo);
    }

    public void deleteColumnFamily(String tablePath, String name, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        this.deletecolumnfamily(this.clntPtr, tablePath, name, err, userInfo);
    }

    public List<Dbserver.ColumnFamilyAttr> listColumnFamily(String tablePath, boolean wantAces, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        byte[] reply = this.listcolumnfamily(this.clntPtr, tablePath, wantAces, err, userInfo);
        if (reply == null) {
            throw new IOException("Reply to list columnfamily on table: " + tablePath + " is null.");
        }
        Dbserver.ColumnFamilyScanResponse scanResp = Dbserver.ColumnFamilyScanResponse.parseFrom(reply);
        return scanResp.getCfAttrListList();
    }

    public void modifyTableAttr(String tablePath, Dbserver.TableAttr am, Dbserver.TableAces aces, boolean genUuid, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        this.modifytableattr(this.clntPtr, tablePath, am.toByteArray(), aces.toByteArray(), genUuid, err, userInfo);
    }

    public MapRFileSystem.TableProperties getTableAttr(String tablePath, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        byte[] reply = this.gettableattr(this.clntPtr, tablePath, err, userInfo);
        if (reply == null) {
            throw new IOException("Reply to get attrs on table: " + tablePath + " is null.");
        }
        Dbserver.GetTableSchemaResponse schemaResp = Dbserver.GetTableSchemaResponse.parseFrom(reply);
        byte[] uuid = null;
        if (schemaResp.hasUuid()) {
            uuid = schemaResp.getUuid().toByteArray();
        }
        return new MapRFileSystem.TableProperties(schemaResp.getAttr(), schemaResp.getTableAces(), uuid);
    }

    public void splitTableRegion(String fidstr, boolean ignoreRegionTooSmallError, MapRConstants.ErrorValue err) throws IOException {
        this.splittableregion(this.clntPtr, fidstr, ignoreRegionTooSmallError, err);
    }

    public void packTableRegion(String fidstr, int ctype, MapRConstants.ErrorValue err) throws IOException {
        this.packtableregion(this.clntPtr, fidstr, ctype, err);
    }

    public void mergeTableRegion(String fidstr, MapRConstants.ErrorValue err) throws IOException {
        this.mergetableregion(this.clntPtr, fidstr, err);
    }

    public Dbserver.TabletStatResponse getTabletStat(Common.FidMsg fid, MapRConstants.ErrorValue err) throws IOException {
        String fidStr = MapRFileSystem.fidToString(fid);
        byte[] reply = this.tabletstat(this.clntPtr, fidStr, err);
        if (reply == null) {
            throw new IOException("Reply to get tablet stat for fid: " + fidStr + " is null.");
        }
        return Dbserver.TabletStatResponse.parseFrom(reply);
    }

    public Dbserver.TableReplicaListResponse listTableReplicas(String tablePath, boolean wantStats, boolean refreshNow, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        byte[] reply = this.listtablereplicas(this.clntPtr, tablePath, wantStats, refreshNow, err, userInfo);
        if (reply == null) {
            throw new IOException("Reply to list replicas on table: " + tablePath + " is null.");
        }
        return Dbserver.TableReplicaListResponse.parseFrom(reply);
    }

    public void addTableReplica(String tablePath, Dbserver.TableReplicaDesc replica, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        this.addtablereplica(this.clntPtr, tablePath, replica.toByteArray(), err, userInfo);
    }

    public void editTableReplica(String tablePath, String clusterName, String replicaPath, boolean allowAllCfs, Dbserver.TableReplicaDesc replica, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        this.edittablereplica(this.clntPtr, tablePath, clusterName, replicaPath, allowAllCfs, replica.toByteArray(), err, userInfo);
    }

    public void removeTableReplica(String tablePath, Dbserver.TableReplicaDesc replica, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        this.removetablereplica(this.clntPtr, tablePath, replica.toByteArray(), err, userInfo);
    }

    public void addTableUpstream(String tablePath, Dbserver.TableUpstreamDesc upstream, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        this.addtableupstream(this.clntPtr, tablePath, upstream.toByteArray(), err, userInfo);
    }

    public Dbserver.TableUpstreamListResponse listTableUpstreams(String tablePath, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        byte[] reply = this.listtableupstreams(this.clntPtr, tablePath, err, userInfo);
        if (reply == null) {
            throw new IOException("Reply to list Upstreams on table: " + tablePath + " is null.");
        }
        return Dbserver.TableUpstreamListResponse.parseFrom(reply);
    }

    public void removeTableUpstream(String tablePath, Dbserver.TableUpstreamDesc upstream, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        this.removetableupstream(this.clntPtr, tablePath, upstream.toByteArray(), err, userInfo);
    }

    public byte[] getContainerInfo(int[] cids, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return this.getContainerInfo(this.clntPtr, cids, err, userInfo);
    }

    public String getServerForCid(int cid, MapRConstants.ErrorValue err) throws IOException {
        return this.getServerForCid(this.clntPtr, cid, err);
    }
}

