/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRFileSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Progressable;

public class MFS
extends AbstractFileSystem {
    public static final Log LOG = LogFactory.getLog(AbstractFileSystem.class);
    private final MapRFileSystem maprfs = new MapRFileSystem();

    public MFS() throws URISyntaxException, IOException {
        this(null, null);
    }

    public MFS(URI uri, Configuration conf) throws URISyntaxException, IOException {
        super(uri, uri.getScheme(), false, uri.getPort());
        this.maprfs.initialize(uri, conf);
        this.maprfs.setStatistics(this.statistics);
    }

    @Override
    public FSDataOutputStream createInternal(Path p, EnumSet<CreateFlag> flag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, UnresolvedLinkException, IOException {
        boolean createIfNonExistant = false;
        boolean append = false;
        boolean overwrite = false;
        for (CreateFlag f : flag) {
            if (f == CreateFlag.CREATE) {
                createIfNonExistant = true;
                continue;
            }
            if (f == CreateFlag.APPEND) {
                append = true;
                continue;
            }
            if (f != CreateFlag.OVERWRITE) continue;
            overwrite = true;
        }
        return this.maprfs.create(p, 128, absolutePermission, createIfNonExistant, append, overwrite, bufferSize, replication, blockSize, progress, createParent);
    }

    @Override
    public void checkPath(Path path) {
        String pathStr = path.toString().substring(path.toString().indexOf(47));
        super.checkPath(new Path(new Path(this.maprfs.getUri()), pathStr));
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return this.maprfs.delete(f, recursive);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(Path p, long start, long len) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        FileStatus file = this.maprfs.getFileStatus(p);
        return this.maprfs.getFileBlockLocations(file, start, len);
    }

    @Override
    public FileChecksum getFileChecksum(Path path) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return this.maprfs.getFileChecksum(path);
    }

    @Override
    public FileStatus getFileStatus(Path p) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return this.maprfs.getFileStatus(p);
    }

    @Override
    public FsStatus getFsStatus() throws AccessControlException, FileNotFoundException, IOException {
        return this.maprfs.getStatus();
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        Configuration conf = this.maprfs.getConf();
        return new FsServerDefaults(this.maprfs.getDefaultBlockSize(), conf.getInt("oadd.io.bytes.per.checksum", 512), 65536, this.maprfs.getDefaultReplication(), conf.getInt("oadd.io.file.buffer.size", 4096), false, 0L, DataChecksum.Type.CRC32);
    }

    @Override
    public int getUriDefaultPort() {
        return this.maprfs.getUri().getPort();
    }

    @Override
    public FileStatus[] listStatus(Path p) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return this.maprfs.listStatus(p);
    }

    @Override
    public void mkdir(Path p, FsPermission permission, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, UnresolvedLinkException, IOException {
        Path parent = p.getParent();
        if (parent != null) {
            if (!this.maprfs.exists(parent)) {
                if (!createParent) {
                    throw new FileNotFoundException("Cannot create directory because parent directory not present and createParent is false");
                }
            } else {
                FileStatus parentStatus = this.maprfs.getFileStatus(parent);
                if (!parentStatus.isDirectory()) {
                    throw new ParentNotDirectoryException("Parent " + parent + " is not a directory");
                }
            }
        }
        this.maprfs.mkdirs(p, createParent, permission);
    }

    @Override
    public FSDataInputStream open(Path p, int bufferSize) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return this.maprfs.open(p, bufferSize);
    }

    @Override
    public boolean supportsSymlinks() {
        return true;
    }

    @Override
    public void createSymlink(Path target, Path link, boolean createParent) throws IOException, UnresolvedLinkException {
        this.maprfs.createSymlink(target, link, createParent);
    }

    @Override
    public void renameInternal(Path src, Path dst) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnresolvedLinkException, IOException {
        this.maprfs.rename(src, dst);
    }

    @Override
    public void setOwner(Path p, String user, String group) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        this.maprfs.setOwner(p, user, group);
    }

    @Override
    public void setPermission(Path p, FsPermission permission) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        this.maprfs.setPermission(p, permission);
    }

    @Override
    public boolean setReplication(Path p, short replication) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return this.maprfs.setReplication(p, replication);
    }

    @Override
    public void setTimes(Path p, long mtime, long atime) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        this.maprfs.setTimes(p, mtime, atime);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) throws AccessControlException, IOException {
        this.maprfs.setVerifyChecksum(verifyChecksum);
    }
}

