/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.proto.Common;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import oadd.com.google.protobuf.InvalidProtocolBufferException;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import oadd.org.apache.zookeeper.KeeperException;
import oadd.org.apache.zookeeper.WatchedEvent;
import oadd.org.apache.zookeeper.Watcher;
import oadd.org.apache.zookeeper.ZooKeeper;
import oadd.org.apache.zookeeper.data.Stat;
import org.apache.hadoop.net.NetUtils;

public class JobTrackerWatcher
implements Watcher {
    public static final String SERVICE_MASTER_NODE = "$master$";
    public static final Log LOG = LogFactory.getLog(JobTrackerWatcher.class);
    public static final int ZK_CONNECTION_TIMEOUT = 30000;
    public static String JT_ZK_SERVICE_PATH = "/services/jobtracker/$master$";
    public static String JT_ZK_SERVICE_PATH_OLD = "/services/jobtracker/master";
    private static final int TIMEOUT = 30000;
    private ZooKeeper s_zk;
    private InetSocketAddress jobTrackAddr;
    private volatile boolean isConnected = false;
    private CountDownLatch lock = new CountDownLatch(1);
    private String zkConnectString;
    private int refCount = 1;

    public JobTrackerWatcher(String zkConnectString) {
        this.zkConnectString = zkConnectString;
        this.isConnected = false;
        this.jobTrackAddr = null;
    }

    public String getZKString() {
        return this.zkConnectString;
    }

    public synchronized void incCount() {
        ++this.refCount;
    }

    public synchronized void decCount() {
        --this.refCount;
    }

    public synchronized boolean isZeroReference() {
        return this.refCount == 0;
    }

    public synchronized boolean connect() {
        if (this.zkConnectString == null) {
            LOG.error((Object)"Zookeeper credentials were not specified. Client will not be able to reconnect on Jobtracker Failover.");
            return false;
        }
        try {
            this.s_zk = new ZooKeeper(this.zkConnectString, 30000, this);
            while (!this.lock.await(30000L, TimeUnit.MILLISECONDS)) {
                LOG.error((Object)("Could not connect to ZK within: 30000 ms. Check if ZK connection defined correctly: " + this.zkConnectString + ". No data from ZK will be returned."));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Connected to ZK: " + this.zkConnectString));
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Could not create ZooKeeper instance.", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.error((Object)"InterruptedException during wait for ZK to be connected");
            return false;
        }
        return true;
    }

    public synchronized boolean reconnect() {
        this.close();
        return this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.s_zk == null) {
            return;
        }
        try {
            this.s_zk.close();
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Unable to close ZooKeeper connection", (Throwable)e);
        }
        finally {
            this.s_zk = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress findJobTrackerAddr() throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException, KeeperException.ConnectionLossException {
        int attempts = 0;
        boolean isInfoEnabled = LOG.isInfoEnabled();
        while (true) {
            try {
                byte[] byteData;
                Common.ServiceData jtData;
                String jtMasterNode = JT_ZK_SERVICE_PATH;
                Stat stat = this.s_zk.exists(JT_ZK_SERVICE_PATH, false);
                if (stat == null) {
                    stat = this.s_zk.exists(JT_ZK_SERVICE_PATH_OLD, false);
                    jtMasterNode = JT_ZK_SERVICE_PATH_OLD;
                }
                if ((jtData = Common.ServiceData.parseFrom(byteData = this.s_zk.getData(jtMasterNode, false, stat))).getIsRunning() && jtData.hasHost() && jtData.hasPort()) {
                    JobTrackerWatcher jobTrackerWatcher = this;
                    synchronized (jobTrackerWatcher) {
                        String jtAddress = jtData.getHost() + ":" + jtData.getPort();
                        this.jobTrackAddr = NetUtils.createSocketAddr(jtAddress);
                        if (isInfoEnabled) {
                            LOG.info((Object)("Current running JobTracker is: " + this.jobTrackAddr));
                        }
                        return this.jobTrackAddr;
                    }
                }
            }
            catch (InterruptedException ie) {
                LOG.error((Object)"Interrupted Exception while waiting for ZooKeeper service to send jobtracker address", (Throwable)ie);
                return null;
            }
            catch (KeeperException.NoNodeException knne) {
                if (isInfoEnabled) {
                    LOG.info((Object)("findJobTrackerAddr: NoNodeFound, Retrying... Current ZooKeeper Server: " + this.getZKString()));
                }
            }
            catch (KeeperException.OperationTimeoutException kto) {
                if (isInfoEnabled) {
                    LOG.info((Object)("findJobTrackerAddr: TimedOut, Retrying... Current ZooKeeper Server: " + this.getZKString()));
                }
            }
            catch (KeeperException.SessionExpiredException kse) {
                if (isInfoEnabled) {
                    LOG.info((Object)("findJobTrackerAddr: SessionExpired, Reconnecting... Current ZooKeeper Server: " + this.getZKString()));
                }
                throw kse;
            }
            catch (KeeperException.SessionMovedException ksm) {
                if (isInfoEnabled) {
                    LOG.info((Object)("findJobTrackerAddr: SessionMoved, Reconnecting... Current ZooKeeper Server: " + this.getZKString()));
                }
                throw ksm;
            }
            catch (KeeperException.ConnectionLossException kcle) {
                if (isInfoEnabled) {
                    LOG.info((Object)("findJobTrackerAddr: ConnectionLost, Reconnecting... Current ZooKeeper Server: " + this.getZKString()));
                }
                throw kcle;
            }
            catch (KeeperException e) {
                LOG.error((Object)("While trying to get JobTracker address Zookeeper received " + e + ". Can not reconnect to zookeeper service for " + this.getZKString() + ". Bailing out."));
                return null;
            }
            catch (InvalidProtocolBufferException e) {
                LOG.info((Object)("Not a valid ProtoBuf in JobTrackerWatcher.findJobTrackerAddr(): " + this.getZKString()));
            }
            if (isInfoEnabled) {
                LOG.info((Object)("Retrying to connect ZooKeeper Attempt# " + attempts + " Current ZooKeeper Server: " + this.getZKString()));
            }
            ++attempts;
            try {
                if (attempts * 2 > 30) {
                    Thread.sleep(30000L);
                    continue;
                }
                Thread.sleep(attempts * 2 * 1000);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    @Override
    public void process(WatchedEvent event) {
        String path = event.getPath();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Process path: " + path + ". Event state: " + (Object)((Object)event.getState()) + ". Event type: " + (Object)((Object)event.getType())));
        }
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            this.lock.countDown();
        }
    }
}

