/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRClientImpl;
import com.mapr.fs.MapRFsInStream;
import com.mapr.fs.MapRFsOutStream;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.PageList;
import com.mapr.fs.StaleFileException;
import com.mapr.fs.jni.Errno;
import com.mapr.fs.jni.InodeAttributes;
import com.mapr.fs.jni.JNILoggerProxy;
import com.mapr.fs.jni.MapRClient;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.jni.MapRGet;
import com.mapr.fs.jni.MapRIncrement;
import com.mapr.fs.jni.MapRPut;
import com.mapr.fs.jni.MapRResult;
import com.mapr.fs.jni.MapRScan;
import com.mapr.fs.jni.MapRTableTools;
import com.mapr.fs.jni.MapRUserInfo;
import com.mapr.fs.jni.Page;
import com.mapr.fs.jni.ParsedRow;
import com.mapr.fs.jni.SFid;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.fs.PathId;
import org.apache.hadoop.security.AccessControlException;

public final class Inode {
    private JNILoggerProxy LOG;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int MaxAttrAttempts = 5;
    static final int DirtyThreshold = 16;
    static final int NUM_SCAN_CACHE_INIT = 100;
    static final int NUM_SCAN_CACHE = 1024;
    static final int SCAN_THRESH = 4;
    public static List<Closeable> allInStreams = new List();
    public static List<Closeable> allOutStreams = new List();
    public static List<MapRHTable> allTables = new List();
    static CmpPageId pageCmp_ = new CmpPageId();
    static Lock wpoolLock_ = new ReentrantLock();
    static PageList wpoolList_ = new PageList(wpoolLock_);
    Page[] dirtyPages_;
    int dirtyPageCount_;
    int totalDirtyPages_;
    ListElem<Closeable> outStreamElem_;
    ListElem<MapRHTable> htableElem_;
    boolean writeClosed_;
    boolean tableClosed_;
    boolean isNotRegularFile_ = false;
    ICache cache_;
    Lock cacheLock_;
    PageList lru_;
    Page[] allPages_;
    HashMap<Long, ScanCacheElem> scan_cache_;
    Lock scan_cache_Lock_;
    ConcurrentLinkedQueue<ScanCacheElem> sce_freelist_;
    long fileP;
    long clusterP;
    String filename_;
    volatile InodeAttributes attrs_;
    private int err_;
    ListElem<Closeable> inStreamElem_;
    MapRUserInfo userInfo_;
    private volatile boolean isStale_;
    private volatile boolean closed_;

    ScanCacheElem getScanCacheElem() {
        ScanCacheElem sce = this.sce_freelist_.poll();
        if (sce == null) {
            ArrayDeque<MapRResult> list = new ArrayDeque<MapRResult>(1024);
            sce = new ScanCacheElem(list);
        }
        return sce;
    }

    public static void allocWriteBuffers(int numPages) {
    }

    private void commonInit(long clusterPtr, long filePtr, String filename, InodeAttributes attr, JNILoggerProxy logger, MapRUserInfo userInfo) throws IOException {
        this.LOG = logger;
        this.clusterP = clusterPtr;
        this.fileP = filePtr;
        this.filename_ = filename;
        this.allPages_ = null;
        this.lru_ = null;
        this.cache_ = null;
        this.cacheLock_ = null;
        this.dirtyPageCount_ = 0;
        this.totalDirtyPages_ = 0;
        this.dirtyPages_ = null;
        this.inStreamElem_ = null;
        this.outStreamElem_ = null;
        this.htableElem_ = null;
        this.err_ = 0;
        this.writeClosed_ = true;
        this.tableClosed_ = true;
        this.userInfo_ = userInfo;
        this.isStale_ = false;
        this.scan_cache_ = null;
        this.scan_cache_Lock_ = new ReentrantLock();
        this.sce_freelist_ = null;
        if (attr != null) {
            this.attrs_ = attr;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug(">Inode Open file: " + this.filename_ + ", size: " + this.attrs_.filesize + ", chunkSize: " + this.attrs_.chunksize + ", fid: " + this.attrs_.toString());
            }
        } else {
            this.attrs_ = new InodeAttributes();
            if (this.fileP != 0L) {
                int attempts = 0;
                while (attempts < 5) {
                    long size = MapRClient.getAttrs(this.clusterP, this.fileP, this.attrs_);
                    if (this.isNotRegularFile_) {
                        if (this.LOG.isDebugEnabled()) {
                            this.LOG.debug(">Inode GetAttr: table: " + this.filename_ + ", size: " + this.attrs_.filesize + ", chunksize: " + this.attrs_.chunksize + ", fid: " + this.attrs_.toString());
                        }
                    } else {
                        if (size < 0L) {
                            throw new IOException(">Inode GetAttr: Failed to get attributes for file " + this.filename_ + ", size: " + size + ", chunkSize: " + this.attrs_.chunksize + ", fid: " + this.attrs_.toString());
                        }
                        if (size != this.attrs_.filesize) {
                            this.LOG.error(">Inode GetAttr: attempt#: " + attempts + ", file: " + this.filename_ + ", incorrect size: " + this.attrs_.filesize + ", expected: " + size + ", chunksize: " + this.attrs_.chunksize + ", fid: " + this.attrs_.toString());
                            if (++attempts != 5) continue;
                            throw new IOException(">Inode GetAttr: Failed to get attributes for file " + this.filename_ + ", after " + 5 + " attempts");
                        }
                        if (this.LOG.isDebugEnabled()) {
                            this.LOG.debug(">Inode GetAttr: file: " + this.filename_ + ", size: " + this.attrs_.filesize + ", chunksize: " + this.attrs_.chunksize + ", fid: " + this.attrs_.toString());
                        }
                    }
                    break;
                }
            } else if (this.LOG.isDebugEnabled()) {
                this.LOG.debug(">Inode Open with no getattr for file: " + this.filename_);
            }
        }
        this.closed_ = false;
    }

    public String getFidStr() {
        return this.attrs_.toString();
    }

    public long[] getFidServers() {
        return MapRClient.getFidServers(this.clusterP, this.attrs_.cid);
    }

    public long getChunkSize() {
        return this.attrs_.chunksize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Inode(long clusterPtr, long filePtr, String filename, MapRHTable htable, JNILoggerProxy logger, MapRUserInfo userInfo) throws IOException {
        this.isNotRegularFile_ = true;
        this.commonInit(clusterPtr, filePtr, filename, null, logger, userInfo);
        this.htableElem_ = new ListElem<MapRHTable>(htable);
        List<MapRHTable> list = allTables;
        synchronized (list) {
            allTables.add(this.htableElem_);
        }
        this.tableClosed_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Inode(long clusterPtr, long filePtr, String filename, MapRFsOutStream outStream, JNILoggerProxy logger, MapRUserInfo userInfo) throws IOException {
        this.commonInit(clusterPtr, filePtr, filename, null, logger, userInfo);
        this.dirtyPages_ = new Page[16];
        this.writeClosed_ = false;
        this.outStreamElem_ = new ListElem<MapRFsOutStream>(outStream);
        List<Closeable> list = allOutStreams;
        synchronized (list) {
            allOutStreams.add(this.outStreamElem_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Inode(long clusterPtr, long filePtr, String filename, MapRFsInStream inStream, InodeAttributes attr, JNILoggerProxy logger, MapRUserInfo userInfo) throws IOException {
        this.commonInit(clusterPtr, filePtr, filename, attr, logger, userInfo);
        int numPages = inStream.getCacheSize(this.attrs_);
        boolean allocateFromShm = false;
        if (!this.attrs_.compress) {
            int numRAPages = MapRClient.getNumRAPages();
            int availRAPages = MapRClient.getNumAvailRAPages();
            if (numPages <= availRAPages) {
                allocateFromShm = true;
            } else if (numRAPages != 0) {
                this.LOG.warn("Short of shared memory for client ReadAhead, please increase ReadAhead share (using env variable MAPR_CLIENT_RASHARE) to get better performance for read operations.");
            }
        }
        this.cache_ = new ICache(numPages);
        this.cacheLock_ = new ReentrantLock();
        this.lru_ = new PageList(this.cacheLock_);
        this.allPages_ = new Page[numPages];
        this.cacheLock_.lock();
        for (int i = 0; i < this.allPages_.length; ++i) {
            Page p = new Page(this.cacheLock_, allocateFromShm, 8192, true);
            this.lru_.push(p);
            this.allPages_[i] = p;
        }
        this.cacheLock_.unlock();
        this.inStreamElem_ = new ListElem<MapRFsInStream>(inStream);
        List<Closeable> list = allInStreams;
        synchronized (list) {
            allInStreams.add(this.inStreamElem_);
        }
    }

    public Inode(long clusterPtr, long filePtr, String filename, MapRFsInStream inStream, JNILoggerProxy logger, MapRUserInfo userInfo) throws IOException {
        this(clusterPtr, filePtr, filename, inStream, null, logger, userInfo);
    }

    public InodeAttributes attrs() {
        return this.attrs_;
    }

    public String toString() {
        return this.attrs_.toString() + " " + this.filename();
    }

    void pr(String s) {
        this.LOG.error(this + s);
    }

    long lastOffsetInPage(long pageId) {
        return (pageId << 13) + 8192L;
    }

    public boolean isStale() {
        return this.isStale_;
    }

    public long eof() {
        return this.attrs_.filesize;
    }

    public boolean haveEof() {
        return true;
    }

    public String filename() {
        return this.filename_ != null ? this.filename_ : "";
    }

    void markFailed(int err) {
        this.err_ = err;
        this.LOG.error("Marking failure for: " + this.filename() + ", error: " + Errno.toString(this.err_));
    }

    void throwIfFailed() throws IOException {
        if (this.err_ != 0) {
            this.LOG.error("Throwing exception for: " + this.filename() + ", error: " + Errno.toString(this.err_));
            throw new IOException(this.toString() + " (" + Errno.toString(Math.abs(this.err_)) + ")");
        }
    }

    void printstack() {
        StackTraceElement[] se = Thread.currentThread().getStackTrace();
        for (int i = 0; i < se.length; ++i) {
            this.LOG.error("\t " + se[i]);
        }
    }

    void printstack(Exception e) {
        StackTraceElement[] se = e.getStackTrace();
        for (int i = 0; i < se.length; ++i) {
            this.LOG.error("\t " + se[i]);
        }
    }

    MapRFsOutStream nextStream() {
        return this.outStreamElem_.next != null ? (MapRFsOutStream)this.outStreamElem_.next.elem : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page allocatePage(long startPos) throws IOException {
        this.throwIfFailed();
        long pageId = startPos >> 13;
        Page p = null;
        wpoolLock_.lock();
        if (!wpoolList_.empty()) {
            p = wpoolList_.popOldest();
        }
        wpoolLock_.unlock();
        if (p == null) {
            p = new Page(wpoolLock_, false, 8192, false);
        }
        Inode inode = this;
        synchronized (inode) {
            ++this.totalDirtyPages_;
        }
        p.invalidate();
        p.pageId = pageId;
        p.iattr = this.attrs_;
        p.ref = 1;
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushPages(Page[] parray, boolean flushJniBuffers, long flushToPos) throws IOException {
        int i;
        boolean needsSorting = false;
        long prevPageId = -1L;
        for (i = 0; i < parray.length; ++i) {
            Page p = parray[i];
            if (prevPageId != -1L) {
                needsSorting = prevPageId > p.pageId;
            }
            prevPageId = p.pageId;
        }
        if (needsSorting) {
            Arrays.sort(parray, pageCmp_);
        }
        int ret = 0;
        try {
            ret = MapRClient.writeRPC(this.clusterP, this.fileP, parray, flushToPos, flushJniBuffers, this.userInfo_);
        }
        finally {
            if (ret < 0) {
                this.LOG.error("Write failed for file: " + this.filename() + ", error: " + Errno.toString(-ret));
                this.markFailed(-ret);
            }
            wpoolLock_.lock();
            for (i = 0; i < parray.length; ++i) {
                wpoolList_.push(parray[i]);
            }
            wpoolLock_.unlock();
            Inode inode = this;
            synchronized (inode) {
                this.totalDirtyPages_ -= parray.length;
                this.notify();
            }
        }
        this.throwIfFailed();
    }

    void flushJniBuffers(long flushToPos) throws IOException {
        int ret = MapRClient.flushJniBuffers(this.clusterP, this.fileP, flushToPos);
        if (ret < 0) {
            this.LOG.error("Flush failed for file: " + this.filename() + ", error: " + Errno.toString(-ret));
            this.markFailed(-ret);
        }
        this.throwIfFailed();
    }

    Page[] copyDirtyPages() {
        Page[] parray = new Page[this.dirtyPageCount_];
        for (int i = 0; i < parray.length; ++i) {
            Page p = parray[i] = this.dirtyPages_[i];
            this.dirtyPages_[i] = null;
            p.dirty = false;
        }
        return parray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDirty(Page p) throws IOException {
        if (this.err_ != 0) {
            wpoolLock_.lock();
            wpoolList_.push(p);
            wpoolLock_.unlock();
            Inode inode = this;
            synchronized (inode) {
                --this.totalDirtyPages_;
                this.notify();
            }
            this.throwIfFailed();
        }
        Page[] dirtyList = null;
        if (p.ref <= 0) {
            this.pr(":releaseDirty() Page has low refcount, pageId: " + p.pageId + ", dirty: " + p.dirty + ", ref: " + p.ref);
            this.printstack();
        } else {
            --p.ref;
        }
        if (!p.dirty) {
            p.dirty = true;
            Inode inode = this;
            synchronized (inode) {
                this.dirtyPages_[this.dirtyPageCount_++] = p;
                if (this.dirtyPageCount_ >= 16) {
                    dirtyList = this.copyDirtyPages();
                    this.dirtyPageCount_ = 0;
                }
            }
        }
        if (dirtyList != null) {
            this.flushPages(dirtyList, false, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncInternal(boolean waitForFlush, long flushToPos) throws IOException {
        Page[] pp = null;
        Inode inode = this;
        synchronized (inode) {
            if (this.dirtyPageCount_ > 0) {
                pp = this.copyDirtyPages();
                this.dirtyPageCount_ = 0;
            }
        }
        if (pp != null) {
            this.flushPages(pp, waitForFlush, flushToPos);
        } else if (waitForFlush) {
            this.flushJniBuffers(flushToPos);
        }
    }

    public void syncUpto(long pos) throws IOException {
        this.syncInternal(true, pos);
    }

    void sync() throws IOException {
        this.syncInternal(true, 0L);
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeWrite() throws IOException {
        if (!this.writeClosed_) {
            try {
                this.sync();
            }
            finally {
                this.removeFromOutStreams();
                this.writeClosed_ = true;
            }
        }
    }

    void returnPage(Page p) {
        if (p.ref <= 0) {
            this.pr(":returnPage() Page has low refcount, ref: " + p.ref + ", p.attr: " + p.iattr);
            this.printstack();
        }
        if (--p.ref == 0) {
            if (p.valid()) {
                this.lru_.push(p);
            } else {
                this.lru_.pushOldest(p);
            }
        }
    }

    public void returnPageToCache(Page p) {
        this.cacheLock_.lock();
        this.returnPage(p);
        this.cacheLock_.unlock();
    }

    public void discardPage(Page p) {
        this.cacheLock_.lock();
        if (p.ref <= 0) {
            this.pr(":discardPage()  Page has low refcount, ref: " + p.ref + ", p.attr " + p.iattr);
            this.printstack();
        }
        if (--p.ref == 0) {
            this.lru_.pushOldest(p);
        }
        this.cacheLock_.unlock();
    }

    Page createNewPage(long pageId) {
        Page p = this.lru_.popOldest();
        if (p.valid()) {
            this.cache_.remove(p);
            p.invalidate();
        }
        p.validStart = 0;
        p.validLen = 8192;
        p.pageId = pageId;
        p.iattr = this.attrs_;
        this.cache_.insert(p);
        p.ref = 1;
        return p;
    }

    public Page[] allocateReadaheadPages(long startPos, int bytes) {
        Page p;
        Page[] pagesToFill = null;
        long pageId = startPos >> 13;
        int numPages = (bytes + 8192 - 1) / 8192;
        this.cacheLock_.lock();
        for (int i = 0; i < numPages && (p = this.cache_.lookup(this.attrs_, pageId)) == null && !this.lru_.empty(); ++i) {
            p = this.createNewPage(pageId);
            p.setFilling();
            if (pagesToFill == null) {
                pagesToFill = new Page[numPages];
            }
            pagesToFill[i] = p;
            ++pageId;
        }
        this.cacheLock_.unlock();
        return pagesToFill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readPages(Page[] pagesToFill, long intendReadTillOffset) {
        int bytesRecd = -1;
        try {
            bytesRecd = MapRClient.readRPC(this.clusterP, this.fileP, pagesToFill, intendReadTillOffset, null, null, null, null, null, null);
        }
        finally {
            if (bytesRecd == Integer.MAX_VALUE) {
                this.markFailed(5);
                bytesRecd = 0;
            } else if (bytesRecd < 0) {
                bytesRecd = -bytesRecd;
                --bytesRecd;
            }
        }
        return bytesRecd;
    }

    public void cleanupAfterRead(Page[] pagesToFill, int bytesRecd) {
        Page p;
        int i;
        boolean eofPresent = false;
        if (bytesRecd == Integer.MAX_VALUE) {
            this.markFailed(5);
            bytesRecd = 0;
        } else if (bytesRecd < 0) {
            bytesRecd = -bytesRecd;
            --bytesRecd;
            eofPresent = true;
        } else if (bytesRecd < 8192 * pagesToFill.length) {
            eofPresent = true;
        }
        this.cacheLock_.lock();
        for (i = 0; i < pagesToFill.length && (p = pagesToFill[i]) != null; ++i) {
            if (bytesRecd > 0) {
                p.setValid();
                if (bytesRecd < 8192) {
                    p.validStart = 0;
                    p.validLen = bytesRecd;
                    bytesRecd = 0;
                    eofPresent = false;
                } else {
                    p.validStart = 0;
                    p.validLen = 8192;
                    bytesRecd -= 8192;
                }
            } else {
                this.cache_.remove(p);
                p.invalidate();
            }
            p.cv.signal();
        }
        for (i = 0; i < pagesToFill.length && pagesToFill[i] != null; ++i) {
            this.returnPage(pagesToFill[i]);
        }
        this.cacheLock_.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillPages(Page[] pagesToFill, SFid sfid, PathId pfid, String file, long intendReadTillOffset) throws IOException {
        int bytesRecd = 0;
        try {
            if (pfid != null) {
                MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
                bytesRecd = MapRClient.readRPC(this.clusterP, this.fileP, pagesToFill, intendReadTillOffset, sfid, pfid.getFid(), pfid.getIPs(), file, err, this.attrs_);
                this.fileP = err.fileptr;
            } else {
                bytesRecd = MapRClient.readRPC(this.clusterP, this.fileP, pagesToFill, intendReadTillOffset, sfid, null, null, null, null, null);
            }
        }
        finally {
            this.cleanupAfterRead(pagesToFill, bytesRecd);
        }
        if (pfid != null && this.fileP == 0L) {
            throw new IOException("openFid2: Failed to open inode for pfid: " + pfid.toString() + ", file: " + (file != null ? file : ""));
        }
        this.throwIfFailed();
    }

    public Page getDataIntoCache(long startPos, int length, long intendReadTillOffset, SFid sfid, PathId pfid, String file) throws IOException {
        Page p;
        Page resultPage = null;
        long endPos = startPos + (long)length;
        long pageId = startPos >> 13;
        this.throwIfFailed();
        ArrayList<Page> pagesToFill = null;
        ArrayList<Page> pagesToWaitOn = null;
        this.cacheLock_.lock();
        while (true) {
            if (pfid == null && (p = this.cache_.lookup(this.attrs_, pageId)) != null) {
                this.lru_.pop(p);
                ++p.ref;
                if (resultPage == null) {
                    resultPage = p;
                    ++p.ref;
                }
                if (p.filling()) {
                    if (pagesToWaitOn == null) {
                        pagesToWaitOn = new ArrayList<Page>();
                    }
                    pagesToWaitOn.add(p);
                } else {
                    this.returnPage(p);
                }
            } else {
                if (this.lru_.empty()) {
                    this.lru_.waitTillNotEmpty();
                    continue;
                }
                p = this.createNewPage(pageId);
                p.setFilling();
                if (pagesToFill == null) {
                    pagesToFill = new ArrayList<Page>();
                }
                pagesToFill.add(p);
                if (resultPage == null) {
                    resultPage = p;
                    ++p.ref;
                }
            }
            if (this.lastOffsetInPage(pageId) >= endPos) break;
            ++pageId;
        }
        if (resultPage == null) {
            this.pr(": resultPage null, " + this.attrs_ + ", startPos " + startPos + ", len " + length);
            this.printstack();
        } else if (resultPage.ref <= 0) {
            this.pr(": resultPage bad ref " + resultPage.pageId + ", " + this.attrs_ + ", startPos " + startPos + ", len " + length);
            this.printstack();
        }
        this.cacheLock_.unlock();
        if (pagesToFill != null) {
            Page[] pp = new Page[pagesToFill.size()];
            pp = pagesToFill.toArray(pp);
            this.fillPages(pp, sfid, pfid, file, intendReadTillOffset);
        }
        if (pagesToWaitOn != null) {
            for (int i = 0; i < pagesToWaitOn.size(); ++i) {
                p = (Page)pagesToWaitOn.get(i);
                this.cacheLock_.lock();
                while (p.filling()) {
                    p.cv.awaitUninterruptibly();
                }
                this.returnPage(p);
                this.cacheLock_.unlock();
            }
        }
        if (resultPage != null && !resultPage.invalid()) {
            this.cacheLock_.lock();
            if (resultPage.ref <= 0) {
                this.pr(":getDataIntoCache() Page has low refcount in resultPage, page: " + resultPage);
                this.printstack();
                this.cacheLock_.lock();
            }
            this.cacheLock_.unlock();
            return resultPage;
        }
        this.pr(" Returning bad page to cache page: " + resultPage);
        this.returnPageToCache(resultPage);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromInStreams() {
        if (this.inStreamElem_ != null) {
            List<Closeable> list = allInStreams;
            synchronized (list) {
                if (this.inStreamElem_ != null) {
                    allInStreams.remove(this.inStreamElem_);
                }
                this.inStreamElem_ = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromOutStreams() {
        if (this.outStreamElem_ != null) {
            List<Closeable> list = allOutStreams;
            synchronized (list) {
                if (this.outStreamElem_ != null) {
                    allOutStreams.remove(this.outStreamElem_);
                }
                this.outStreamElem_ = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromTables() {
        if (this.htableElem_ != null) {
            List<MapRHTable> list = allTables;
            synchronized (list) {
                if (this.htableElem_ != null) {
                    allTables.remove(this.htableElem_);
                }
                this.htableElem_ = null;
            }
        }
    }

    public void adviseFile(int type, long offset, long count) throws IOException {
        int ret = MapRClient.adviseFile(this.clusterP, this.fileP, type, offset, count);
        if (ret < 0) {
            this.LOG.error("AdviseFile failed for file: " + this.filename() + ", offset = " + offset + ", count = " + count + ", error: " + Errno.toString(-ret));
            throw new IOException("AdviseFile failed for file: " + this.filename() + ", offset: " + offset + ", count: " + count + ", error: " + Errno.toString(-ret));
        }
    }

    public synchronized void close() throws IOException {
        if (!this.closed_) {
            this.closeWrite();
            this.closeRead();
            this.closeTable();
            if (this.fileP != 0L) {
                int err = 0;
                err = MapRClient.closeFile(this.clusterP, this.fileP);
                this.checkError(err);
            }
            this.closed_ = true;
        }
    }

    public void flushPuts() throws IOException {
        int err = MapRTableTools.FlushPuts(this.clusterP, this.fileP);
        this.checkError(err);
    }

    synchronized void closeTable() {
        if (!this.tableClosed_) {
            this.removeFromTables();
            this.tableClosed_ = true;
        }
    }

    void closeRead() {
        this.removeFromInStreams();
        if (this.allPages_ != null) {
            for (int i = 0; i < this.allPages_.length; ++i) {
                this.allPages_[i].releaseStorage();
            }
            this.allPages_ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        Closeable i = null;
        do {
            List<Closeable> list = allInStreams;
            synchronized (list) {
                i = allInStreams.first();
            }
            if (i == null) continue;
            try {
                i.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        } while (i != null);
        Closeable o = null;
        do {
            List<Closeable> list = allOutStreams;
            synchronized (list) {
                o = allOutStreams.first();
            }
            if (o == null) continue;
            try {
                o.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        } while (o != null);
        MapRHTable t = null;
        do {
            List<MapRHTable> list = allTables;
            synchronized (list) {
                t = allTables.first();
            }
            if (t == null) continue;
            try {
                t.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        } while (t != null);
    }

    public void put(MapRPut[] mputs) throws IOException {
        long diff;
        long start = 0L;
        long end = 0L;
        int thresh = MapRClientImpl.getSlowOpsThreshold();
        if (thresh > 0) {
            start = System.currentTimeMillis();
        }
        int err = MapRTableTools.PutOrDeleteRPC(this.clusterP, this.fileP, mputs, false, false, false);
        this.checkError(err);
        if (thresh > 0 && (int)(diff = (end = System.currentTimeMillis()) - start) >= thresh) {
            System.err.println("put() op for table " + this.filename() + " took " + diff + " ms");
        }
    }

    public void syncPut(MapRPut[] mputs, boolean shouldBlock, boolean rowMut) throws IOException {
        long diff;
        long start = 0L;
        long end = 0L;
        int thresh = MapRClientImpl.getSlowOpsThreshold();
        if (thresh > 0) {
            start = System.currentTimeMillis();
        }
        int err = MapRTableTools.PutOrDeleteRPC(this.clusterP, this.fileP, mputs, shouldBlock, true, rowMut);
        this.checkError(err);
        if (thresh > 0 && (int)(diff = (end = System.currentTimeMillis()) - start) >= thresh) {
            System.err.println("syncput() op for table " + this.filename() + " took " + diff + " ms");
        }
    }

    public long getBulkLoader(byte[] tableUuidForPuts) throws IOException {
        long id = MapRTableTools.GetBulkLoader(this.clusterP, this.fileP, tableUuidForPuts);
        if (id == 0L) {
            throw new IOException("Failed to create a BulkLoader");
        }
        return id;
    }

    public void bulkLoaderAppend(long bulkLoaderId, MapRPut[] mputs) throws IOException {
        long diff;
        long start = 0L;
        long end = 0L;
        int thresh = MapRClientImpl.getSlowOpsThreshold();
        if (thresh > 0) {
            start = System.currentTimeMillis();
        }
        int err = MapRTableTools.BulkLoaderAppend(this.clusterP, this.fileP, bulkLoaderId, mputs);
        this.checkError(err);
        if (thresh > 0 && (int)(diff = (end = System.currentTimeMillis()) - start) >= thresh) {
            System.err.println("bulkLoaderAppend() for table " + this.filename() + " took " + diff + " ms");
        }
    }

    public void bulkLoaderClose(long bulkLoaderId) throws IOException {
        int err = MapRTableTools.BulkLoaderClose(this.clusterP, this.fileP, bulkLoaderId);
        this.checkError(err);
    }

    public void get(MapRGet[] mgets, boolean shouldFlush) throws IOException {
        long diff;
        long start = 0L;
        long end = 0L;
        int thresh = MapRClientImpl.getSlowOpsThreshold();
        if (thresh > 0) {
            start = System.currentTimeMillis();
        }
        int err = MapRTableTools.GetRPC(this.clusterP, this.fileP, mgets, shouldFlush);
        this.checkError(err);
        ParsedRow prow = new ParsedRow();
        for (MapRGet get : mgets) {
            get.result.DecodeByteBuf(prow);
        }
        if (thresh > 0 && (int)(diff = (end = System.currentTimeMillis()) - start) >= thresh) {
            System.err.println("get() op for table " + this.filename() + " took " + diff + " ms");
        }
    }

    public void freeArena(long arenaAddr) {
        MapRTableTools.FreeArena(this.clusterP, this.fileP, arenaAddr);
    }

    public void addToScanCache(long scannerId, MapRResult[] res, int numSkip, int numGet) {
        if (numSkip >= numGet) {
            return;
        }
        this.scan_cache_Lock_.lock();
        ScanCacheElem sce = this.scan_cache_.get(scannerId);
        ArrayDeque<MapRResult> list = sce.cachelist;
        assert (list.size() == 0);
        for (int i = numSkip; i < numGet && !res[i].isEmpty(); ++i) {
            list.add(res[i]);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug(">Inode Add to ScanCache " + list.size() + " " + sce.numScans);
            int count = 0;
            for (MapRResult mr : list) {
                byte[] key = new byte[mr.keyLength];
                System.arraycopy(mr.bufBytes, 0, key, 0, mr.keyLength);
                this.LOG.debug(">Inode add key " + new String(key) + " @ " + count);
                ++count;
            }
        }
        this.scan_cache_Lock_.unlock();
    }

    public void scanNext(long scannerId, int numRows, MapRResult[] res) throws IOException {
        long diff;
        long start = 0L;
        long end = 0L;
        int thresh = MapRClientImpl.getSlowOpsThreshold();
        if (thresh > 0) {
            start = System.currentTimeMillis();
        }
        this.scan_cache_Lock_.lock();
        ScanCacheElem sce = this.scan_cache_.get(scannerId);
        ArrayDeque<MapRResult> list = sce.cachelist;
        int numInCache = list.size();
        int numExist = numRows > numInCache ? numInCache : numRows;
        for (int i = 0; i < numExist; ++i) {
            res[i] = list.remove();
        }
        long numTimes = sce.numScans++;
        this.scan_cache_Lock_.unlock();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug(">Inode Got from ScanCache " + numInCache + " Using " + numExist + " scanned " + numTimes);
        }
        if (numExist == 0) {
            int numGet;
            this.scannerReleaseTempMemory(scannerId);
            int n = numTimes > 4L ? 1024 : (numGet = numRows <= 1 ? 100 : numRows);
            if (numRows > numGet) {
                numGet = numRows;
            }
            if (numGet > 1024) {
                numGet = 1024;
            }
            MapRResult[] myres = new MapRResult[numGet];
            for (int i = 0; i < numGet; ++i) {
                myres[i] = new MapRResult();
            }
            int err = MapRTableTools.ScanNext(this.clusterP, this.fileP, scannerId, numGet, myres);
            this.checkError(err);
            ParsedRow prow = new ParsedRow();
            for (int i = 0; i < numGet; ++i) {
                myres[i].DecodeByteBuf(prow);
            }
            int numFill = numRows <= numGet ? numRows : numGet;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug(" Got " + numFill + " " + numGet + " " + numRows + " " + numTimes);
            }
            for (int i = 0; i < numFill; ++i) {
                res[i] = myres[i];
            }
            this.addToScanCache(scannerId, myres, numRows, numGet);
        }
        if (thresh > 0 && (int)(diff = (end = System.currentTimeMillis()) - start) >= thresh) {
            System.err.println("scan() op for table " + this.filename() + " took " + diff + " ms");
        }
    }

    public void closeScanner(long scannerId) throws IOException {
        this.scan_cache_Lock_.lock();
        ScanCacheElem sce = this.scan_cache_.get(scannerId);
        ArrayDeque<MapRResult> list = sce.cachelist;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Found in ScanCache" + list.size());
        }
        list.clear();
        sce.numScans = 0L;
        this.scan_cache_.remove(scannerId);
        this.scan_cache_Lock_.unlock();
        this.sce_freelist_.add(sce);
        int err = MapRTableTools.ScannerClose(this.clusterP, this.fileP, scannerId);
        this.checkError(err);
    }

    public void scannerReleaseTempMemory(long scannerId) {
        MapRTableTools.ScannerClearOldBuffer(this.clusterP, this.fileP, scannerId);
    }

    public long getScanner(MapRScan scan) throws IOException {
        long id = MapRTableTools.GetScanner(this.clusterP, this.fileP, scan);
        if (id == 0L) {
            throw new IOException("Failed to create a scanner");
        }
        this.scan_cache_Lock_.lock();
        if (this.scan_cache_ == null) {
            this.scan_cache_ = new HashMap(4, 0.8f);
        }
        if (this.sce_freelist_ == null) {
            this.sce_freelist_ = new ConcurrentLinkedQueue();
        }
        ScanCacheElem sce = this.getScanCacheElem();
        this.scan_cache_.put(id, sce);
        this.scan_cache_Lock_.unlock();
        return id;
    }

    public byte[] getSchema(long version) {
        return MapRTableTools.GetSchema(this.clusterP, this.fileP, version);
    }

    public String getFamilyName(int id) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        err.error = 0;
        String name = MapRTableTools.GetColumnFamilyName(this.clusterP, this.fileP, id, err);
        this.checkError(err.error);
        return name;
    }

    public int getFamilyId(String fname) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        err.error = 0;
        int id = MapRTableTools.GetColumnFamilyId(this.clusterP, this.fileP, fname, err);
        this.checkError(err.error);
        return id;
    }

    public void increment(MapRIncrement incr, boolean shouldFlush) throws IOException {
        int err = MapRTableTools.IncrementRPC(this.clusterP, this.fileP, incr, shouldFlush);
        if (err != 0) {
            if (err < 0) {
                err = -err;
            }
            if (err == 22) {
                this.checkError(err, " Possible attempt to increment a non-integer cell.");
            } else {
                this.checkError(err);
            }
        }
    }

    public boolean checkAndPut(byte[] row, boolean useCf, int familyId, byte[] qualifier, byte[] value, MapRPut mput, boolean shouldFlush) throws IOException {
        mput.status = 0;
        int err = MapRTableTools.CheckAndPutOrDeleteRPC(this.clusterP, this.fileP, row, useCf, familyId, qualifier, value, mput, shouldFlush);
        if (err != 0 && mput.status == 0) {
            this.checkError(err);
        }
        return mput.status == 1;
    }

    public void delete(MapRPut[] mputs) throws IOException {
        int err = MapRTableTools.PutOrDeleteRPC(this.clusterP, this.fileP, mputs, true, true, false);
        this.checkError(err);
    }

    public boolean checkAndDelete(byte[] row, boolean useCf, int familyId, byte[] qualifier, byte[] value, MapRPut mput, boolean shouldFlush) throws IOException {
        mput.status = 0;
        int err = MapRTableTools.CheckAndPutOrDeleteRPC(this.clusterP, this.fileP, row, useCf, familyId, qualifier, value, mput, shouldFlush);
        if (err != 0 && mput.status == 0) {
            this.checkError(err);
        }
        return mput.status == 1;
    }

    public void append(MapRPut mput, boolean needResult, boolean shouldFlush) throws IOException {
        int err = MapRTableTools.AppendRPC(this.clusterP, this.fileP, mput, needResult, shouldFlush);
        this.checkError(err);
    }

    private void checkError(int err) throws IOException {
        this.checkError(err, "");
    }

    private void checkError(int err, String detail) throws IOException {
        if (err != 0) {
            if (err < 0) {
                err = -err;
            }
            StackTraceElement[] stackFrames = Thread.currentThread().getStackTrace();
            String op = "<unknown>";
            for (int frameIdx = 1; frameIdx < stackFrames.length; ++frameIdx) {
                String method = stackFrames[frameIdx].getMethodName();
                if (method.equals("checkError")) continue;
                op = method;
                break;
            }
            IOException ioex = null;
            String msg = String.format("%s() on '%s' failed with error: %s (%d).%s", op, this.filename_, Errno.toString(err), err, detail);
            switch (err) {
                case 2: {
                    ioex = new FileNotFoundException(msg);
                    break;
                }
                case 13: {
                    msg = String.format("User '%s' (user id %d) does not have permission for %s() on '%s'.%s", this.userInfo_.userName, this.userInfo_.GetUserID(), op, this.filename_, detail);
                    ioex = new AccessControlException(msg);
                    break;
                }
                case 116: {
                    this.isStale_ = true;
                    ioex = new StaleFileException(msg);
                    break;
                }
                default: {
                    ioex = new IOException(msg);
                }
            }
            this.LOG.error(msg);
            throw ioex;
        }
    }

    static class List<E> {
        ListElem<E> head_;
        ListElem<E> tail_;

        List() {
        }

        void add(ListElem<E> e) {
            if (e.inList) {
                return;
            }
            e.inList = true;
            e.next = null;
            e.prev = this.tail_;
            if (this.tail_ != null) {
                this.tail_.next = e;
            } else {
                this.head_ = e;
            }
            this.tail_ = e;
        }

        void remove(ListElem<E> e) {
            if (!e.inList) {
                return;
            }
            e.inList = false;
            ListElem p = e.prev;
            ListElem n = e.next;
            if (p != null) {
                p.next = n;
            } else {
                this.head_ = n;
            }
            if (n != null) {
                n.prev = p;
            } else {
                this.tail_ = p;
            }
        }

        E first() {
            return this.head_ != null ? (E)this.head_.elem : null;
        }
    }

    static class ListElem<E> {
        public ListElem<E> prev;
        public ListElem<E> next;
        public E elem;
        public boolean inList;

        ListElem(E e) {
            this.elem = e;
            this.inList = false;
            this.next = null;
            this.prev = null;
        }
    }

    static class ICache {
        Page[] tab_;
        int size_;

        ICache(int numEntries) {
            this.size_ = numEntries + 1;
            this.tab_ = new Page[this.size_];
        }

        int hash(InodeAttributes a, long pageId) {
            return (int)pageId % this.size_;
        }

        Page lookup(InodeAttributes iattr, long pageId) {
            Page p = this.tab_[this.hash(iattr, pageId)];
            while (p != null && !p.eq(iattr, pageId)) {
                p = p.hnext;
            }
            return p;
        }

        void remove(Page page) {
            int hv = this.hash(page.iattr, page.pageId);
            Page p = this.tab_[hv];
            Page prev = null;
            while (p != null && !p.eq(page)) {
                prev = p;
                p = p.hnext;
            }
            if (p != null) {
                if (prev != null) {
                    prev.hnext = p.hnext;
                } else {
                    this.tab_[hv] = p.hnext;
                }
            }
        }

        void insert(Page p) {
            int hv = this.hash(p.iattr, p.pageId);
            p.hnext = this.tab_[hv];
            this.tab_[hv] = p;
        }
    }

    static class CmpPageId
    implements Comparator<Page> {
        CmpPageId() {
        }

        @Override
        public int compare(Page p1, Page p2) {
            long res = p2.pageId - p1.pageId;
            if (res < 0L) {
                return -1;
            }
            if (res > 0L) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            return false;
        }
    }

    public class ScanCacheElem {
        long numScans;
        ArrayDeque<MapRResult> cachelist;

        public ScanCacheElem(ArrayDeque<MapRResult> list) {
            this.cachelist = list;
            this.numScans = 0L;
        }
    }
}

