/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.WritableUtils;

public final class FidInfo {
    public int cid;
    public int cinum;
    public int uniq;
    public long[] ips = new long[0];
    String fidStr;

    public FidInfo() {
        this.uniq = -1;
        this.cinum = -1;
        this.cid = -1;
    }

    public FidInfo(int cid, int cinum, int uniq, long[] ips) {
        this.cid = cid;
        this.cinum = cinum;
        this.uniq = uniq;
        this.ips = (long[])ips.clone();
    }

    public void writeFields(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.cid);
        WritableUtils.writeVInt(out, this.cinum);
        WritableUtils.writeVInt(out, this.uniq);
        WritableUtils.writeVInt(out, this.ips.length);
        for (long l : this.ips) {
            WritableUtils.writeVLong(out, l);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.cid = WritableUtils.readVInt(in);
        this.cinum = WritableUtils.readVInt(in);
        this.uniq = WritableUtils.readVInt(in);
        this.ips = new long[WritableUtils.readVInt(in)];
        for (int i = 0; i < this.ips.length; ++i) {
            this.ips[i] = WritableUtils.readVLong(in);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof FidInfo)) {
            return false;
        }
        FidInfo otherFileId = (FidInfo)other;
        return otherFileId.cid == this.cid && otherFileId.cinum == this.cinum && otherFileId.uniq == this.uniq && Arrays.equals(otherFileId.ips, this.ips);
    }

    public String toString() {
        return this.getClass() + "[ fid: " + this.cid + "." + this.cinum + "." + this.uniq + ", ipaddrs: " + Arrays.toString(this.ips) + " ]";
    }

    public String getFidStr() {
        if (this.fidStr == null) {
            this.fidStr = this.cid + "." + this.cinum + "." + this.uniq;
        }
        return this.fidStr;
    }
}

