/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.zookeeper;

import com.mapr.baseutils.zookeeper.ZKClosedException;
import java.io.IOException;
import java.util.List;
import oadd.org.apache.log4j.Logger;
import oadd.org.apache.zookeeper.KeeperException;
import oadd.org.apache.zookeeper.Watcher;
import oadd.org.apache.zookeeper.ZooKeeper;
import oadd.org.apache.zookeeper.data.Stat;

public class ZKUtils {
    public static final int ZK_RETRIALS = 3;
    public static final int TIMEOUT = 30000;
    public static final int TIMEOUT_SERVER = 30000;
    public static final String SERVICE_MASTER_NODE = "master";
    private static final Logger LOG = Logger.getLogger(ZKUtils.class);

    public static byte[] getData(ZooKeeper s_zk, String nodeName, Watcher watcher, Stat stat, int retrials) throws KeeperException, InterruptedException, ZKClosedException {
        try {
            return s_zk.getData(nodeName, watcher, stat);
        }
        catch (KeeperException.ConnectionLossException e) {
            LOG.error((Object)"Lost connection to ZK while trying to get data. Reconnecting...");
            if (retrials > 0 && s_zk.getState().isAlive()) {
                return ZKUtils.getData(s_zk, nodeName, watcher, stat, retrials - 1);
            }
            if (!s_zk.getState().isAlive()) {
                LOG.error((Object)("ZK is not alive. Throwing KeeperException after retrials: " + retrials));
            }
            throw new ZKClosedException(e);
        }
        catch (KeeperException.SessionExpiredException see) {
            LOG.error((Object)("ZK Session expired. Need to reset ZK completely for node: " + nodeName));
            throw new ZKClosedException(see);
        }
    }

    public static Stat checkZKNodeForExistence(ZooKeeper s_zk, String nodeName, Watcher watcher, int retrials) throws KeeperException, InterruptedException, ZKClosedException {
        try {
            return s_zk.exists(nodeName, watcher);
        }
        catch (KeeperException.ConnectionLossException e) {
            LOG.error((Object)(Thread.currentThread().getId() + " Lost connection to ZK while trying to get data. Reconnecting..."));
            if (retrials > 0 && s_zk.getState().isAlive()) {
                return ZKUtils.checkZKNodeForExistence(s_zk, nodeName, watcher, retrials - 1);
            }
            if (!s_zk.getState().isAlive()) {
                LOG.error((Object)("ZK is not alive. Throwing KeeperException after retrials: " + retrials));
            }
            throw new ZKClosedException(e);
        }
        catch (KeeperException.SessionExpiredException see) {
            LOG.error((Object)("ZK Session expired. Need to reset ZK completely for node: " + nodeName));
            throw new ZKClosedException(see);
        }
    }

    public static List<String> getZkNodeChildren(ZooKeeper s_zk, String nodeName, Watcher watcher, int retrials) throws KeeperException, InterruptedException, ZKClosedException {
        try {
            return s_zk.getChildren(nodeName, watcher);
        }
        catch (KeeperException.ConnectionLossException e) {
            LOG.error((Object)(Thread.currentThread().getId() + " Lost connection to ZK while trying to get data. Reconnecting..."));
            if (retrials > 0 && s_zk.getState().isAlive()) {
                return ZKUtils.getZkNodeChildren(s_zk, nodeName, watcher, retrials - 1);
            }
            if (!s_zk.getState().isAlive()) {
                LOG.error((Object)("ZK is not alive. Throwing KeeperException after retrials: " + retrials));
            }
            throw new ZKClosedException(e);
        }
        catch (KeeperException.SessionExpiredException see) {
            LOG.error((Object)("ZK Session expired. Need to reset ZK completely for node: " + nodeName));
            throw new ZKClosedException(see);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetZookeeper(String zkAddresses, ZooKeeper s_zk, Watcher watcher) throws IOException {
        block5: {
            if (s_zk != null) {
                try {
                    s_zk.close();
                }
                catch (InterruptedException e) {
                    if (!LOG.isInfoEnabled()) break block5;
                    LOG.info((Object)"Interrupted Exception during ZK closure", (Throwable)e);
                }
            }
        }
        s_zk = null;
        s_zk = new ZooKeeper(zkAddresses, 30000, watcher);
    }
}

