/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.avatica;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.hydromatic.avatica.ColumnMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayImpl
implements Array {
    private final ColumnMetaData.AvaticaType elementType;
    private final Factory factory;
    private final List list;

    public ArrayImpl(List list, ColumnMetaData.AvaticaType elementType, Factory factory) {
        this.list = list;
        this.elementType = elementType;
        this.factory = factory;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.elementType.typeName;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.elementType.type;
    }

    @Override
    public Object getArray() throws SQLException {
        return this.getArray(this.list);
    }

    protected Object getArray(List list) throws SQLException {
        int i = 0;
        switch (this.elementType.representation) {
            case PRIMITIVE_DOUBLE: {
                double[] doubles = new double[list.size()];
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    double v = (Double)i$.next();
                    doubles[i++] = v;
                }
                return doubles;
            }
            case PRIMITIVE_FLOAT: {
                float[] floats = new float[list.size()];
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    float v = ((Float)i$.next()).floatValue();
                    floats[i++] = v;
                }
                return floats;
            }
            case PRIMITIVE_INT: {
                int[] ints = new int[list.size()];
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    int v = (Integer)i$.next();
                    ints[i++] = v;
                }
                return ints;
            }
            case PRIMITIVE_LONG: {
                long[] longs = new long[list.size()];
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    long v = (Long)i$.next();
                    longs[i++] = v;
                }
                return longs;
            }
            case PRIMITIVE_SHORT: {
                short[] shorts = new short[list.size()];
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    short v = (Short)i$.next();
                    shorts[i++] = v;
                }
                return shorts;
            }
            case PRIMITIVE_BOOLEAN: {
                boolean[] booleans = new boolean[list.size()];
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    boolean v = (Boolean)i$.next();
                    booleans[i++] = v;
                }
                return booleans;
            }
            case PRIMITIVE_BYTE: {
                byte[] bytes = new byte[list.size()];
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    byte v = (Byte)i$.next();
                    bytes[i++] = v;
                }
                return bytes;
            }
            case PRIMITIVE_CHAR: {
                char[] chars = new char[list.size()];
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    char v = ((Character)i$.next()).charValue();
                    chars[i++] = v;
                }
                return chars;
            }
        }
        Object[] objects = list.toArray();
        switch (this.elementType.type) {
            case 2003: {
                ColumnMetaData.ArrayType arrayType = (ColumnMetaData.ArrayType)this.elementType;
                for (i = 0; i < objects.length; ++i) {
                    objects[i] = new ArrayImpl((List)objects[i], arrayType.component, this.factory);
                }
                break;
            }
        }
        return objects;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        return this.getArray(this.list.subList((int)index, count));
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.factory.create(this.elementType, this.list);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void free() throws SQLException {
    }

    public static interface Factory {
        public ResultSet create(ColumnMetaData.AvaticaType var1, Iterable var2);
    }
}

